/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.inspection;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.InspectionRepairResult;
import kd.tmc.fpm.business.domain.enums.InspectionScope;
import kd.tmc.fpm.business.domain.enums.InspectionTargetType;
import kd.tmc.fpm.business.domain.enums.InspectionType;
import kd.tmc.fpm.business.domain.model.inspection.ControlRepairInfo;
import kd.tmc.fpm.business.domain.model.inspection.header.RepairHeader;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.service.inspection.context.RepairContext;
import kd.tmc.fpm.business.mvc.service.inspection.factory.DataRepairServiceFactory;
import kd.tmc.fpm.business.mvc.service.inspection.factory.InspectContextFactory;
import kd.tmc.fpm.business.mvc.service.inspection.repair.IInspectDataRepair;
import org.apache.commons.collections.CollectionUtils;

public class InspectionRepairTaskService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(InspectionRepairTaskService.class);

    public List<String> getSelector() {
        List selectors = super.getSelector();
        selectors.add("inspectionscope");
        selectors.add("exec_period_scope");
        selectors.add("exec_org_scope");
        selectors.add("startdate");
        selectors.add("enddate");
        selectors.add("inspectiontype");
        selectors.add("billno");
        selectors.add("inspection_config");
        selectors.add("entry_result_detail");
        selectors.add("entry_exec_record");
        selectors.add(String.join((CharSequence)".", "entry_exec_record", "e_exec_record"));
        selectors.add(String.join((CharSequence)".", "entry_exec_record", "e_exec_repairresult"));
        selectors.add(String.join((CharSequence)".", "entry_error_bizinfo", "a_resultentryid"));
        selectors.add(String.join((CharSequence)".", "entry_error_bizinfo", "a_bizbillid"));
        selectors.add(String.join((CharSequence)".", "entry_result_detail", "e_detail_repairreuslt"));
        selectors.add(String.join((CharSequence)".", "entry_result_detail", "e_detail_inspecttarget"));
        selectors.add(String.join((CharSequence)".", "entry_result_detail", "e_detail_bizobj"));
        return selectors;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        logger.info("\u5f00\u59cb\u6267\u884c\u6570\u636e\u4fee\u590d\u4efb\u52a1");
        for (DynamicObject inspectionLog : dynamicObjects) {
            RepairContext repairContext;
            IInspectDataRepair inspectDataRepairService;
            FpmOperateResult<Object> fpmOperateResult;
            RepairHeader repairHeader = this.wrapperHeader(inspectionLog);
            if (Objects.isNull(repairHeader) || (fpmOperateResult = (inspectDataRepairService = DataRepairServiceFactory.getInspectDataRepairService(repairContext = InspectContextFactory.getRepairContext(repairHeader))).inspectDataRepair(repairContext)).isSuccess()) continue;
            logger.error("\u6267\u884c\u5de1\u68c0\u5931\u8d25 ", fpmOperateResult.getMessageList());
            String errMsg = ResManager.loadKDString((String)"\u6267\u884c\u6570\u636e\u4fee\u590d\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RepairDataTask_1", (String)"tmc-fpm-business", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        logger.info("\u6570\u636e\u4fee\u590d\u4efb\u52a1\u6267\u884c\u7ed3\u675f");
    }

    private RepairHeader wrapperHeader(DynamicObject inspectionLog) {
        String inspectionScope;
        switch (inspectionScope = inspectionLog.getString("inspectionscope")) {
            case "BILL_NOT_EXIST": {
                return this.wrapperBillNotExitHeader(inspectionLog);
            }
            case "BILL_INSPECTION": {
                return this.wrapperBIllInspectionHeader(inspectionLog);
            }
            case "REPORT_INSPECTION": {
                return this.wrapperAmtConsistencyHeader(inspectionLog);
            }
        }
        return new RepairHeader();
    }

    private RepairHeader wrapperAmtConsistencyHeader(DynamicObject inspectionLog) {
        RepairHeader header = new RepairHeader();
        header.setInspectionLogId((Long)inspectionLog.getPkValue());
        header.setInspectionConfigId(inspectionLog.getLong("inspection_config.id"));
        header.setInspectionScope(ITypeEnum.getByNumber(inspectionLog.getString("inspectionscope"), InspectionScope.class));
        header.setInspectionType(ITypeEnum.getByNumber(inspectionLog.getString("inspectiontype"), InspectionType.class));
        DynamicObjectCollection periodScopeColl = inspectionLog.getDynamicObjectCollection("exec_period_scope");
        if (CollectionUtils.isNotEmpty((Collection)periodScopeColl)) {
            List<Long> periodScope = periodScopeColl.stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setPeriodScope(periodScope);
        } else {
            Date startDate = inspectionLog.getDate("startdate");
            Date endDate = inspectionLog.getDate("enddate");
            header.setEndDate(endDate);
            header.setStartDate(startDate);
        }
        DynamicObjectCollection orgScopeCollection = inspectionLog.getDynamicObjectCollection("exec_org_scope");
        if (CollectionUtils.isNotEmpty((Collection)orgScopeCollection)) {
            List<Long> orgScope = orgScopeCollection.stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setOrgScope(orgScope);
        }
        return header;
    }

    private RepairHeader wrapperBIllInspectionHeader(DynamicObject inspectionLog) {
        RepairHeader header = new RepairHeader();
        DynamicObject config = inspectionLog.getDynamicObject("inspection_config");
        Long id = (Long)inspectionLog.getPkValue();
        header.setInspectionLogId(id);
        header.setInspectionConfigId((Long)config.getPkValue());
        header.setInspectionScope(ITypeEnum.getByNumber(inspectionLog.getString("inspectionscope"), InspectionScope.class));
        header.setInspectionType(ITypeEnum.getByNumber(inspectionLog.getString("inspectiontype"), InspectionType.class));
        DynamicObjectCollection entryEntity = inspectionLog.getDynamicObjectCollection("entry_result_detail");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entryEntity)) {
            return null;
        }
        DynamicObjectCollection billBizEntry = inspectionLog.getDynamicObjectCollection("entry_error_bizinfo");
        Map<Long, List<DynamicObject>> listMap = billBizEntry.stream().collect(Collectors.groupingBy(dy -> dy.getLong("a_resultentryid")));
        for (DynamicObject dynamicObject : entryEntity) {
            List<DynamicObject> billIdList;
            String repairResult = dynamicObject.getString("e_detail_repairreuslt");
            if (EmptyUtil.isEmpty((String)repairResult) || Objects.equals(InspectionRepairResult.REPAIRED.getNumber(), repairResult) || EmptyUtil.isEmpty(billIdList = listMap.get(dynamicObject.getLong("id")))) continue;
            String inspectTarget = dynamicObject.getString("e_detail_inspecttarget");
            String entityType = (String)dynamicObject.getDynamicObject("e_detail_bizobj").getPkValue();
            ControlRepairInfo controlRepairInfo = new ControlRepairInfo(ITypeEnum.getByNumber(inspectTarget, InspectionTargetType.class));
            controlRepairInfo.setEntityType(entityType);
            controlRepairInfo.setLogDetailEntryId(dynamicObject.getLong("id"));
            controlRepairInfo.setInspectionTargetType(InspectionTargetType.getByCode(inspectTarget));
            billIdList.stream().map(dy -> new ControlRepairInfo.LogBillInfo(dy.getLong("id"), dy.getLong("a_bizbillid"))).forEach(controlRepairInfo::addLogBillInfo);
            header.addControlRepairInfo(controlRepairInfo);
        }
        return header;
    }

    private RepairHeader wrapperBillNotExitHeader(DynamicObject inspectionLog) {
        RepairHeader header = new RepairHeader();
        header.setInspectionLogId((Long)inspectionLog.getPkValue());
        header.setInspectionConfigId(inspectionLog.getLong("inspection_config.id"));
        header.setInspectionScope(ITypeEnum.getByNumber(inspectionLog.getString("inspectionscope"), InspectionScope.class));
        header.setInspectionType(ITypeEnum.getByNumber(inspectionLog.getString("inspectiontype"), InspectionType.class));
        DynamicObjectCollection execRecordColl = inspectionLog.getDynamicObjectCollection("entry_exec_record");
        List<Long> execRecordIdList = execRecordColl.stream().filter(dynamicObject -> Objects.nonNull(dynamicObject.getDynamicObject("e_exec_record"))).filter(dynamicObject -> InspectionRepairResult.PENDING.getNumber().equals(dynamicObject.getString("e_exec_repairresult"))).map(dynamicObject -> dynamicObject.getLong("e_exec_record.id")).collect(Collectors.toList());
        header.setExecRecordIdList(execRecordIdList);
        return header;
    }
}

