/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.report;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.service.IPlanChangeBizService;
import kd.tmc.fpm.business.mvc.service.impl.PlanChangeBizServiceImpl;

public class ReportChangeAuditService
extends AbstractTmcBizOppService {
    private IPlanChangeBizService changeBizService = new PlanChangeBizServiceImpl();

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("billstatus");
        selector.add("bodysys.id");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        for (DynamicObject dynamicObject : dynamicObjects) {
            long id = dynamicObject.getLong("id");
            long sysId = dynamicObject.getLong("bodysys.id");
            FpmOperateResult<Void> audit = this.changeBizService.asyncAudit(id, sysId);
            if (audit.isSuccess()) continue;
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setLevel(ErrorLevel.Error);
            operateErrorInfo.setMessage(dynamicObject.get("billno") + ":" + String.join((CharSequence)";", audit.getMessageList()));
            operateErrorInfo.setPkValue(dynamicObject.getPkValue());
            this.operationResult.addErrorInfo(operateErrorInfo);
            this.operationResult.setSuccess(false);
            dynamicObject.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
        }
    }
}

