/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.dataproc.save.impl.DataSaveServiceImpl;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;
import kd.tmc.fpm.business.domain.enums.TaskStatus;
import kd.tmc.fpm.business.domain.enums.TaskType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.task.TaskRecord;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mq.TMCMQPublisher;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.service.impl.ReportBizService;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskHandleService;
import kd.tmc.fpm.business.mvc.service.seqtask.impl.TaskHandleServiceImpl;
import kd.tmc.fpm.business.opservice.report.mutex.MutexRequestInfo;
import kd.tmc.fpm.business.opservice.report.mutex.ReportMutexLockService;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.common.bean.FpmContext;
import kd.tmc.fpm.common.enums.MQBusinessTypeEnum;
import kd.tmc.fpm.common.helper.StringHelper;

public class ReportPlanAuditService
extends AbstractTmcBizOppService {
    private final ReportBizService reportBizService = new ReportBizService();
    private final TaskHandleService taskHandleService = new TaskHandleServiceImpl();
    private ReportMutexLockService reportMutexLockService;
    private final IDataSaveService dataSaveService = new DataSaveServiceImpl();
    private final Map<Long, Long> sumConfigReportIdMap = new HashMap<Long, Long>(16);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("informant");
        selector.add("initflag");
        selector.add("bodysys");
        selector.add("billno");
        selector.add("id");
        selector.add("name");
        selector.add("declaredeadline");
        selector.add("template.templatetype");
        selector.add("template.ismaintable");
        selector.add("reportorg.id");
        selector.add("templatebak.templateid");
        selector.add("reportperiod.reporttype.id");
        selector.add("reportperiod.id");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        FpmContext fpmContext = FpmContext.get();
        try {
            this.initFpmContextIfNeed(dynamicObjects);
            if (!this.reportMutexLockService.isLocked()) {
                this.sendMessageIfMainReport(dynamicObjects);
                return;
            }
            this.doProcessWithInLock(dynamicObjects);
        }
        finally {
            fpmContext.clear();
        }
    }

    private void doProcessWithInLock(DynamicObject[] dynamicObjects) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            this.doAudit(dynamicObject);
        }
    }

    private void doAudit(DynamicObject dynamicObject) {
        FpmContext fpmContext = FpmContext.get();
        List<Long> subReportIdList = this.getSubReportIdList(dynamicObject);
        long periodId = dynamicObject.getLong("reportperiod.id");
        fpmContext.put("periodId", (Object)periodId);
        long reportOrgId = dynamicObject.getLong("reportorg.id");
        FpmOperateResult<Void> audit = this.reportBizService.auditReport(dynamicObject.getLong("id"), subReportIdList, this.sumConfigReportIdMap.get(reportOrgId), dynamicObject.getBoolean("template.ismaintable"));
        if (!audit.isSuccess()) {
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setLevel(ErrorLevel.Error);
            operateErrorInfo.setMessage(dynamicObject.get("billno") + ":" + String.join((CharSequence)";", audit.getMessageList()));
            operateErrorInfo.setPkValue(dynamicObject.getPkValue());
            this.operationResult.addErrorInfo(operateErrorInfo);
            this.operationResult.setSuccess(false);
            dynamicObject.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
        }
    }

    private List<Long> getSubReportIdList(DynamicObject dynamicObject) {
        ArrayList<Long> subIdList = new ArrayList<Long>(16);
        if (!dynamicObject.getBoolean("template.ismaintable")) {
            return subIdList;
        }
        String selectFields = String.join((CharSequence)",", "id", "name", "billstatus");
        DynamicObject[] subReportDYArr = TmcDataServiceHelper.load((String)"fpm_report", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("parenttemplate.id", "=", dynamicObject.get("templatebak.templateid")), new QFilter("reportperiod", "=", dynamicObject.get("reportperiod.id")), new QFilter("reportorg", "=", dynamicObject.get("reportorg.id"))});
        return Arrays.stream(subReportDYArr).map(item -> item.getLong("id")).collect(Collectors.toList());
    }

    private void sendMessageIfMainReport(DynamicObject[] dynamicObjects) {
        List<MutexRequestInfo> mutexRequestInfoList = this.reportMutexLockService.getMutexRequestInfoList();
        Deque<Long> deque = CommonUtils.batchGenerateIds(mutexRequestInfoList.size());
        Map mutexRequestInfoMap = mutexRequestInfoList.stream().collect(Collectors.toMap(MutexRequestInfo::getReportPlanId, Function.identity(), (a, b) -> a));
        for (DynamicObject dynamicObject : dynamicObjects) {
            boolean mainTable = dynamicObject.getBoolean("template.ismaintable");
            long reportId = dynamicObject.getLong("id");
            if (!mainTable) {
                this.reportBizService.auditReport(reportId, Collections.emptyList(), null, false);
                continue;
            }
            MutexRequestInfo mutexRequestInfo = (MutexRequestInfo)mutexRequestInfoMap.get(reportId);
            List<Long> subReportIdList = this.getSubReportIdList(dynamicObject);
            if (mutexRequestInfo == null) {
                this.doAudit(dynamicObject);
                continue;
            }
            Map<String, String> taskInfoMap = mutexRequestInfo.toMap();
            taskInfoMap.put("subIdList", subReportIdList.stream().map(StringHelper::getStringValue).collect(Collectors.joining(",")));
            taskInfoMap.put("systemId", String.valueOf(dynamicObject.getLong("bodysys.id")));
            long periodId = dynamicObject.getLong("reportperiod.id");
            taskInfoMap.put("periodId", String.valueOf(periodId));
            TaskRecord taskRecord = TaskRecord.builder().id(deque.poll()).taskType(TaskType.REPORT_PLAN_AUDIT.name()).objectId(reportId).name("reportPlanAudit").taskNum(0).createTime(new Date()).groupId(mutexRequestInfo.getWaitLockReportId()).objectEntityNumber("fpm_report").status(TaskStatus.WAITING.name()).taskInfo(SerializationUtils.toJsonString(taskInfoMap)).build();
            this.taskHandleService.saveTaskIfNotRepeat(taskRecord);
            TMCMQPublisher.sendFpmDefaultMsg(MQBusinessTypeEnum.LOCAL_SEQUENT_TASK, SerializationUtils.toJsonString((Object)taskRecord));
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        if (this.reportMutexLockService.isLocked()) {
            return;
        }
        List<MutexRequestInfo> mutexRequestInfoList = this.reportMutexLockService.getMutexRequestInfoList();
        this.dataSaveService.updateAndCheckResult(() -> "update t_fpm_report set fbillstatus=? where fid=?", mutexRequestInfoList, (t, d) -> {
            d.add(ReportProcessStatus.SUBMIT.getValue());
            d.add(t.getReportPlanId());
        });
        String message = ResManager.loadKDString((String)"\u6570\u636e\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u3002", (String)"ReportPlanAuditService_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.getOperationResult().setMessage(message);
        this.getOperationResult().setShowMessage(false);
    }

    private void initFpmContextIfNeed(DynamicObject[] dynamicObjects) {
        Optional<DynamicObject> first = Arrays.stream(dynamicObjects).filter(dy -> dy.getBoolean("template.ismaintable")).findFirst();
        if (!first.isPresent()) {
            return;
        }
        FpmContext fpmContext = FpmContext.get();
        FundPlanSystem system = new DimensionRepository().loadSystem(dynamicObjects[0].getLong("bodysys.id"));
        fpmContext.put("fundSystem", (Object)system);
        Map dimMemberMap = system.getDimList().stream().map(Dimension::getAllDimMemberList).flatMap(Collection::stream).collect(Collectors.toMap(DimMember::getId, Function.identity()));
        fpmContext.put("dimMemberMap", dimMemberMap);
    }

    public void beforeProcess(List<ExtendedDataEntity> dataEntities) throws KDException {
        super.beforeProcess(dataEntities);
        this.reportMutexLockService = new ReportMutexLockService(MutexRequestInfo.getMutexRequestInfoList(dataEntities.stream().map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList()), this.sumConfigReportIdMap));
        this.reportMutexLockService.tryLock();
    }

    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        if (Objects.nonNull(this.reportMutexLockService)) {
            this.reportMutexLockService.unLock();
        }
    }
}

