/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.report;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;
import kd.tmc.fpm.business.domain.enums.SourceBillType;

public class ReportPlanExecBiasAnalysService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(ReportPlanExecBiasAnalysService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("bodysys");
        selector.add("reportorg");
        selector.add("templatebak");
        selector.add("reportperiod");
        selector.add("exratetable");
        selector.add("exchangeratedate");
        selector.add("declarestartdate");
        selector.add("declaredeadline");
        selector.add("name");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        logger.info("\u5f00\u59cb\u751f\u6210\u6267\u884c\u504f\u5dee\u5206\u6790\u5355\u636e");
        Map billNos = this.getOperationResult().getBillNos();
        billNos.clear();
        for (DynamicObject report : dynamicObjects) {
            DynamicObject newDO = TmcDataServiceHelper.newDynamicObject((String)"fpm_execbiasanalys");
            newDO.set("bodysys", report.get("bodysys"));
            newDO.set("reportorg", report.get("reportorg"));
            DynamicObject templateBak = report.getDynamicObject("templatebak");
            DynamicObject reportPeriod = report.getDynamicObject("reportperiod");
            newDO.set("reporttype", (Object)reportPeriod.getLong(String.join((CharSequence)".", "reporttype", "id")));
            newDO.set("reportperiod", report.get("reportperiod"));
            newDO.set("sourcebilltype", (Object)SourceBillType.REPORT.getValue());
            newDO.set("sourcebill", report.getPkValue());
            newDO.set("exratetable", report.get("exratetable"));
            newDO.set("exchangeratedate", report.get("exchangeratedate"));
            newDO.set("amountunit", templateBak.get("amountunit"));
            newDO.set("declarestartdate", report.get("declarestartdate"));
            newDO.set("declaredeadline", report.get("declaredeadline"));
            newDO.set("name", report.get("name"));
            newDO.set("source", (Object)"1");
            newDO.set("planstatus", report.get("planstatus"));
            newDO.set("billno", (Object)CodeRuleHelper.generateNumber((String)"fpm_execbiasanalys", (DynamicObject)newDO, null, (String)""));
            newDO.set("billstatus", (Object)ReportProcessStatus.SAVE.getValue());
            newDO.set("creator", (Object)RequestContext.get().getCurrUserId());
            Object[] result = TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{newDO});
            DynamicObject[] execBiasAnalysDO = (DynamicObject[])result;
            billNos.put(report.getString("billno"), execBiasAnalysDO[0].getString("id"));
        }
    }

    public void afterProcess(DynamicObject[] dynamicObjects) throws KDException {
        List reportIds = Arrays.stream(dynamicObjects).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(reportIds)) {
            DynamicObject[] reportBills = TmcDataServiceHelper.load((Object[])reportIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_report"));
            Arrays.stream(reportBills).forEach(c -> c.set("isexecbiasanalys", (Object)"1"));
            TmcDataServiceHelper.save((DynamicObject[])reportBills);
        }
    }
}

