/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.report;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.common.enums.ReportPlanStatusEnum;

public class ReportPlanRepulseService
extends AbstractTmcBizOppService {
    private IDataSaveService dataSaveService = FpmServiceFactory.getBizService(IDataSaveService.class);
    private IReportRepository reportRepository = FpmServiceFactory.getBizService(IReportRepository.class);

    public void process(DynamicObject[] dataEntities) throws KDException {
        List successPkIds;
        List<Object> reportIds = Arrays.stream(dataEntities).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        OperationResult operationResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"unaudit", (String)"fpm_report_process", (Object[])reportIds.toArray(new Object[0]), (OperateOption)OperateOption.create());
        if (!operationResult.isSuccess()) {
            ValidateResultCollection validateResult = operationResult.getValidateResult();
            validateResult.getValidateErrors().forEach(v -> this.getOperationResult().getValidateResult().addValidateError(v.getValidatorKey(), v));
        }
        if (EmptyUtil.isEmpty((Collection)(successPkIds = operationResult.getSuccessPkIds()))) {
            return;
        }
        String backReason = (String)this.getOperationVariable().get("repulse");
        this.dataSaveService.updateAndCheckResult(() -> "update t_fpm_report set fplanstatus=?,freturncomments=? where fid =?", successPkIds, (t, d) -> {
            d.add(ReportPlanStatusEnum.BEBACK.getValue());
            d.add(backReason);
            d.add(t);
        });
        for (Object reportId : successPkIds) {
            List<Long> childReportIds = this.reportRepository.querySubReportId((Long)reportId);
            if (EmptyUtil.isEmpty(childReportIds)) {
                return;
            }
            this.dataSaveService.updateAndCheckResult(() -> "update t_fpm_report set fplanstatus=?,freturncomments=? where fid =?", childReportIds, (t, d) -> {
                d.add(ReportPlanStatusEnum.BEBACK.getValue());
                d.add(backReason);
                d.add(t);
            });
        }
    }
}

