/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.report;

import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.dataproc.save.impl.DataSaveServiceImpl;
import kd.tmc.fpm.business.domain.enums.ReportOpType;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;
import kd.tmc.fpm.business.domain.enums.TaskStatus;
import kd.tmc.fpm.business.domain.enums.TaskType;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.task.TaskRecord;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mq.TMCMQPublisher;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.mvc.service.impl.ReportBizService;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskHandleService;
import kd.tmc.fpm.business.mvc.service.seqtask.impl.TaskHandleServiceImpl;
import kd.tmc.fpm.business.opservice.report.mutex.MutexRequestInfo;
import kd.tmc.fpm.business.opservice.report.mutex.ReportMutexLockService;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.common.enums.MQBusinessTypeEnum;

public class ReportPlanUnAuditService
extends AbstractTmcBizOppService {
    private final ReportBizService reportBizService = new ReportBizService();
    private final ReportRepository repository = new ReportRepository();
    private ReportMutexLockService reportMutexLockService;
    private final IDataSaveService dataSaveService = new DataSaveServiceImpl();
    private final TaskHandleService taskHandleService = new TaskHandleServiceImpl();

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bodysys");
        selector.add("billno");
        selector.add("id");
        selector.add("template.ismaintable");
        selector.add("reportorg");
        selector.add("reportperiod.reporttype.id");
        selector.add("reportperiod.id");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        String reportOpType = (String)this.getOperationVariable().get("ReportOpType");
        if (ReportOpType.SERVICE.getNumber().equals(reportOpType)) {
            return;
        }
        if (!this.reportMutexLockService.isLocked()) {
            this.sendMessageIfMainReport(dynamicObjects);
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            this.doUnAudit(dynamicObject);
        }
    }

    private void doUnAudit(DynamicObject dynamicObject) {
        Report report = this.repository.loadReportWithAllDimension(dynamicObject.getLong("id"));
        FpmOperateResult unAudit = this.reportBizService.unAuditReport(report, ReportOpType.OP);
        if (!unAudit.isSuccess()) {
            String errMsg = dynamicObject.get("billno") + ":" + String.join((CharSequence)";", unAudit.getMessageList());
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setLevel(ErrorLevel.Error);
            operateErrorInfo.setMessage(errMsg);
            operateErrorInfo.setPkValue(dynamicObject.getPkValue());
            this.operationResult.addErrorInfo(operateErrorInfo);
            this.operationResult.setSuccess(false);
            dynamicObject.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        }
    }

    private void sendMessageIfMainReport(DynamicObject[] dynamicObjects) {
        List<MutexRequestInfo> mutexRequestInfoList = this.reportMutexLockService.getMutexRequestInfoList();
        Deque<Long> deque = CommonUtils.batchGenerateIds(mutexRequestInfoList.size());
        Map mutexRequestInfoMap = mutexRequestInfoList.stream().collect(Collectors.toMap(MutexRequestInfo::getReportPlanId, Function.identity(), (a, b) -> a));
        for (DynamicObject dynamicObject : dynamicObjects) {
            long reportId = dynamicObject.getLong("id");
            MutexRequestInfo mutexRequestInfo = (MutexRequestInfo)mutexRequestInfoMap.get(reportId);
            if (Objects.isNull(mutexRequestInfo)) {
                this.doUnAudit(dynamicObject);
                continue;
            }
            TaskRecord taskRecord = TaskRecord.builder().id(deque.poll()).taskType(TaskType.REPORT_PLAN_UN_AUDIT.name()).objectId(reportId).name("reportPlanUnAudit").taskNum(0).createTime(new Date()).groupId(mutexRequestInfo.getWaitLockReportId()).objectEntityNumber("fpm_report").status(TaskStatus.WAITING.name()).taskInfo(SerializationUtils.toJsonString(mutexRequestInfo.toMap())).build();
            this.taskHandleService.saveTaskIfNotRepeat(taskRecord);
            TMCMQPublisher.sendFpmDefaultMsg(MQBusinessTypeEnum.LOCAL_SEQUENT_TASK, SerializationUtils.toJsonString((Object)taskRecord));
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        if (this.reportMutexLockService.isLocked()) {
            return;
        }
        List<MutexRequestInfo> mutexRequestInfoList = this.reportMutexLockService.getMutexRequestInfoList();
        this.dataSaveService.updateAndCheckResult(() -> "update t_fpm_report set fbillstatus=? where fid=?", mutexRequestInfoList, (t, d) -> {
            d.add(ReportProcessStatus.AUDIT.getValue());
            d.add(t.getReportPlanId());
        });
        String message = ResManager.loadKDString((String)"\u6570\u636e\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u3002", (String)"ReportPlanUnAuditService_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.getOperationResult().setMessage(message);
        this.getOperationResult().setShowMessage(false);
    }

    public void beforeProcess(List<ExtendedDataEntity> dataEntities) throws KDException {
        super.beforeProcess(dataEntities);
        String reportOpType = (String)this.getOperationVariable().get("ReportOpType");
        if (ReportOpType.SERVICE.getNumber().equals(reportOpType)) {
            this.reportMutexLockService = new ReportMutexLockService(Collections.emptyList());
            return;
        }
        this.reportMutexLockService = new ReportMutexLockService(MutexRequestInfo.getMutexRequestInfoList(dataEntities.stream().map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList())));
        this.reportMutexLockService.tryLock();
    }

    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        if (Objects.nonNull(this.reportMutexLockService)) {
            this.reportMutexLockService.unLock();
        }
    }
}

