/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.report;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;
import kd.tmc.fpm.business.domain.enums.SourceBillType;

public class ReportSumExecBiasAnalysService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(ReportSumExecBiasAnalysService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("bodysys");
        selector.add("reportorg");
        selector.add("originalreportids");
        selector.add("reportperiod");
        selector.add("exratetable");
        selector.add("exchangeratedate");
        selector.add("declarestartdate");
        selector.add("declaredeadline");
        selector.add("name");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        logger.info("\u6c47\u603b\u7f16\u5236\u5f00\u59cb\u751f\u6210\u6267\u884c\u504f\u5dee\u5206\u6790\u5355\u636e");
        Map billNos = this.getOperationResult().getBillNos();
        billNos.clear();
        for (DynamicObject sumReport : dynamicObjects) {
            DynamicObject newDO = TmcDataServiceHelper.newDynamicObject((String)"fpm_execbiasanalys");
            newDO.set("bodysys", sumReport.get("bodysys"));
            newDO.set("reportorg", sumReport.get("reportorg"));
            String originalreportids = sumReport.getString("originalreportids");
            String[] reportIds = originalreportids.split(",");
            DynamicObject report = TmcDataServiceHelper.loadSingle((String)"fpm_report", (String)"templatebak", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(reportIds[0]))});
            DynamicObject templateBak = report.getDynamicObject("templatebak");
            DynamicObject reportPeriod = sumReport.getDynamicObject("reportperiod");
            newDO.set("reporttype", (Object)reportPeriod.getLong(String.join((CharSequence)".", "reporttype", "id")));
            newDO.set("reportperiod", sumReport.get("reportperiod"));
            newDO.set("sourcebilltype", (Object)SourceBillType.SUMPLAN.getValue());
            newDO.set("sourcebill", sumReport.getPkValue());
            newDO.set("exratetable", sumReport.get("exratetable"));
            newDO.set("exchangeratedate", sumReport.get("exchangeratedate"));
            newDO.set("amountunit", templateBak.get("amountunit"));
            newDO.set("declarestartdate", sumReport.get("declarestartdate"));
            newDO.set("declaredeadline", sumReport.get("declaredeadline"));
            newDO.set("name", sumReport.get("name"));
            newDO.set("source", (Object)"1");
            newDO.set("planstatus", sumReport.get("planstatus"));
            newDO.set("billno", (Object)CodeRuleHelper.generateNumber((String)"fpm_execbiasanalys", (DynamicObject)newDO, null, (String)""));
            newDO.set("billstatus", (Object)ReportProcessStatus.SAVE.getValue());
            newDO.set("creator", (Object)RequestContext.get().getCurrUserId());
            Object[] result = TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{newDO});
            DynamicObject[] execBiasAnalysDO = (DynamicObject[])result;
            billNos.put(sumReport.getString("billno"), execBiasAnalysDO[0].getString("id"));
        }
    }

    public void afterProcess(DynamicObject[] dynamicObjects) throws KDException {
        List reportIds = Arrays.stream(dynamicObjects).map(c -> c.getPkValue()).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(reportIds)) {
            DynamicObject[] reportBills = TmcDataServiceHelper.load((Object[])reportIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_reportplansum"));
            Arrays.stream(reportBills).forEach(c -> c.set("isexecbiasanalys", (Object)"1"));
            TmcDataServiceHelper.save((DynamicObject[])reportBills);
        }
    }
}

