/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.report;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.mvc.service.ISumPlanBizService;
import kd.tmc.fpm.business.mvc.service.dto.RecalculateSumPlanAmtParamDTO;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class ReportSumPlanRecalculateAmtService
extends AbstractTmcBizOppService {
    private ISumPlanBizService iSumPlanBizService = FpmServiceFactory.getBizService(ISumPlanBizService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("billstatus");
        selector.add("planstatus");
        selector.add("bodysys.id");
        selector.add("reporttype.id");
        selector.add("reportperiod.id");
        selector.add("originalreportids");
        selector.add("reportorg.id");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        Long systemId = dynamicObjects[0].getLong("bodysys.id");
        Long reportPeriodId = dynamicObjects[0].getLong("reportperiod.id");
        List<Long> reportOrgIds = Arrays.stream(dynamicObjects).filter(dy -> ReportStatus.ENABLE == ReportStatus.getByVal(dy.getString("planstatus"))).map(dy -> dy.getLong("reportorg.id")).collect(Collectors.toList());
        RecalculateSumPlanAmtParamDTO qParam = new RecalculateSumPlanAmtParamDTO();
        qParam.setSystemId(systemId);
        qParam.setReportPeriodId(reportPeriodId);
        qParam.setReportOrgIds(reportOrgIds);
        qParam.setReportPlanType(ReportPlanType.SUMPLAN);
        this.iSumPlanBizService.recalculateSumPlanAmt(qParam);
    }
}

