/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.dataproc.save.impl.DataSaveServiceImpl;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.ReportOpType;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.mvc.repository.ISumPlanRepository;
import kd.tmc.fpm.business.mvc.repository.impl.SumPlanRepository;
import kd.tmc.fpm.business.mvc.service.ISumPlanBizService;
import kd.tmc.fpm.business.mvc.service.impl.SumPlanBizServiceImpl;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.common.enums.ReportPlanStatusEnum;

public class ReportSumPlanSubmitService
extends AbstractTmcBizOppService {
    private ISumPlanBizService bizService = new SumPlanBizServiceImpl();
    private ISumPlanRepository sumPlanRepository = new SumPlanRepository();
    private IDataSaveService dataSaveService = new DataSaveServiceImpl();

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("originalreportids");
        selector.add("bodysys");
        selector.add("reporttype");
        selector.add("reportorg");
        selector.add("reportperiod");
        selector.add("subplannum");
        selector.add("subsumplannum");
        selector.add("reportedplannum");
        selector.add("unreportedplannum");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        CommonUtils.trace(ReportSumPlanSubmitService.class.getSimpleName(), span -> {
            if (EmptyUtil.isEmpty((Object[])dynamicObjects)) {
                return null;
            }
            span.addTag("query sumPlanParamConfig");
            Map<String, SumPlanParamConfig> sumPlanParamConfigMap = this.getSumPlanParamConfigs(dynamicObjects);
            ArrayList<Long> reportPkIds = new ArrayList<Long>(2);
            for (DynamicObject dynamicObject : dynamicObjects) {
                String originalreportids = dynamicObject.getString("originalreportids");
                if (EmptyUtil.isEmpty((String)originalreportids)) continue;
                String[] reportIds = originalreportids.split(",");
                Long[] reports = new Long[reportIds.length];
                for (int i = 0; i < reportIds.length; ++i) {
                    reports[i] = Long.valueOf(reportIds[i]);
                }
                span.addTag("execute innerCancelAmt");
                this.bizService.innerCancelAmt((Long)dynamicObject.getPkValue());
                reportPkIds.addAll(Arrays.asList(reports));
                String systemId = dynamicObject.getDynamicObject("bodysys").getPkValue().toString();
                String reportTypeId = dynamicObject.getDynamicObject("reporttype").getPkValue().toString();
                String key = String.join((CharSequence)"_", systemId, reportTypeId);
                if (!sumPlanParamConfigMap.containsKey(key)) continue;
                SumPlanParamConfig sumPlanParamConfig = sumPlanParamConfigMap.get(key);
                Long reportOrgId = (Long)dynamicObject.getDynamicObject("reportorg").getPkValue();
                List<SumPlanParamConfigInfo> configInfoList = sumPlanParamConfig.getConfigInfoList();
                HashSet<Long> orgSubPlan = new HashSet<Long>(2);
                HashSet<Long> orgSubSumPlan = new HashSet<Long>(2);
                for (SumPlanParamConfigInfo sumPlanParamConfigInfo : configInfoList) {
                    if (!reportOrgId.equals(sumPlanParamConfigInfo.getOrgMemberId())) continue;
                    List<SumPlanParamConfigInfo> paramConfigInfos = sumPlanParamConfigInfo.getAllChildren();
                    for (SumPlanParamConfigInfo paramConfigInfo : paramConfigInfos) {
                        if (paramConfigInfo.isSumAuditNode()) {
                            orgSubSumPlan.add(paramConfigInfo.getOrgMemberId());
                            continue;
                        }
                        orgSubPlan.add(paramConfigInfo.getOrgMemberId());
                    }
                }
                QFilter sumQFilter = new QFilter("reportorg", "in", orgSubSumPlan);
                sumQFilter.and("reportperiod", "=", (Object)dynamicObject.getDynamicObject("reportperiod").getLong("id"));
                sumQFilter.and("bodysys", "=", (Object)dynamicObject.getDynamicObject("bodysys").getLong("id"));
                span.addTag("query down level report sum count");
                DynamicObjectCollection subSumPlans = QueryServiceHelper.query((String)"fpm_reportplansum", (String)"id,planstatus,billno", (QFilter[])new QFilter[]{sumQFilter});
                span.addTag("query down level report plan count");
                DynamicObjectCollection subReports = this.getSubReports(dynamicObject, orgSubPlan);
                long reportPlanCount = subReports.stream().filter(c -> ReportPlanStatusEnum.REPORTING.getValue().equals(c.getString("planstatus")) || ReportPlanStatusEnum.EFFECTIVE.getValue().equals(c.getString("planstatus"))).count();
                long reportLLSumCount = subSumPlans.stream().filter(c -> ReportPlanStatusEnum.REPORTING.getValue().equals(c.getString("planstatus")) || ReportPlanStatusEnum.EFFECTIVE.getValue().equals(c.getString("planstatus"))).count();
                int totalReport = (int)reportPlanCount + (int)reportLLSumCount;
                int totalUnReport = subReports.size() + subSumPlans.size() - totalReport;
                dynamicObject.set("subplannum", (Object)subReports.size());
                dynamicObject.set("subsumplannum", (Object)subSumPlans.size());
                dynamicObject.set("reportedplannum", (Object)totalReport);
                dynamicObject.set("unreportedplannum", (Object)totalUnReport);
            }
            span.addTag("save sumRecords");
            TmcDataServiceHelper.save((DynamicObject[])dynamicObjects);
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("ReportOpType", ReportOpType.SERVICE.getNumber());
            String selectFields = String.join((CharSequence)",", "billstatus", "id");
            span.addTag("load report plan");
            DynamicObjectCollection reportPO = QueryServiceHelper.query((String)"fpm_report", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", reportPkIds)});
            ArrayList<Long> updateIdList = new ArrayList<Long>(reportPO.size());
            for (DynamicObject report : reportPO) {
                if (!"A".equals(report.getString("billstatus"))) continue;
                updateIdList.add(report.getLong("id"));
            }
            if (EmptyUtil.isNoEmpty(updateIdList)) {
                span.addTag("submit report plan");
                this.dataSaveService.update(IDataSaveService.Constants.SUM_REPORT_SUBMIT_STATUS_UPDATE, updateIdList, (t, d) -> {
                    d.add(BillStatus.COMMITTED.getNumber());
                    d.add(t);
                });
            }
            return null;
        });
    }

    public DynamicObjectCollection getSubReports(DynamicObject load, Set<Long> orgSubordinate) {
        QFilter qFilter = new QFilter("bodysys", "=", (Object)load.getLong("bodysys.id"));
        qFilter.and("reportperiod", "=", (Object)load.getLong("reportperiod.id"));
        qFilter.and("reportorg", "in", orgSubordinate);
        qFilter.and("reportplantype", "=", (Object)ReportPlanType.REPORTPLAN.getNumber());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"fpm_report", (String)"id,planstatus", (QFilter[])new QFilter[]{qFilter});
        return dynamicObjects;
    }

    private Map<String, SumPlanParamConfig> getSumPlanParamConfigs(DynamicObject[] sumPlans) {
        if (EmptyUtil.isEmpty((Object[])sumPlans)) {
            return Collections.emptyMap();
        }
        Long systemId = (Long)sumPlans[0].getDynamicObject("bodysys").getPkValue();
        Set<Long> reportTypeIds = Arrays.stream(sumPlans).map(dy -> dy.getDynamicObject("reporttype")).map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toSet());
        List<SumPlanParamConfig> sumPlanParamConfigList = this.sumPlanRepository.loadSumConfigBySystem(systemId, reportTypeIds, true);
        HashMap<String, SumPlanParamConfig> sumPlanParamConfigMap = new HashMap<String, SumPlanParamConfig>(sumPlanParamConfigList.size());
        for (SumPlanParamConfig sumPlanParamConfig : sumPlanParamConfigList) {
            List<Long> reportPeriodTypeIdS = sumPlanParamConfig.getReportPeriodTypeIdS();
            for (Long reportTypeId : reportPeriodTypeIdS) {
                String key = String.join((CharSequence)"_", String.valueOf(systemId), String.valueOf(reportTypeId));
                sumPlanParamConfigMap.putIfAbsent(key, sumPlanParamConfig);
            }
        }
        return sumPlanParamConfigMap;
    }
}

