/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.report.mutex;

import java.util.List;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.domain.model.task.TaskRecord;
import kd.tmc.fpm.business.opservice.report.mutex.ILockStrategy;
import kd.tmc.fpm.business.opservice.report.mutex.ILockStrategyFactory;

public class GeneralDLockStrategy
implements ILockStrategy,
ILockStrategyFactory,
AutoCloseable {
    private final DLock dLock;
    private final String dLockName;
    private boolean locked;
    private static final Log logger = LogFactory.getLog(GeneralDLockStrategy.class);

    public GeneralDLockStrategy() {
        this(String.format("%s.%s.%s", CacheKeyUtil.getAcctId(), "fpm_taskrecord", "GeneralDLockStrategy"));
    }

    public GeneralDLockStrategy(String dLockName) {
        this.dLockName = dLockName;
        this.dLock = DLock.create((String)dLockName);
    }

    @Override
    public boolean tryLock() {
        logger.info("\u51c6\u5907\u52a0\u5206\u5e03\u5f0f\u9501\uff1a{}", (Object)this.dLockName);
        this.locked = this.dLock.tryLock();
        logger.info("\u5206\u5e03\u5f0f\u9501\uff1a{}\u52a0\u9501\u7ed3\u679c\uff1a{}", (Object)this.dLockName, (Object)this.locked);
        return this.locked;
    }

    @Override
    public void lock() {
        logger.info("\u51c6\u5907\u52a0\u5206\u5e03\u5f0f\u9501\uff1a{}", (Object)this.dLockName);
        this.dLock.lock();
    }

    @Override
    public void unLock() {
        logger.info("\u51c6\u5907\u91ca\u653e\u5206\u5e03\u5f0f\u9501\uff1a{}", (Object)this.dLockName);
        if (this.locked) {
            this.dLock.unlock();
            this.locked = false;
        }
    }

    @Override
    public ILockStrategy getLockStrategy(List<TaskRecord> taskRecordList) {
        return this;
    }

    @Override
    public void close() throws Exception {
        this.dLock.close();
    }
}

