/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.report.mutex;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.task.TaskRecord;
import kd.tmc.fpm.business.opservice.report.mutex.ILockStrategy;
import kd.tmc.fpm.business.opservice.report.mutex.ILockStrategyFactory;
import kd.tmc.fpm.business.utils.CommonUtils;

public class GeneralMutexLockStrategy
implements ILockStrategy,
ILockStrategyFactory {
    private static final Log logger = LogFactory.getLog(GeneralMutexLockStrategy.class);
    private final List<String> waitLockIds = new ArrayList<String>(16);
    private final List<String> successIds = new ArrayList<String>(16);
    private Exception e;

    @Override
    public boolean tryLock() {
        this.cleanException();
        if (EmptyUtil.isEmpty(this.waitLockIds)) {
            return true;
        }
        ArrayList<String> requestFailIds = new ArrayList<String>(16);
        try {
            Map lockMap = MutexServiceHelper.batchRequest(this.waitLockIds, (String)"fpm_taskrecord", (String)"LocalSequentTaskConsumer");
            for (Map.Entry next : lockMap.entrySet()) {
                String key = (String)next.getKey();
                Boolean result = (Boolean)next.getValue();
                if (result == null || !result.booleanValue()) {
                    requestFailIds.add(key);
                    continue;
                }
                this.successIds.add(key);
            }
            if (requestFailIds.size() > 0) {
                logger.info("\u52a0\u9501\u5931\u8d25\u6570\u91cf\uff1a{},{}", (Object)requestFailIds.size(), CommonUtils.getSubListForSize(requestFailIds, 100));
                return false;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.e = e;
            return false;
        }
        return true;
    }

    private void cleanException() {
        this.e = null;
    }

    @Override
    public void lock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unLock() {
        if (EmptyUtil.isEmpty(this.successIds)) {
            return;
        }
        MutexServiceHelper.batchRelease(this.successIds, (String)"fpm_taskrecord", (String)"LocalSequentTaskConsumer");
        this.successIds.clear();
    }

    @Override
    public Exception getException() {
        return this.e;
    }

    @Override
    public ILockStrategy getLockStrategy(List<TaskRecord> taskRecordList) {
        taskRecordList.stream().map(TaskRecord::getId).map(String::valueOf).distinct().forEach(this.waitLockIds::add);
        return this;
    }
}

