/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.report.mutex;

import java.util.Map;
import java.util.Objects;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.TaskType;
import kd.tmc.fpm.business.domain.model.task.TaskRecord;
import kd.tmc.fpm.business.opservice.report.mutex.GeneralDLockStrategy;
import kd.tmc.fpm.business.opservice.report.mutex.ILockStrategyFactory;
import kd.tmc.fpm.business.opservice.report.mutex.NoLockStrategy;
import kd.tmc.fpm.business.opservice.report.mutex.ReportPlanLockStrategyFactory;
import kd.tmc.fpm.common.helper.StringHelper;

public class LockStrategyFactoryFactory {
    public static ILockStrategyFactory getLockStrategyFactory(TaskRecord taskRecord) {
        TaskType taskType = TaskType.getByName(taskRecord.getTaskType());
        if (Objects.isNull((Object)taskType)) {
            throw new UnsupportedOperationException("taskType is null");
        }
        switch (taskType) {
            case REPORT_PLAN_AUDIT: 
            case REPORT_PLAN_UN_AUDIT: {
                return new ReportPlanLockStrategyFactory();
            }
            case REPORT_PLAN_CHANGE_TASK: 
            case UN_COMPLETE_APPROVED_RECORD_UPDATE_TASK: 
            case TASK_CLEAN: {
                String dLockName = String.format("%s.%s.%s", CacheKeyUtil.getAcctId(), "fpm_taskrecord", taskRecord.getGroupId());
                return new GeneralDLockStrategy(dLockName);
            }
            case REPORT_PREPARE: {
                Map<String, Object> taskParams = taskRecord.getTaskParams();
                String reportTypeId = StringHelper.getStringValue((Object)taskParams.get("reportTypeId"));
                if (EmptyUtil.isEmpty((String)reportTypeId)) {
                    return new NoLockStrategy();
                }
                String reportPrepareLockName = String.format("%s.%s.%s.%s", CacheKeyUtil.getAcctId(), "fpm_taskrecord", taskRecord.getGroupId(), reportTypeId);
                return new GeneralDLockStrategy(reportPrepareLockName);
            }
        }
        return new NoLockStrategy();
    }
}

