/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.report.mutex;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.index.BitMap;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.mvc.repository.impl.SumPlanRepository;
import kd.tmc.fpm.business.utils.ListHelper;

public class MutexRequestInfo
implements Serializable {
    private SumPlanRecord sumPlanRecord;
    private String waitLockReportId;
    private Long reportPlanId;
    private String reportPlanNo;

    public SumPlanRecord getSumPlanRecord() {
        return this.sumPlanRecord;
    }

    public void setSumPlanRecord(SumPlanRecord sumPlanRecord) {
        this.sumPlanRecord = sumPlanRecord;
    }

    public String getWaitLockReportId() {
        return this.waitLockReportId;
    }

    public void setWaitLockReportId(String waitLockReportId) {
        this.waitLockReportId = waitLockReportId;
    }

    public Long getReportPlanId() {
        return this.reportPlanId;
    }

    public void setReportPlanId(Long reportPlanId) {
        this.reportPlanId = reportPlanId;
    }

    public String getReportPlanNo() {
        return this.reportPlanNo;
    }

    public void setReportPlanNo(String reportPlanNo) {
        this.reportPlanNo = reportPlanNo;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("reportPlanId", String.valueOf(this.reportPlanId));
        map.put("reportPlanNo", this.reportPlanNo);
        map.put("waitLockReportId", this.waitLockReportId);
        map.put("sumOrgId", String.valueOf(this.sumPlanRecord.getReportOrg()));
        return map;
    }

    public String toString() {
        return "MutexRequestInfo{sumPlanRecord=" + this.sumPlanRecord + ", waitLockReportId='" + this.waitLockReportId + '\'' + ", reportPlanId=" + this.reportPlanId + ", reportPlanNo='" + this.reportPlanNo + '\'' + '}';
    }

    public static List<MutexRequestInfo> getMutexRequestInfoList(List<DynamicObject> dynamicObjectList) {
        return MutexRequestInfo.getMutexRequestInfoList(dynamicObjectList, null);
    }

    public static List<MutexRequestInfo> getMutexRequestInfoList(List<DynamicObject> dynamicObjectList, Map<Long, Long> sumConfigReportIdMap) {
        if (EmptyUtil.isEmpty(dynamicObjectList)) {
            return new ArrayList<MutexRequestInfo>(1);
        }
        dynamicObjectList = dynamicObjectList.stream().filter(dy -> dy.getDynamicObject("template").getBoolean("ismaintable")).collect(Collectors.toList());
        BitMap<Long, SumPlanRecord> sumPlanRecordInfo = MutexRequestInfo.getSumPlanRecordInfo(dynamicObjectList, sumConfigReportIdMap);
        ArrayList<MutexRequestInfo> mutexRequestInfoList = new ArrayList<MutexRequestInfo>(16);
        for (DynamicObject dynamicObject : dynamicObjectList) {
            long reportOrgId = dynamicObject.getLong("reportorg.id");
            long reportPeriodId = dynamicObject.getLong("reportperiod.id");
            long systemId = dynamicObject.getLong("bodysys.id");
            List<SumPlanRecord> list = sumPlanRecordInfo.findList(ListHelper.asSet(reportOrgId, reportPeriodId, systemId));
            if (EmptyUtil.isEmpty(list)) continue;
            String reportNo = dynamicObject.getString("billno");
            if (list.size() > 1) {
                String message = String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u7f16\u5236\u5355\u636e\u3010%1$s\u3011\u5b58\u5728\u591a\u6761\u4e0a\u6e38\u540c\u5c42\u7ea7\u6c47\u603b\u7f16\u62a5\u5355\u636e\u3010%2$s\u3011\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ReportMutexLockService_0", (String)"tmc-fpm-business", (Object[])new Object[0]), reportNo, list.stream().map(SumPlanRecord::getNumber).collect(Collectors.joining(",")));
                throw new KDBizException(message);
            }
            SumPlanRecord sumPlanRecord = list.get(0);
            MutexRequestInfo mutexRequestInfo = new MutexRequestInfo();
            mutexRequestInfo.setReportPlanId(dynamicObject.getLong("id"));
            mutexRequestInfo.setReportPlanNo(reportNo);
            mutexRequestInfo.setSumPlanRecord(sumPlanRecord);
            mutexRequestInfo.setWaitLockReportId(String.valueOf(sumPlanRecord.getId()));
            mutexRequestInfoList.add(mutexRequestInfo);
        }
        return mutexRequestInfoList;
    }

    private static BitMap<Long, SumPlanRecord> getSumPlanRecordInfo(List<DynamicObject> dynamicObjectList, Map<Long, Long> sumConfigReportIdMap) {
        Set<Long> systemIds = dynamicObjectList.stream().map(dynamicObject -> dynamicObject.getDynamicObject("bodysys")).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        String reportTypeProp = "reportperiod.reporttype.id";
        Set<Long> reportTypeIds = dynamicObjectList.stream().map(dy -> dy.getLong(reportTypeProp)).map(Long.class::cast).collect(Collectors.toSet());
        BitMap<Long, SumPlanParamConfig> sumPlanParamConfigMap = MutexRequestInfo.getSumPlanParamConfigMap(systemIds, reportTypeIds);
        HashSet<Long> periodIds = new HashSet<Long>(16);
        HashSet<Long> reportOrgIds = new HashSet<Long>(16);
        HashMap sumReportOrgDownReportOrgMap = new HashMap(16);
        for (DynamicObject mainReport : dynamicObjectList) {
            long reportTypeId = mainReport.getLong(reportTypeProp);
            long systemId = mainReport.getDynamicObject("bodysys").getLong("id");
            SumPlanParamConfig sumPlanParamConfig = sumPlanParamConfigMap.findOne(ListHelper.asSet(systemId, reportTypeId));
            if (Objects.isNull(sumPlanParamConfig)) continue;
            long reportOrgId = mainReport.getLong("reportorg.id");
            Map sumPlanParamConfigInfoMap = sumPlanParamConfig.getConfigInfoList().stream().collect(Collectors.toMap(SumPlanParamConfigInfo::getOrgMemberId, Function.identity(), (a, b) -> a));
            SumPlanParamConfigInfo configInfo = (SumPlanParamConfigInfo)sumPlanParamConfigInfoMap.get(reportOrgId);
            while (Objects.nonNull(configInfo) && !configInfo.isSumAuditNode()) {
                configInfo = (SumPlanParamConfigInfo)sumPlanParamConfigInfoMap.get(configInfo.getParentId());
            }
            if (configInfo == null) continue;
            Set downReportOrgIds = sumReportOrgDownReportOrgMap.computeIfAbsent(configInfo.getOrgMemberId(), k -> new HashSet(16));
            downReportOrgIds.add(reportOrgId);
            reportOrgIds.add(configInfo.getOrgMemberId());
            periodIds.add(mainReport.getLong("reportperiod.id"));
            if (sumConfigReportIdMap == null) continue;
            sumConfigReportIdMap.put(reportOrgId, configInfo.getOrgMemberId());
        }
        String selectFields = String.join((CharSequence)",", "bodysys", "billno", "id", "reporttype", "reportperiod", "reportorg");
        QFilter qFilter = new QFilter("bodysys", "in", systemIds).and("reportorg", "in", reportOrgIds).and("reportperiod", "in", periodIds);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"fpm_reportplansum", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        BitMap<Long, SumPlanRecord> sumPlanRecordBitMap = new BitMap<Long, SumPlanRecord>(16);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
            return sumPlanRecordBitMap;
        }
        for (DynamicObject sumRecordDy : dynamicObjectCollection) {
            SumPlanRecord sumPlanRecord = new SumPlanRecord();
            sumPlanRecord.setReportPeriod(sumRecordDy.getLong("reportperiod"));
            sumPlanRecord.setReportOrg(sumRecordDy.getLong("reportorg"));
            sumPlanRecord.setId(sumRecordDy.getLong("id"));
            sumPlanRecord.setNumber(sumRecordDy.getString("billno"));
            sumPlanRecord.setSystemId(sumRecordDy.getLong("bodysys"));
            sumPlanRecordBitMap.addValue(sumPlanRecord.getReportOrg(), sumPlanRecord);
            sumPlanRecordBitMap.addValue(sumPlanRecord.getReportPeriod(), sumPlanRecord);
            sumPlanRecordBitMap.addValue(sumPlanRecord.getSystemId(), sumPlanRecord);
            Set downReportOrgIds = sumReportOrgDownReportOrgMap.getOrDefault(sumPlanRecord.getReportOrg(), Collections.emptySet());
            sumPlanRecordBitMap.addValue(downReportOrgIds, sumPlanRecord);
        }
        return sumPlanRecordBitMap;
    }

    private static BitMap<Long, SumPlanParamConfig> getSumPlanParamConfigMap(Set<Long> systemIds, Set<Long> reportTypeIds) {
        List<SumPlanParamConfig> sumPlanParamConfigList = new SumPlanRepository().loadSumConfigBySystems(systemIds, reportTypeIds, true);
        BitMap<Long, SumPlanParamConfig> map = new BitMap<Long, SumPlanParamConfig>(16);
        for (SumPlanParamConfig sumPlanParamConfig : sumPlanParamConfigList) {
            map.addValue(sumPlanParamConfig.getSystemId(), sumPlanParamConfig);
            map.addValue(new HashSet<Long>(sumPlanParamConfig.getReportPeriodTypeIdS()), sumPlanParamConfig);
        }
        return map;
    }
}

