/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.shrek;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.mvc.converter.ShrekModelConverter;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.common.enums.MemberSumEnum;
import kd.tmc.fpm.common.helper.ReportDataFieldHelper;
import kd.tmc.fpm.olap.command.ShrekCommand;
import kd.tmc.fpm.olap.command.ShrekSyncCommand;
import kd.tmc.fpm.olap.command.executor.ShrekExecutor;
import kd.tmc.fpm.olap.enums.ShrekCommandType;
import kd.tmc.fpm.olap.enums.ShrekSyncStatus;
import kd.tmc.fpm.olap.utils.ShrekIdUtil;

public class ShrekDimensionSyncService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ShrekDimensionSyncService.class);
    private IDimensionRepository dimensionRepository = new DimensionRepository();
    private List<DynamicObject> syncDimObjs = new ArrayList<DynamicObject>();
    private List<Dimension> syncDimModels = new ArrayList<Dimension>();
    private List<DynamicObject> syncDimensionMember = new ArrayList<DynamicObject>();

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bodysystem");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        DynamicObject bodySystem = dynamicObjects[0].getDynamicObject("bodysystem");
        DynamicObject systemPO = TmcDataServiceHelper.loadSingle((Object)bodySystem.getPkValue(), (String)"fpm_bodysysmanage");
        if (Objects.isNull(systemPO)) {
            return;
        }
        if (!ShrekSyncStatus.SYNC_DONE.name().equals(systemPO.getString("shreksyncstatus"))) {
            OperationServiceHelper.executeOperate((String)"syncsys_mdd", (String)"fpm_bodysysmanage", (DynamicObject[])new DynamicObject[]{systemPO}, (OperateOption)OperateOption.create());
            return;
        }
        this.updateDimAndMembersStatus(dynamicObjects);
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        this.fillIntoRedundantFieldAsMember();
        DynamicObject bodySystem = dataEntities[0].getDynamicObject("bodysystem");
        long systemId = Long.parseLong(bodySystem.getPkValue().toString());
        String cubeNumber = ShrekIdUtil.getCubeNumber((String)String.valueOf(systemId), (String)bodySystem.getString("number"));
        ShrekSyncCommand syncDimensionCommand = new ShrekSyncCommand();
        syncDimensionCommand.setMetaDataByNumber(cubeNumber);
        syncDimensionCommand.setCommandType(ShrekCommandType.SYNC_DIMENSION);
        syncDimensionCommand.setDimensionList(ShrekModelConverter.convertAndFillRoot(cubeNumber, this.syncDimModels));
        ShrekExecutor.execute((ShrekCommand)syncDimensionCommand);
    }

    private void fillIntoRedundantFieldAsMember() {
        ReportDataFieldHelper.REDUNDANT_FIELD_MAPPING_MAP.forEach((key, val) -> {
            Dimension dim = new Dimension();
            dim.setNumber((String)key);
            ArrayList<DimMember> dimMembers = new ArrayList<DimMember>();
            val.forEach(item -> {
                DimMember member = new DimMember();
                member.setNumber((String)item);
                member.setSumType(MemberSumEnum.PLUS.getCode());
                dimMembers.add(member);
            });
            dim.setMemberList(dimMembers);
            this.syncDimModels.add(dim);
        });
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        this.syncDimObjs.forEach(item -> item.set("shreksyncstatus", (Object)ShrekSyncStatus.SYNC_FAILED.name()));
        this.syncDimensionMember.forEach(item -> item.set("shreksyncstatus", (Object)ShrekSyncStatus.SYNC_FAILED.name()));
        SaveServiceHelper.update((DynamicObject[])this.syncDimObjs.toArray(new DynamicObject[0]));
        SaveServiceHelper.update((DynamicObject[])this.syncDimensionMember.toArray(new DynamicObject[0]));
    }

    private void updateDimAndMembersStatus(DynamicObject[] objects) {
        DynamicObject bodySystem = objects[0].getDynamicObject("bodysystem");
        List<Long> mainIdList = Arrays.stream(objects).map(item -> Long.valueOf(item.getPkValue().toString())).collect(Collectors.toList());
        List<Dimension> dimensions = this.dimensionRepository.loadMainDimension(mainIdList);
        this.setDimensionAndMemberList(bodySystem, dimensions);
        SaveServiceHelper.update((DynamicObject[])this.syncDimObjs.toArray(new DynamicObject[0]));
        SaveServiceHelper.update((DynamicObject[])this.syncDimensionMember.toArray(new DynamicObject[0]));
        this.syncDimModels.addAll(dimensions);
    }

    private void setDimensionAndMemberList(DynamicObject bodySystem, List<Dimension> dimList) {
        for (Dimension dimension : dimList) {
            DynamicObject dimensionObj = BusinessDataServiceHelper.newDynamicObject((String)"fpm_dimension");
            dimensionObj.set("bodysystem", (Object)bodySystem);
            dimensionObj.set("id", (Object)dimension.getId());
            dimensionObj.set("shrekdatakey", (Object)ShrekIdUtil.getDimNumber((String)dimension.getNumber()));
            dimensionObj.set("shreksyncstatus", (Object)ShrekSyncStatus.SYNC_DONE.name());
            this.syncDimObjs.add(dimensionObj);
            for (DimMember dimMember : dimension.getAllDimMemberList()) {
                DynamicObject member = BusinessDataServiceHelper.newDynamicObject((String)"fpm_member");
                member.set("dimension", (Object)dimensionObj);
                member.set("bodysystem", bodySystem.get("id"));
                member.set("id", (Object)dimMember.getId());
                member.set("shrekdatakey", (Object)CommonUtils.getSyncShrekKey(dimMember));
                member.set("shreksyncstatus", (Object)ShrekSyncStatus.SYNC_DONE.name());
                this.syncDimensionMember.add(member);
            }
        }
    }
}

