/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.shrek;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.mvc.converter.ShrekModelConverter;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.olap.command.ShrekCommand;
import kd.tmc.fpm.olap.command.ShrekSyncCommand;
import kd.tmc.fpm.olap.command.executor.ShrekExecutor;
import kd.tmc.fpm.olap.enums.ShrekCommandType;
import kd.tmc.fpm.olap.enums.ShrekSyncStatus;
import kd.tmc.fpm.olap.utils.ShrekIdUtil;

public class ShrekMemberSyncService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ShrekMemberSyncService.class);
    private IDimensionRepository dimensionRepository = new DimensionRepository();
    private DynamicObject bodySystem;
    private List<DynamicObject> syncDimObjs;
    private List<Dimension> syncDimModels = new ArrayList<Dimension>();
    private List<DynamicObject> syncDimensionMember;

    public ShrekMemberSyncService() {
        this.syncDimObjs = new ArrayList<DynamicObject>();
        this.syncDimensionMember = new ArrayList<DynamicObject>();
    }

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("dimension");
        selector.add("bodysystem");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        Object[] ids = Arrays.stream(dynamicObjects).map(DataEntityBase::getPkValue).toArray(Object[]::new);
        DynamicObject[] members = TmcDataServiceHelper.load((Object[])ids, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_member"));
        DynamicObject bodySys = members[0].getDynamicObject("bodysystem");
        this.bodySystem = TmcDataServiceHelper.loadSingle((Object)bodySys.getPkValue(), (String)"fpm_bodysysmanage");
        if (Objects.isNull(this.bodySystem)) {
            return;
        }
        if (!ShrekSyncStatus.SYNC_DONE.name().equals(this.bodySystem.getString("shreksyncstatus"))) {
            OperationServiceHelper.executeOperate((String)"syncsys_mdd", (String)"fpm_bodysysmanage", (DynamicObject[])new DynamicObject[]{this.bodySystem}, (OperateOption)OperateOption.create());
            return;
        }
        this.updateMembersStatus(members, this.bodySystem);
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        if (CollectionUtils.isEmpty(this.syncDimModels)) {
            return;
        }
        long systemId = Long.parseLong(this.bodySystem.getPkValue().toString());
        String cubeNumber = ShrekIdUtil.getCubeNumber((String)String.valueOf(systemId), (String)this.bodySystem.getString("number"));
        Dimension reportPeriodDim = this.generateReportPeriodDim(this.bodySystem, this.syncDimModels);
        if (EmptyUtil.isNoEmpty((Object)reportPeriodDim)) {
            this.syncDimModels.add(reportPeriodDim);
        }
        ShrekSyncCommand syncCommand = new ShrekSyncCommand();
        syncCommand.setMetaDataByNumber(cubeNumber);
        syncCommand.setCommandType(ShrekCommandType.SYNC_DIMENSION);
        syncCommand.setDimensionList(ShrekModelConverter.convertAndFillRoot(cubeNumber, this.syncDimModels));
        ShrekExecutor.execute((ShrekCommand)syncCommand);
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        this.syncDimObjs.forEach(item -> item.set("shreksyncstatus", (Object)ShrekSyncStatus.SYNC_FAILED.name()));
        this.syncDimensionMember.forEach(item -> item.set("shreksyncstatus", (Object)ShrekSyncStatus.SYNC_FAILED.name()));
        SaveServiceHelper.update((DynamicObject[])this.syncDimObjs.toArray(new DynamicObject[0]));
        SaveServiceHelper.update((DynamicObject[])this.syncDimensionMember.toArray(new DynamicObject[0]));
    }

    private void updateMembersStatus(DynamicObject[] objects, DynamicObject bodySystem) {
        DynamicObject memberObj = objects[0];
        Object dimensionObj = memberObj.get("dimension");
        List<Dimension> dimensions = dimensionObj instanceof Long ? this.dimensionRepository.loadMainDimension(Lists.newArrayList((Object[])new Long[]{(Long)dimensionObj})) : this.dimensionRepository.loadMainDimension(Lists.newArrayList((Object[])new Long[]{(Long)((DynamicObject)dimensionObj).getPkValue()}));
        if (CollectionUtils.isEmpty(dimensions)) {
            return;
        }
        Dimension dimension = dimensions.get(0);
        this.syncDimModels.add(dimension);
        DynamicObject dimObj = BusinessDataServiceHelper.newDynamicObject((String)"fpm_dimension");
        dimObj.set("id", (Object)dimension.getId());
        dimObj.set("shrekdatakey", (Object)ShrekIdUtil.getDimNumber((String)dimension.getNumber()));
        dimObj.set("shreksyncstatus", (Object)ShrekSyncStatus.SYNC_DONE.name());
        this.syncDimObjs.add(dimObj);
        for (DimMember dimMember : dimension.getAllDimMemberList()) {
            DynamicObject member = BusinessDataServiceHelper.newDynamicObject((String)"fpm_member");
            member.set("dimension", (Object)dimObj);
            member.set("bodysystem", bodySystem.get("id"));
            member.set("id", (Object)dimMember.getId());
            member.set("shrekdatakey", (Object)CommonUtils.getSyncShrekKey(dimMember));
            member.set("shreksyncstatus", (Object)ShrekSyncStatus.SYNC_DONE.name());
            this.syncDimensionMember.add(member);
        }
        SaveServiceHelper.update((DynamicObject[])this.syncDimObjs.toArray(new DynamicObject[0]));
        SaveServiceHelper.update((DynamicObject[])this.syncDimensionMember.toArray(new DynamicObject[0]));
    }

    private Dimension generateReportPeriodDim(DynamicObject system, List<Dimension> dimensions) {
        DynamicObjectCollection dynamicObjectCollection = system.getDynamicObjectCollection("applyrereportentry");
        Map reportTypeDyMap = dynamicObjectCollection.stream().filter(dy -> StringUtils.equals((CharSequence)"enable", (CharSequence)dy.getString("rereporttypestatus"))).map(dy -> dy.getDynamicObject("rerporttype")).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        List<DimMember> reportPeriodDimMemberList = dimensions.stream().filter(dimension -> dimension.getDimType().isPeriodDim()).map(Dimension::getAllDimMemberList).filter(Objects::nonNull).flatMap(Collection::stream).map(PeriodMember.class::cast).filter(p -> {
            Long periodTypeId = p.getPeriodTypeId();
            DynamicObject reportTypeDy = (DynamicObject)reportTypeDyMap.get(periodTypeId);
            if (Objects.isNull(reportTypeDy)) {
                return false;
            }
            String number = p.getPeriodType().getNumber();
            String reportCycle = reportTypeDy.getString("orgreportcycle");
            if (PeriodType.MONTH_WEEK == PeriodType.getByNumber(reportCycle)) {
                return PeriodType.YEAR_WEEK.getNumber().equals(number) || PeriodType.MONTH_WEEK.getNumber().equals(number);
            }
            return Objects.equals(number, reportCycle);
        }).collect(Collectors.toList());
        Dimension dimension2 = new Dimension();
        dimension2.setNumber("ReportPeriodDim");
        dimension2.setMemberList(reportPeriodDimMemberList);
        return dimension2;
    }
}

