/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.provider;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.provider.FpmBaseDataProvider;

public class ReportDataBaseDataProvider
extends FpmBaseDataProvider {
    public ReportDataBaseDataProvider(List<ReportData> reportDataList) {
        this.initDataMap(reportDataList);
    }

    private void initDataMap(List<ReportData> reportDataList) {
        HashMap<String, Set> baseDataIdMap = new HashMap<String, Set>();
        for (ReportData reportData : reportDataList) {
            List<TemplateDim> dimList = reportData.getDimList();
            List<Object> dimValList = reportData.getDimValList();
            for (int i = 0; i < dimList.size(); ++i) {
                TemplateDim templateDim = dimList.get(i);
                Object dimVal = dimValList.get(i);
                if (dimVal == null || StringUtils.isEmpty((CharSequence)dimVal.toString())) continue;
                DetailDimType detailDimType = templateDim.getDetailDimType();
                if (detailDimType == DetailDimType.COUNTERPARTY_NAME) {
                    int index;
                    String bdEntity;
                    Optional<TemplateDim> first = dimList.stream().filter(item -> item.getDetailDimType() == DetailDimType.CONNTERPARTY_TYPE).findFirst();
                    if (!first.isPresent() || !StringUtils.isNotEmpty((CharSequence)(bdEntity = (String)dimValList.get(index = dimList.indexOf(first.get()))))) continue;
                    Set idSet = (Set)baseDataIdMap.get(bdEntity);
                    idSet = idSet == null ? new HashSet(16) : idSet;
                    idSet.add(dimVal);
                    baseDataIdMap.put(bdEntity, idSet);
                    continue;
                }
                if (detailDimType == DetailDimType.BANK_CATE || detailDimType == DetailDimType.BANK_ACCOUNT || detailDimType == DetailDimType.BUSINESS_PARTNER) {
                    String bdEntity = (String)detailDimType.getExtVal();
                    Set idSet = (Set)baseDataIdMap.get(bdEntity);
                    idSet = idSet == null ? new HashSet(16) : idSet;
                    idSet.add(dimVal);
                    baseDataIdMap.put(bdEntity, idSet);
                    continue;
                }
                if (!DetailDimType.isExtraField(detailDimType) || !StringUtils.isNotEmpty((CharSequence)templateDim.getBaseDataType())) continue;
                Set idSet = (Set)baseDataIdMap.get(templateDim.getBaseDataType());
                idSet = idSet == null ? new HashSet(16) : idSet;
                idSet.add(dimVal);
                baseDataIdMap.put(templateDim.getBaseDataType(), idSet);
            }
        }
        for (Map.Entry entry : baseDataIdMap.entrySet()) {
            String entityType = (String)entry.getKey();
            Set idSet = (Set)entry.getValue();
            if (idSet.size() <= 0) continue;
            List collect = idSet.stream().map(item -> Long.valueOf(item.toString())).collect(Collectors.toList());
            Map<Object, DynamicObject> dataMap = Arrays.stream(TmcDataServiceHelper.load((Object[])collect.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityType))).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o));
            this.baseDataMap.put(entityType, dataMap);
        }
    }
}

