/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.dimension.impl;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.service.dimension.ICustomDimSeqService;
import org.apache.commons.collections4.CollectionUtils;

public class CustomDimSeqServiceImpl
implements ICustomDimSeqService {
    private static final Object lock = new Object();
    private static final String ROUTE_KEY = "fpm";
    private static final String ID = "fid";
    private static final String SEQ = "fseq";
    private static final String BODY_SYSTEM = "fbodysystem";
    private static final String QUERY_SQL_BY_SYSTEM = "select fid, fseq from t_fpm_dim_seq where fbodysystem in (%s);";
    private static final String QUERY_SQL_BY_ID = "select fid, fseq from t_fpm_dim_seq where fid in (%s);";
    private static final String INSERT_SQL = "insert into t_fpm_dim_seq(fid, fbodysystem, fseq) values(?, ?, ?);";
    private static final String DELETE_SQL = "delete t_fpm_dim_seq where fid = ?";
    private static final int CUSTOM_DIM_MAX_SEQ = 3;
    public static final Map<Integer, String> seq2ReportCustomPropertyMap = new HashMap<Integer, String>(4, 1.0f);
    public static final Map<Integer, String> seq2AdjustReportCustomPropertyMap = new HashMap<Integer, String>(4, 1.0f);
    public static final Map<String, Integer> adjustReportCustomProperty2SeqMap = new HashMap<String, Integer>(4, 1.0f);
    public static final Map<Integer, String> SUPPLEMENT_BILL_CUSTOM_PROP_MAP = new HashMap<Integer, String>(4, 1.0f);

    @Override
    public Map<Long, Integer> loadCustomDimSeqMap(Long systemId) {
        Map<Long, Integer> customDimSeqMap = this.loadCustomDimSeqMapWithoutHistoryData(systemId);
        if (customDimSeqMap.isEmpty()) {
            this.initHistoryData(systemId);
            return this.loadCustomDimSeqMapWithoutHistoryData(systemId);
        }
        return customDimSeqMap;
    }

    @Override
    public Map<Integer, Long> loadSeqCustomDimMap(Long systemId) {
        Map<Long, Integer> customDimSeqMap = this.loadCustomDimSeqMapWithoutHistoryData(systemId);
        HashMap<Integer, Long> seqCustomDimMap = new HashMap<Integer, Long>(4, 1.0f);
        customDimSeqMap.forEach((k, v) -> seqCustomDimMap.put((Integer)v, (Long)k));
        return seqCustomDimMap;
    }

    @Override
    public int addCustomDimSeq(Long dimensionId, Long systemId) {
        if (Objects.isNull(dimensionId) || Objects.isNull(systemId)) {
            return 0;
        }
        Map<Long, Integer> customDimSeqMap = this.loadCustomDimSeqMap(systemId);
        int currSeq = CustomDimSeqServiceImpl.calSeq(dimensionId, customDimSeqMap, 3);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(1);
        Object[] param = new Object[]{dimensionId, systemId, currSeq};
        paramList.add(param);
        DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)INSERT_SQL, paramList);
        return currSeq;
    }

    @Override
    public boolean delCustomDimSeq(Long dimensionId) {
        if (Objects.isNull(dimensionId)) {
            return false;
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(1);
        Object[] param = new Object[]{dimensionId};
        paramList.add(param);
        DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)DELETE_SQL, paramList);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initHistoryData(Long systemId) {
        Object object = lock;
        synchronized (object) {
            Throwable throwable = null;
            try (TXHandle tx = TX.requiresNew();){
                Map<Long, Integer> customDim2SeqMap = this.loadCustomDimSeqMapWithoutHistoryData(systemId);
                if (!customDim2SeqMap.isEmpty()) {
                    return;
                }
                customDim2SeqMap = this.calHistoryData(systemId);
                if (customDim2SeqMap.isEmpty()) {
                    return;
                }
                ArrayList paramList = new ArrayList(1);
                customDim2SeqMap.forEach((dimId, seq) -> {
                    Object[] param = new Object[]{dimId, systemId, seq};
                    paramList.add(param);
                });
                DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)INSERT_SQL, paramList);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            return;
        }
    }

    @Override
    public Map<Long, Integer> loadCustomDimSeqMapWithoutHistoryData(Long systemId) {
        HashMap<Long, Integer> customDimSeqMap;
        ArrayList<Long> systemIdList = new ArrayList<Long>(1);
        systemIdList.add(systemId);
        try (DataSet dataSet = DB.queryDataSet((String)CustomDimSeqServiceImpl.class.getName(), (DBRoute)DBRouteConst.TMC, (String)this.getQuerySql(QUERY_SQL_BY_SYSTEM, new ArrayList<Long>(systemIdList)));){
            customDimSeqMap = new HashMap<Long, Integer>(4, 1.0f);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                customDimSeqMap.put(row.getLong(ID), row.getInteger(SEQ));
            }
        }
        return customDimSeqMap;
    }

    @Override
    public Map<Long, Integer> loadCustomDimSeqMapByIds(Collection<Long> customDimIds) {
        HashMap allSyStemCustomDimSeqMap;
        if (CollectionUtils.isEmpty(customDimIds)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashSet<Long> customDimIdSet = new HashSet<Long>(customDimIds);
        try (DataSet dataSet = DB.queryDataSet((String)CustomDimSeqServiceImpl.class.getName(), (DBRoute)DBRouteConst.TMC, (String)this.getQuerySql(QUERY_SQL_BY_ID, customDimIdSet));){
            allSyStemCustomDimSeqMap = Maps.newHashMapWithExpectedSize((int)customDimIdSet.size());
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                allSyStemCustomDimSeqMap.put(row.getLong(ID), row.getInteger(SEQ));
            }
        }
        if (allSyStemCustomDimSeqMap.size() == customDimIdSet.size()) {
            return allSyStemCustomDimSeqMap;
        }
        String systemIdProperty = "bodysystem.id";
        QFilter qFilter = new QFilter("id", "in", customDimIdSet);
        DynamicObject[] customDimDyArray = TmcDataServiceHelper.load((String)"fpm_dimension", (String)("id," + systemIdProperty), (QFilter[])qFilter.toArray());
        Set systemIdSet = Arrays.stream(customDimDyArray).map(dy -> dy.getLong(systemIdProperty)).collect(Collectors.toSet());
        for (Long systemId : systemIdSet) {
            Map<Long, Integer> customDimSeqMap = this.loadCustomDimSeqMap(systemId);
            allSyStemCustomDimSeqMap.putAll(customDimSeqMap);
        }
        return allSyStemCustomDimSeqMap;
    }

    private Map<Long, Integer> calHistoryData(Long systemId) {
        QFilter qFilter = new QFilter("bodysystem", "=", (Object)systemId).and("basedata", "=", (Object)DimensionType.CUSTOM.getNumber());
        Object[] customDimDyArr = TmcDataServiceHelper.load((String)"fpm_dimension", (String)"id", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isEmpty((Object[])customDimDyArr)) {
            return new HashMap<Long, Integer>(2);
        }
        List customDimIdList = Arrays.stream(customDimDyArr).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        int customDimSize = customDimIdList.size();
        ArrayList<String> properties = new ArrayList<String>(5);
        properties.add("id");
        properties.add("maindimentry.id");
        properties.add("maindimentry.extmem1");
        properties.add("maindimentry.extmem2");
        properties.add("maindimentry.extmem3");
        String propertiesStr = String.join((CharSequence)",", properties);
        LinkedHashMap<Long, Long> member2DimMap = new LinkedHashMap<Long, Long>(4, 1.0f);
        HashMap<Long, Integer> member2SeqMap = new HashMap<Long, Integer>(4, 1.0f);
        List<String> customProperties = Arrays.asList("maindimentry.extmem1", "maindimentry.extmem2", "maindimentry.extmem3");
        Set keySet = member2DimMap.keySet();
        for (int i = 0; keySet.size() < 3 && i < 3; ++i) {
            qFilter = new QFilter("bodysys", "=", (Object)systemId).and(customProperties.get(i), ">", (Object)0L);
            DynamicObject customValDy = QueryServiceHelper.queryOne((String)"fpm_report", (String)propertiesStr, (QFilter[])qFilter.toArray());
            if (!Objects.nonNull(customValDy)) continue;
            member2DimMap.put(customValDy.getLong(customProperties.get(i)), null);
            member2SeqMap.put(customValDy.getLong(customProperties.get(i)), i + 1);
        }
        keySet = member2DimMap.keySet();
        if (keySet.size() > 0) {
            String dimIdProperty = "dimension.id";
            QFilter qFilter1 = new QFilter("id", "in", member2DimMap.keySet());
            DynamicObject[] memberDyArr = TmcDataServiceHelper.load((String)"fpm_member", (String)("id," + dimIdProperty), (QFilter[])qFilter1.toArray());
            Arrays.stream(memberDyArr).forEach(dy -> {
                Long memberId = dy.getLong("id");
                Long dimensionId = dy.getLong(dimIdProperty);
                member2DimMap.put(memberId, dimensionId);
            });
        }
        HashMap<Long, Integer> customDim2SeqMap = new HashMap<Long, Integer>(4, 1.0f);
        member2DimMap.forEach((memberId, dimId) -> {
            Integer seq = (Integer)member2SeqMap.get(memberId);
            customDim2SeqMap.put((Long)dimId, seq);
        });
        customDimIdList.removeIf(customDim2SeqMap.keySet()::contains);
        if (CollectionUtils.isNotEmpty(customDimIdList)) {
            customDimIdList.stream().forEach(customDimId -> {
                int seq = CustomDimSeqServiceImpl.calSeq(customDimId, customDim2SeqMap, customDimSize);
                customDim2SeqMap.put((Long)customDimId, seq);
            });
        }
        return customDim2SeqMap;
    }

    private String getQuerySql(String sql, Collection<Long> paramIdList) {
        return String.format(sql, this.getInIdParameter(paramIdList));
    }

    private <T> String getInIdParameter(Collection<T> ctrRecordList) {
        return ctrRecordList.stream().map(String::valueOf).collect(Collectors.joining(","));
    }

    private static int calSeq(Long dimensionId, Map<Long, Integer> existDimSeqMap, int maxSeq) {
        int[] seqArr = new int[maxSeq];
        for (Map.Entry<Long, Integer> entry : existDimSeqMap.entrySet()) {
            if (entry.getKey().equals(dimensionId)) {
                return entry.getValue();
            }
            seqArr[entry.getValue().intValue() - 1] = 1;
        }
        OptionalInt currSeqOpt = IntStream.range(0, maxSeq).filter(i -> seqArr[i] < 1).findFirst();
        if (!currSeqOpt.isPresent()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65b0\u589e\u52a0\u7684\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u3010%1$s\u3011\uff0c\u8d85\u8fc7\u6700\u5927\u5141\u8bb8\u6570\u91cf\u3002", (String)"CustomDimSeqDataHelper_0", (String)"tmc-fpm-business", (Object[])new Object[0]), dimensionId));
        }
        return currSeqOpt.getAsInt() + 1;
    }

    static {
        seq2ReportCustomPropertyMap.put(1, "extmem1");
        seq2ReportCustomPropertyMap.put(2, "extmem2");
        seq2ReportCustomPropertyMap.put(3, "extmem3");
        seq2AdjustReportCustomPropertyMap.put(1, "main_extmem1");
        seq2AdjustReportCustomPropertyMap.put(2, "main_extmem2");
        seq2AdjustReportCustomPropertyMap.put(3, "main_extmem3");
        adjustReportCustomProperty2SeqMap.put("main_extmem1", 1);
        adjustReportCustomProperty2SeqMap.put("main_extmem2", 2);
        adjustReportCustomProperty2SeqMap.put("main_extmem3", 3);
        SUPPLEMENT_BILL_CUSTOM_PROP_MAP.put(1, "custom1");
        SUPPLEMENT_BILL_CUSTOM_PROP_MAP.put(2, "custom2");
        SUPPLEMENT_BILL_CUSTOM_PROP_MAP.put(3, "custom3");
    }
}

