/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl;

import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.service.fundsys.exportandimport.context.BodySysImportContext;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.AbstractBodySystemImportHandler;
import kd.tmc.fpm.business.utils.CommonUtils;
import org.apache.commons.collections4.MapUtils;

public class ControlStrategyImportHandlerImpl
extends AbstractBodySystemImportHandler {
    private static final Pattern pattern = Pattern.compile("([0-9]+)");

    public ControlStrategyImportHandlerImpl(BodySysImportContext bodySysImportContext) {
        super(bodySysImportContext);
    }

    @Override
    public String getHandleEntity() {
        return "fpm_controlwayconfig";
    }

    @Override
    protected void doHandler(DynamicObject clone, DynamicObject originalDy) {
        this.registerAndResetNumber(this.getId(originalDy), clone);
        this.cleanEntry(clone, "entryentity");
        this.resetProp(clone);
        this.updateTreeParent(clone, originalDy);
    }

    @Override
    protected boolean skip(DynamicObject dynamicObject) {
        if (!dynamicObject.getBoolean("enable")) {
            return true;
        }
        Long oldSystemId = this.getId(dynamicObject.getDynamicObject("bodysys"));
        DynamicObject newSystemDy = this.bodySystemImportIdPool.getIdPool("fpm_bodysysmanage").getDynamicObjectByOldId(oldSystemId);
        Set reportTypeIds = newSystemDy.getDynamicObjectCollection("applyrereportentry").stream().map(dy -> dy.getDynamicObject("rerporttype")).map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toSet());
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("reporttype");
        List controlReportTypeIds = dynamicObjectCollection.stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).map(Long.class::cast).map(id -> this.bodySystemImportIdPool.getIdPool("fpm_orgreporttype").getId((Long)id)).filter(EmptyUtil::isNoEmpty).filter(reportTypeIds::contains).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(controlReportTypeIds)) {
            return true;
        }
        dynamicObjectCollection.removeIf(dy -> !reportTypeIds.contains(this.bodySystemImportIdPool.getIdPool("fpm_orgreporttype").getId(this.getId(dy.getDynamicObject("fbasedataid")))));
        return false;
    }

    @Override
    protected void afterHandler(List<DynamicObject> dynamicObjectList) {
        List<DynamicObject> allDynamicObjectList = this.getIdPool().getAllNewDynamicObjectList();
        HashMap map = new HashMap(16);
        for (DynamicObject dynamicObject : allDynamicObjectList) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("reporttype");
            List<Long> reportTypeIds = dynamicObjectCollection.stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(this::getId).collect(Collectors.toList());
            boolean flag = true;
            for (Long reportTypeId : reportTypeIds) {
                if (!map.getOrDefault(reportTypeId, Boolean.FALSE).booleanValue()) continue;
                dynamicObject.set("enable", (Object)"0");
                flag = false;
                break;
            }
            if (!flag) continue;
            reportTypeIds.forEach(rtId -> map.putIfAbsent(rtId, Boolean.TRUE));
        }
        super.afterHandler(dynamicObjectList);
    }

    @Override
    protected void doReset(DynamicObject restDy, IDataEntityProperty dataEntityProperty) {
        super.doReset(restDy, dataEntityProperty);
        if (!Objects.equals(dataEntityProperty.getName(), "entry_detailcontrolbasis")) {
            return;
        }
        String detailControlBasisStr = restDy.getString(dataEntityProperty);
        if (EmptyUtil.isEmpty((String)detailControlBasisStr)) {
            return;
        }
        String newDetailControlBasisStr = detailControlBasisStr;
        Matcher matcher = pattern.matcher(detailControlBasisStr);
        while (matcher.find()) {
            String group = matcher.group(1);
            Long id = this.bodySystemImportIdPool.getIdPool("fpm_dimension").getId(Long.parseLong(group));
            if (EmptyUtil.isEmpty((Long)id)) {
                id = this.bodySystemImportIdPool.getIdPool("fpm_detailplanfields").getId(Long.parseLong(group));
            }
            newDetailControlBasisStr = newDetailControlBasisStr.replace(group, id.toString());
        }
        dataEntityProperty.setValueFast((Object)restDy, (Object)newDetailControlBasisStr);
    }

    private void updateTreeParent(DynamicObject clone, DynamicObject originalDy) {
        Map<Long, Long> oldNewIdMap = this.getOldNewIdMap(originalDy);
        if (MapUtils.isEmpty(oldNewIdMap)) {
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = clone.getDynamicObjectCollection("treeentryentity");
        DynamicObjectCollection oldDc = originalDy.getDynamicObjectCollection("treeentryentity");
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
            DynamicObject oldDy = (DynamicObject)oldDc.get(i);
            dynamicObject.set("id", (Object)oldNewIdMap.get(oldDy.getLong("id")));
            dynamicObject.set("pid", (Object)oldNewIdMap.get(oldDy.getLong("pid")));
        }
    }

    private Map<Long, Long> getOldNewIdMap(DynamicObject originalDy) {
        Deque<Long> deque = CommonUtils.batchGenerateIds(10);
        DynamicObjectCollection dynamicObjectCollection = originalDy.getDynamicObjectCollection("treeentryentity");
        HashMap<Long, Long> oldNewIdMap = new HashMap<Long, Long>(16);
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            long id = dynamicObject.getLong("id");
            if (EmptyUtil.isEmpty((Long)id) || oldNewIdMap.containsKey(id)) continue;
            if (deque.isEmpty()) {
                deque = CommonUtils.batchGenerateIds(10);
            }
            Long newId = deque.poll();
            oldNewIdMap.putIfAbsent(id, newId);
        }
        return oldNewIdMap;
    }
}

