/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl;

import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.service.fundsys.exportandimport.context.BodySysImportContext;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.AbstractBodySystemImportHandler;
import kd.tmc.fpm.business.service.fundsys.exportandimport.mapper.DynamicObjectMapper;
import kd.tmc.fpm.common.enums.DetailPlanFieldDataTypeEnum;

public class DetailPlanFieldImportHandlerImpl
extends AbstractBodySystemImportHandler {
    private DynamicObjectMapper dynamicObjectMapper;
    private static final Log logger = LogFactory.getLog(DetailPlanFieldImportHandlerImpl.class);

    public DetailPlanFieldImportHandlerImpl(BodySysImportContext bodySysImportContext) {
        super(bodySysImportContext);
    }

    @Override
    public String getHandleEntity() {
        return "fpm_detailplanfields";
    }

    @Override
    protected void doHandler(DynamicObject clone, DynamicObject originalDy) {
        this.register(originalDy.getLong("id"), clone);
        this.resetProp(clone);
    }

    @Override
    protected void beforeHandler(List<DynamicObject> dynamicObjectList) {
        if (EmptyUtil.isEmpty(dynamicObjectList)) {
            return;
        }
        DynamicObject dynamicObject = dynamicObjectList.get(0);
        DynamicObject bodySystem = dynamicObject.getDynamicObject("bodysys");
        this.dynamicObjectMapper = new DynamicObjectMapper(dy -> dy.getString("detaildimtype"));
        Long newSystemId = this.bodySystemImportIdPool.getIdPool("fpm_bodysysmanage").getId(bodySystem.getLong("id"));
        this.dynamicObjectMapper.init("fpm_detailplanfields", new QFilter("bodysys", "=", (Object)newSystemId));
        dynamicObjectList.forEach(dy -> {
            String detailDimType = dy.getString("detaildimtype");
            DynamicObjectMapper.MapperObjectHolder mapperObjectHolder = this.dynamicObjectMapper.getMapperObjectHolder(detailDimType);
            if (mapperObjectHolder == null) {
                return;
            }
            this.getIdPool().registerNewIdExists(dy.getLong("id"), mapperObjectHolder.getDynamicObject());
        });
    }

    @Override
    protected boolean skip(DynamicObject dynamicObject) {
        String detailDimType = dynamicObject.getString("detaildimtype");
        DynamicObjectMapper.MapperObjectHolder mapperObjectHolder = this.dynamicObjectMapper.getMapperObjectHolder(detailDimType);
        if (Objects.isNull(mapperObjectHolder)) {
            return false;
        }
        DynamicObject existsDy = mapperObjectHolder.getDynamicObject();
        existsDy.set("name", dynamicObject.get("name"));
        existsDy.set("isshow", dynamicObject.get("isshow"));
        existsDy.set("ismustinput", dynamicObject.get("ismustinput"));
        long oldSystemId = dynamicObject.getDynamicObject("bodysys").getLong("id");
        DynamicObject newSystem = this.bodySystemImportIdPool.getIdPool("fpm_bodysysmanage").getDynamicObjectByOldId(oldSystemId);
        boolean systemPre = dynamicObject.getBoolean("syssetpre");
        if (!systemPre) {
            String dataType;
            String newDataType = dataType = dynamicObject.getString("datatype");
            if (EmptyUtil.isNoEmpty((String)dataType) && Objects.equals(dataType, DetailPlanFieldDataTypeEnum.BASEDATA.getValue())) {
                DynamicObject basData = dynamicObject.getDynamicObject("basedatatype");
                String entityName = Objects.isNull(basData) ? "" : String.valueOf(basData.get("id"));
                MainEntityType dataEntityType = null;
                try {
                    dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
                }
                catch (Exception ignore) {
                    logger.error(ignore.getMessage(), (Throwable)ignore);
                }
                if (dataEntityType == null) {
                    logger.warn("\u4f53\u7cfb\uff1a{} \u5bfc\u5165\u660e\u7ec6\u8ba1\u5212\u5b57{} \u4e3a\u57fa\u7840\u8d44\u6599\uff0c\u4f46\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b:{}", new Object[]{newSystem.getString("name"), dynamicObject.getString("name"), entityName});
                    newDataType = DetailPlanFieldDataTypeEnum.TEXT.getValue();
                } else if (basData != null) {
                    existsDy.set("basedatatype", (Object)this.newDynamicObject(basData.getDataEntityType().getName(), entityName));
                }
            } else if (EmptyUtil.isNoEmpty((String)dataType) && Objects.equals(dataType, DetailPlanFieldDataTypeEnum.ENUM.getValue())) {
                existsDy.set("option", (Object)dynamicObject.getString("option"));
            }
            existsDy.set("datatype", (Object)newDataType);
        }
        return true;
    }

    @Override
    protected void afterHandler(List<DynamicObject> dynamicObjectList) {
        super.afterHandler(dynamicObjectList);
        List<DynamicObject> allDynamicObjectList = this.getIdPool().getAllDynamicObjectList();
        SaveServiceHelper.save((DynamicObject[])allDynamicObjectList.toArray(new DynamicObject[0]));
    }
}

