/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.service.fundsys.exportandimport.context.BodySysImportContext;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.AbstractBodySystemImportHandler;

public class ExecuteTimeImportHandlerImpl
extends AbstractBodySystemImportHandler {
    private static final Log logger = LogFactory.getLog(ExecuteTimeImportHandlerImpl.class);

    public ExecuteTimeImportHandlerImpl(BodySysImportContext bodySysImportContext) {
        super(bodySysImportContext);
    }

    @Override
    public String getHandleEntity() {
        return "fpm_executetime";
    }

    @Override
    protected void doHandler(DynamicObject clone, DynamicObject originalDy) {
        this.registerAndResetNumber(this.getId(originalDy), clone);
        this.resetControlReportTypeIfNeed(clone);
        this.resetProp(clone);
    }

    private void resetControlReportTypeIfNeed(DynamicObject clone) {
        DynamicObjectCollection dynamicObjectCollection = clone.getDynamicObjectCollection("controlledreporttype");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
            return;
        }
        Long oldSystemId = this.getId(clone.getDynamicObject("bodysys"));
        DynamicObject newSystemDy = this.bodySystemImportIdPool.getIdPool("fpm_bodysysmanage").getDynamicObjectByOldId(oldSystemId);
        Set reportTypeIds = newSystemDy.getDynamicObjectCollection("applyrereportentry").stream().map(dy -> dy.getDynamicObject("rerporttype")).map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toSet());
        dynamicObjectCollection.removeIf(dy -> !reportTypeIds.contains(this.bodySystemImportIdPool.getIdPool("fpm_orgreporttype").getId(this.getId(dy.getDynamicObject("fbasedataid")))));
    }

    @Override
    protected boolean skip(DynamicObject dynamicObject) {
        if (!dynamicObject.getBoolean("enable")) {
            return true;
        }
        DynamicObjectCollection dc = dynamicObject.getDynamicObjectCollection("entryentity");
        Set occupyBills = dc.stream().map(dy -> dy.getDynamicObject("entry_businessbill")).map(DataEntityBase::getPkValue).map(String::valueOf).collect(Collectors.toSet());
        DynamicObjectCollection actualDc = dynamicObject.getDynamicObjectCollection("entryentity_actual");
        occupyBills.addAll(actualDc.stream().map(dy -> dy.getDynamicObject("entry_aclbusinessbill")).map(DataEntityBase::getPkValue).map(String::valueOf).collect(Collectors.toSet()));
        for (String str : occupyBills) {
            try {
                EntityMetadataCache.getDataEntityType((String)str);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isSkipProperty(IDataEntityProperty dataEntityProperty) {
        return Objects.equals("entry_businessbill", dataEntityProperty.getName()) || Objects.equals("entry_aclbusinessbill", dataEntityProperty.getName());
    }
}

