/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.service.fundsys.exportandimport.context.BodySysImportContext;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.AbstractBodySystemImportHandler;
import kd.tmc.fpm.business.service.fundsys.exportandimport.mapper.DynamicObjectMapper;
import kd.tmc.fpm.common.enums.MetricMemberTypeEnum;

public class MetricMemberImportHandlerImpl
extends AbstractBodySystemImportHandler {
    private static final Log logger = LogFactory.getLog(MetricMemberImportHandlerImpl.class);
    private DynamicObjectMapper dynamicObjectMapper;

    public MetricMemberImportHandlerImpl(BodySysImportContext bodySysImportContext) {
        super(bodySysImportContext);
    }

    @Override
    public String getHandleEntity() {
        return "fpm_member";
    }

    @Override
    protected void doHandler(DynamicObject clone, DynamicObject originalDy) {
        this.register(this.getId(originalDy), clone);
        this.resetProp(clone);
    }

    @Override
    protected void beforeHandler(List<DynamicObject> dynamicObjectList) {
        if (EmptyUtil.isEmpty(dynamicObjectList)) {
            return;
        }
        dynamicObjectList.removeIf(dy -> {
            String dimType = dy.getString("dimtype");
            return !Objects.equals(dimType, DimensionType.METRIC.getNumber());
        });
        this.registerSystemPreSet(dynamicObjectList);
        dynamicObjectList.removeIf(dy -> dy.getBoolean("preset"));
        if (EmptyUtil.isEmpty(dynamicObjectList)) {
            return;
        }
        dynamicObjectList.sort(Comparator.comparing(this::getIntValue));
    }

    private void registerSystemPreSet(List<DynamicObject> dynamicObjectList) {
        if (EmptyUtil.isEmpty(dynamicObjectList)) {
            return;
        }
        DynamicObject dynamicObject = dynamicObjectList.get(0);
        this.dynamicObjectMapper = new DynamicObjectMapper(dy -> dy.getString("metricpresettype"));
        long oldSystemId = dynamicObject.getDynamicObject("bodysystem").getLong("id");
        Long newSystemId = this.bodySystemImportIdPool.getIdPool("fpm_bodysysmanage").getId(oldSystemId);
        this.registerMetricDim(dynamicObject, newSystemId);
        this.dynamicObjectMapper.init(this.getHandleEntity(), new QFilter("bodysystem", "=", (Object)newSystemId).and(new QFilter("dimtype", "=", (Object)DimensionType.METRIC.getNumber())));
        for (DynamicObject dy2 : dynamicObjectList) {
            String metricPresetType = dy2.getString("metricpresettype");
            DynamicObjectMapper.MapperObjectHolder mapperObjectHolder = this.dynamicObjectMapper.getMapperObjectHolder(metricPresetType);
            if (mapperObjectHolder == null) continue;
            this.getIdPool().registerNewIdExists(this.getId(dy2), mapperObjectHolder.getDynamicObject());
        }
    }

    private void registerMetricDim(DynamicObject dynamicObject, Long newSystemId) {
        DynamicObject newDimension = BusinessDataServiceHelper.loadSingle((String)"fpm_dimension", (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", (Object)newSystemId).and(new QFilter("basedata", "=", (Object)DimensionType.METRIC.getNumber()))});
        if (EmptyUtil.isEmpty((DynamicObject)newDimension)) {
            logger.warn("\u4f53\u7cfb\uff1a{}\u627e\u4e0d\u5230\u5ea6\u91cf\u503c\u7ef4\u5ea6\u3002", (Object)newSystemId);
            return;
        }
        DynamicObject dimensionDy = dynamicObject.getDynamicObject("dimension");
        this.bodySystemImportIdPool.getIdPool("fpm_dimension").registerNewIdExists(this.getId(dimensionDy), newDimension);
    }

    @Override
    protected boolean skip(DynamicObject dynamicObject) {
        return Objects.nonNull(this.getIdPool().getDynamicObjectByOldId(this.getId(dynamicObject)));
    }

    private int getIntValue(DynamicObject dynamicObject) {
        String metricType = dynamicObject.getString("metrictype");
        return Objects.equals(metricType, MetricMemberTypeEnum.BASE.getValue()) ? -1 : 1;
    }
}

