/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.service.fundsys.exportandimport.context.BodySysImportContext;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.AbstractBodySystemImportHandler;

public class ReportReadyImportHandlerImpl
extends AbstractBodySystemImportHandler {
    private static final Log logger = LogFactory.getLog(ReportReadyImportHandlerImpl.class);

    public ReportReadyImportHandlerImpl(BodySysImportContext bodySysImportContext) {
        super(bodySysImportContext);
    }

    @Override
    public String getHandleEntity() {
        return "fpm_reportpreparation";
    }

    @Override
    protected void doHandler(DynamicObject clone, DynamicObject originalDy) {
        this.registerAndResetNumber(this.getId(originalDy), clone);
        this.clearGenerateRecordEntry(clone);
        this.resetProp(clone);
    }

    private void clearGenerateRecordEntry(DynamicObject clone) {
        DynamicObjectCollection dynamicObjectCollection = clone.getDynamicObjectCollection("entryentity");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
            return;
        }
        dynamicObjectCollection.clear();
    }

    @Override
    protected boolean skip(DynamicObject dynamicObject) {
        if (!dynamicObject.getBoolean("enable")) {
            logger.info("\u5f53\u524d\u7f16\u62a5\u51c6\u5907\uff1a{}\u4e0d\u53ef\u7528\uff0c\u4e0d\u5bfc\u5165", (Object)dynamicObject.getString("number"));
            return true;
        }
        DynamicObject reportTypeDy = dynamicObject.getDynamicObject("orgreporttype");
        Long newReportTypeId = this.bodySystemImportIdPool.register("fpm_orgreporttype").getId(this.getId(reportTypeDy));
        if (EmptyUtil.isEmpty((Long)newReportTypeId)) {
            logger.info("\u5f53\u524d\u7f16\u62a5\u51c6\u5907\uff1a{}\u4e0d\u53ef\u7528\uff0c\u7ed1\u5b9a\u7684\u7f16\u62a5\u7c7b\u578b\u5728\u65b0\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u7f16\u62a5\u7c7b\u578b\uff0c\u4e0d\u5bfc\u5165\u3002", (Object)dynamicObject.getString("number"));
            return true;
        }
        Long oldSystemId = this.getId(dynamicObject.getDynamicObject("bodysysmanage"));
        DynamicObject newSystemDy = this.bodySystemImportIdPool.getIdPool("fpm_bodysysmanage").getDynamicObjectByOldId(oldSystemId);
        Set reportTypeIds = newSystemDy.getDynamicObjectCollection("applyrereportentry").stream().map(dy -> dy.getDynamicObject("rerporttype")).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        if (reportTypeIds.contains(newReportTypeId)) {
            return false;
        }
        logger.info("\u5f53\u524d\u7f16\u62a5\u51c6\u5907\uff1a{}\u5bf9\u5e94\u7684\u7f16\u62a5\u7c7b\u578b\uff0c\u4e0d\u5728\u4f53\u7cfb\uff1a{}\u7684\u914d\u7f6e\u7684\u7f16\u62a5\u7c7b\u578b\u4e2d\uff0c\u4e0d\u5bfc\u5165\u3002", (Object)dynamicObject.getString("number"), (Object)newSystemDy.getString("name"));
        return true;
    }
}

