/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.service.fundsys.exportandimport.context.BodySysImportContext;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.AbstractBodySystemImportHandler;
import kd.tmc.fpm.common.enums.TemplateUsesEnum;

public class TemplateImportHandlerImpl
extends AbstractBodySystemImportHandler {
    private static final Log logger = LogFactory.getLog(TemplateImportHandlerImpl.class);

    public TemplateImportHandlerImpl(BodySysImportContext bodySysImportContext) {
        super(bodySysImportContext);
    }

    @Override
    public String getHandleEntity() {
        return "fpm_template";
    }

    @Override
    protected void doHandler(DynamicObject clone, DynamicObject originalDy) {
        this.registerAndResetNumber(this.getId(originalDy), clone);
        this.cleanProp(clone, "user");
        this.removeCurrencyIfNotExists(clone);
        this.clearAndSetDutyReportOrgIfNeed(clone);
        this.resetProp(clone);
    }

    private void clearAndSetDutyReportOrgIfNeed(DynamicObject clone) {
        this.clearAndSetDutyReportOrgForDimSetEntry(clone);
        this.clearAndSetDutyReportOrgForLayoutEntry(clone);
    }

    private void clearAndSetDutyReportOrgForLayoutEntry(DynamicObject clone) {
        Optional<DynamicObject> first = clone.getDynamicObjectCollection("layoutentry").stream().filter(dy -> {
            DynamicObject oldDimension = dy.getDynamicObject("layoutdim");
            DynamicObject newDimension = this.bodySystemImportIdPool.dimension().getDynamicObjectByOldId(this.getId(oldDimension));
            if (Objects.isNull(newDimension)) {
                return false;
            }
            return Objects.equals(newDimension.getString("number"), DimensionType.ORG.getNumber());
        }).findFirst();
        if (!first.isPresent()) {
            return;
        }
        DynamicObject dynamicObject = first.get();
        DynamicObjectCollection reportOrgExpandScopes = dynamicObject.getDynamicObjectCollection("expandmember");
        this.clearAndSetForDc(clone, reportOrgExpandScopes);
    }

    private void clearAndSetForDc(DynamicObject clone, DynamicObjectCollection reportOrgScopes) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)reportOrgScopes)) {
            return;
        }
        DynamicObject dynamicObject = (DynamicObject)reportOrgScopes.get(0);
        reportOrgScopes.removeIf(dy -> !Objects.equals(dynamicObject, dy));
        Long oldSystemId = this.getId(clone.getDynamicObject("model"));
        Long newSystemId = this.bodySystemImportIdPool.getIdPool("fpm_bodysysmanage").getId(oldSystemId);
        Long dutyOrgMemberId = this.bodySysImportContext.getDutyOrgMemberId(newSystemId);
        if (EmptyUtil.isEmpty((Long)dutyOrgMemberId)) {
            reportOrgScopes.clear();
            return;
        }
        DynamicObject orgMember = this.bodySystemImportIdPool.getIdPool("fpm_member").getDynamicObject(dutyOrgMemberId);
        if (EmptyUtil.isEmpty((DynamicObject)orgMember)) {
            reportOrgScopes.clear();
            return;
        }
        dynamicObject.set("fbasedataid", (Object)orgMember);
        dynamicObject.set("fbasedataid_id", (Object)this.getId(orgMember));
    }

    private void clearAndSetDutyReportOrgForDimSetEntry(DynamicObject clone) {
        Optional<DynamicObject> first = clone.getDynamicObjectCollection("dimsettingentry").stream().filter(dy -> {
            DynamicObject oldDimension = dy.getDynamicObject("dimbd");
            DynamicObject newDimension = this.bodySystemImportIdPool.getIdPool("fpm_dimension").getDynamicObjectByOldId(this.getId(oldDimension));
            if (Objects.isNull(newDimension)) {
                return false;
            }
            return Objects.equals(newDimension.getString("number"), DimensionType.ORG.getNumber());
        }).findFirst();
        if (!first.isPresent()) {
            return;
        }
        DynamicObjectCollection configCurrencyScopes = first.get().getDynamicObjectCollection("plantemplatemember");
        this.clearAndSetForDc(clone, configCurrencyScopes);
        DynamicObjectCollection dynamicObjectCollection = first.get().getDynamicObjectCollection("defaultfilter");
        this.clearAndSetForDc(clone, dynamicObjectCollection);
    }

    private void removeCurrencyIfNotExists(DynamicObject clone) {
        DynamicObjectCollection layoutCurrencyScopes;
        Optional<DynamicObject> layoutFirst;
        Optional<DynamicObject> first;
        DynamicObjectCollection dynamicObjectCollection = clone.getDynamicObjectCollection("currencymember");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
            dynamicObjectCollection.removeIf(dy -> EmptyUtil.isEmpty((Long)this.bodySystemImportIdPool.getIdPool("fpm_member").getId(this.getId(dy.getDynamicObject("fbasedataid")))));
        }
        if ((first = clone.getDynamicObjectCollection("dimsettingentry").stream().filter(Objects::nonNull).filter(dy -> {
            DynamicObject oldDimension = dy.getDynamicObject("dimbd");
            DynamicObject newDimension = this.bodySystemImportIdPool.getIdPool("fpm_dimension").getDynamicObjectByOldId(this.getId(oldDimension));
            if (Objects.isNull(newDimension)) {
                return false;
            }
            return Objects.equals(newDimension.getString("number"), DimensionType.CURRENCY.getNumber());
        }).findFirst()).isPresent()) {
            DynamicObject defaultMember;
            DynamicObjectCollection defaultFilter;
            DynamicObject dynamicObject = first.get();
            DynamicObjectCollection configCurrencyScopes = dynamicObject.getDynamicObjectCollection("plantemplatemember");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)configCurrencyScopes)) {
                configCurrencyScopes.removeIf(dy -> EmptyUtil.isEmpty((Long)this.bodySystemImportIdPool.dimMember().getId(this.getId(dy.getDynamicObject("fbasedataid")))));
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(defaultFilter = dynamicObject.getDynamicObjectCollection("defaultfilter")))) {
                defaultFilter.removeIf(dy -> EmptyUtil.isEmpty((Long)this.bodySystemImportIdPool.dimMember().getId(this.getId(dy.getDynamicObject("fbasedataid")))));
            }
            if (Objects.nonNull(defaultMember = dynamicObject.getDynamicObject("defaultdisplaymember")) && EmptyUtil.isEmpty((Long)this.bodySystemImportIdPool.dimMember().getId(this.getId(defaultMember)))) {
                this.cleanProp(dynamicObject, "defaultdisplaymember");
            }
        }
        if ((layoutFirst = clone.getDynamicObjectCollection("layoutentry").stream().filter(dy -> {
            DynamicObject oldDimension = dy.getDynamicObject("layoutdim");
            DynamicObject newDimension = this.bodySystemImportIdPool.getIdPool("fpm_dimension").getDynamicObjectByOldId(this.getId(oldDimension));
            if (Objects.isNull(newDimension)) {
                return false;
            }
            return Objects.equals(newDimension.getString("number"), DimensionType.CURRENCY.getNumber());
        }).findFirst()).isPresent() && EmptyUtil.isNoEmpty((DynamicObjectCollection)(layoutCurrencyScopes = layoutFirst.get().getDynamicObjectCollection("expandmember")))) {
            layoutCurrencyScopes.removeIf(dy -> EmptyUtil.isEmpty((Long)this.bodySystemImportIdPool.dimMember().getId(this.getId(dy.getDynamicObject("fbasedataid")))));
        }
    }

    @Override
    protected boolean skip(DynamicObject dynamicObject) {
        if (!dynamicObject.getBoolean("enable")) {
            return true;
        }
        DynamicObjectCollection currencyDc = dynamicObject.getDynamicObjectCollection("currencymember");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)currencyDc)) {
            logger.warn("\u6a21\u677f\uff1a{}\u5e01\u79cd\u8303\u56f4\u4e2d\u7684\u6240\u6709\u6210\u5458\u4e3a\u7a7a", (Object)dynamicObject.getString("name"));
            return false;
        }
        List currencyIds = currencyDc.stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).map(cid -> this.bodySystemImportIdPool.getIdPool("fpm_member").getId((Long)cid)).filter(EmptyUtil::isNoEmpty).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(currencyIds)) {
            logger.info("\u6a21\u677f\uff1a{}\u5e01\u79cd\u8303\u56f4\u4e2d\u7684\u6240\u6709\u6210\u5458\uff0c\u5728\u5bfc\u5165\u4f53\u7cfb\u4e2d\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u5e01\u79cd\u3002", (Object)dynamicObject.getString("name"));
            return true;
        }
        DynamicObjectCollection reportTypeDc = dynamicObject.getDynamicObjectCollection("reporttype");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)reportTypeDc)) {
            logger.info("\u6a21\u677f\uff1a{}\u6240\u6709\u9002\u7528\u7f16\u62a5\u7c7b\u578b\u4e3a\u7a7a", (Object)dynamicObject.getString("name"));
            return true;
        }
        Long oldSystemId = this.getId(dynamicObject.getDynamicObject("model"));
        DynamicObject newSystemDy = this.bodySystemImportIdPool.getIdPool("fpm_bodysysmanage").getDynamicObjectByOldId(oldSystemId);
        Set systemReportTypeIds = newSystemDy.getDynamicObjectCollection("applyrereportentry").stream().map(dy -> dy.getDynamicObject("rerporttype")).map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toSet());
        List reportTypeIds = reportTypeDc.stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).map(cid -> this.bodySystemImportIdPool.getIdPool("fpm_orgreporttype").getId((Long)cid)).filter(EmptyUtil::isNoEmpty).filter(systemReportTypeIds::contains).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(reportTypeIds)) {
            logger.info("\u6a21\u677f\uff1a{}\u6240\u6709\u7684\u9002\u7528\u7f16\u62a5\u7c7b\u578b\uff0c\u5728\u5bfc\u5165\u4f53\u7cfb\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7f16\u62a5\u7c7b\u578b\u3002", (Object)dynamicObject.getString("name"));
            return true;
        }
        return false;
    }

    @Override
    protected void beforeHandler(List<DynamicObject> dynamicObjectList) {
        if (EmptyUtil.isEmpty(dynamicObjectList)) {
            return;
        }
        dynamicObjectList.sort(Comparator.comparing(this::getIndex));
    }

    private int getIndex(DynamicObject dynamicObject) {
        String templateUse = dynamicObject.getString("templateuses");
        if (Objects.equals(templateUse, TemplateUsesEnum.ANALYSIS.getValue())) {
            return -10;
        }
        if (Objects.equals(templateUse, TemplateUsesEnum.STATISTIC.getValue())) {
            return -9;
        }
        return dynamicObject.getBoolean("ismaintable") ? 1 : -1;
    }

    @Override
    protected void doReset(DynamicObject restDy, IDataEntityProperty dataEntityProperty) {
        super.doReset(restDy, dataEntityProperty);
        if (Objects.equals("dim", dataEntityProperty.getName())) {
            String type = restDy.getString("dimbdtype");
            Long id = this.bodySystemImportIdPool.getIdPool(type).getId((Long)dataEntityProperty.getValue((Object)restDy));
            dataEntityProperty.setValueFast((Object)restDy, (Object)id);
        }
        if (Objects.equals(dataEntityProperty.getName(), "formula")) {
            String oldFormula = restDy.getString(dataEntityProperty);
            if (EmptyUtil.isEmpty((String)oldFormula)) {
                return;
            }
            dataEntityProperty.setValueFast((Object)restDy, (Object)this.getNewFormulaValue(oldFormula, "fpm_membersubject"));
        }
    }

    @Override
    protected boolean isClearProp(IDataEntityProperty dataEntityProperty) {
        if (Objects.equals(dataEntityProperty.getName(), "effectivedate")) {
            return false;
        }
        return super.isClearProp(dataEntityProperty);
    }
}

