/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.fundsys.exportandimport.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.service.fundsys.exportandimport.IExportService;

public abstract class AbstractExportService
implements IExportService {
    private boolean success;
    private String url;
    private static final Log logger = LogFactory.getLog(AbstractExportService.class);

    @Override
    public void export() {
        byte[] exportData = this.getExportData();
        if (exportData == null) {
            logger.info("\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e.");
            return;
        }
        try (ByteArrayInputStream inStream = new ByteArrayInputStream(exportData);){
            this.createExportFile(inStream, this.getExportFileName());
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void createExportFile(ByteArrayInputStream inStream, String fileName) {
        int timeout = 10000;
        try {
            this.url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, timeout);
            this.success = true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u751f\u6210\u5bfc\u51fa\u4e34\u65f6\u6587\u4ef6\u5931\u8d25\uff1a%1$s, %2$s", (String)"AbstractExportService_0", (String)"tmc-fpm-business", (Object[])new Object[0]), fileName, e.getMessage()));
        }
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    protected abstract byte[] getExportData();

    protected abstract String getExportFileName();
}

