/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.fundsys.exportandimport.period;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fpm.business.opservice.shrek.ShrekMemberSyncService;
import kd.tmc.fpm.business.service.fundsys.exportandimport.period.PeriodParamInfo;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.MemberSumEnum;
import kd.tmc.fpm.common.enums.WeekEnum;
import kd.tmc.fpm.common.utils.DateTimeUtil;
import kd.tmc.fpm.common.utils.GlobalIdUtil;
import org.apache.commons.lang3.tuple.Pair;

public class PeriodMemTree {
    private static final Log logger = LogFactory.getLog(PeriodMemTree.class);
    private List<PeriodMemTree> children = new ArrayList<PeriodMemTree>();
    private Long id = GlobalIdUtil.genGlobalLongId();
    private String name;
    private String number;
    private String status;
    private Long creator;
    private String enable;
    private Long reporttype;
    private String periodtype;
    private Long parent = 0L;
    private Boolean isleaf = true;
    private int level = 0;
    private String longnumber;
    private Date startdate;
    private Date enddate;
    private Date createTime;
    private PeriodParamInfo paramInfo;
    private String dimtype;
    private Long bodysystem;
    private Long dimension;
    private Date modifytime;
    private Long modifier;
    private int year;
    private Long serial;
    private static final String PERIODMEMBER = "fpm_member";
    public static final String PREFIX_Y = "Y";
    public static final String PREFIX_HY = "HY";
    public static final String PREFIX_SE = "Q";
    public static final String PREFIX_M = "M";
    public static final String PREFIX_TD = "TD";
    public static final String PREFIX_MW = "MW";
    public static final String PREFIX_YW = "YW";
    public static final String PREFIX_D = "D";
    private static final List<String> PREFIX_LIST = Arrays.asList("Y", "HY", "Q", "M", "TD", "MW", "YW", "D");
    private static final int FLAG_YEAR = 0x10000000;
    private static final int FLAG_WEEK_YEAR = 0x2000000;
    private static final int FLAG_HALF_YEAR = 0x1000000;
    private static final int FLAG_QUARTER = 0x100000;
    private static final int FLAG_MONTH = 65536;
    private static final int FLAG_TENDAYS = 4096;
    private static final int FLAG_WEEK_MONTH = 256;
    private static final int FLAG_DAY = 16;

    public PeriodMemTree() {
    }

    public PeriodMemTree(PeriodParamInfo paramInfo) {
        this.paramInfo = paramInfo;
    }

    public DynamicObject initToDyna(PeriodMemTree treeList) {
        DynamicObject periodObj = BusinessDataServiceHelper.newDynamicObject((String)this.getDynaEntityname());
        try {
            for (Class<?> clazz = treeList.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                Field[] fields;
                for (Field fie : fields = clazz.getDeclaredFields()) {
                    if (fie.isSynthetic() || Modifier.isStatic(fie.getModifiers())) continue;
                    ReflectionUtils.makeAccessible((Field)fie);
                    String fiename = fie.getName();
                    if (fiename.equals("children") || fiename.equals("paramInfo") || fiename.equals("serialVersionUID") || fiename.equals("this$0")) continue;
                    periodObj.set(fiename, fie.get(treeList));
                }
            }
            periodObj.set("dimension", (Object)this.dimension);
            periodObj.set("sumtype", (Object)MemberSumEnum.PLUS.getCode());
            periodObj.set("sortcode", (Object)treeList.getLongnumber());
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return periodObj;
    }

    public Pair<String, String> createTree(int year, int presetYear) {
        StringJoiner successYear = new StringJoiner("");
        StringJoiner errorYear = new StringJoiner(",");
        for (int i = year; i < year + presetYear; ++i) {
            if (this.validate(i)) {
                errorYear.add(String.format("[FY%s]", i));
                continue;
            }
            this.createTree(i);
            successYear.add(String.format("[FY%s]", i));
        }
        return Pair.of((Object)successYear.toString(), (Object)errorYear.toString());
    }

    private boolean validate(int year) {
        if (this.getDimension() == null) {
            return false;
        }
        QFilter modelQFilter = new QFilter("bodysystem", "=", (Object)Long.valueOf(this.paramInfo.getModel())).and("dimtype", "=", (Object)DimsionEnums.PERIOD.getNumber());
        QFilter reportQFilter = new QFilter("reporttype", "=", (Object)this.paramInfo.getReportType());
        QFilter yearQFilter = new QFilter("year", "=", (Object)year);
        return TmcDataServiceHelper.exists((String)PERIODMEMBER, (QFilter[])new QFilter[]{modelQFilter, reportQFilter, yearQFilter});
    }

    public void createTree(int year) {
        String pre;
        int flag;
        if (this.paramInfo.isHasYear()) {
            flag = 0x10000000;
            this.createTree(year, flag, PREFIX_Y);
        }
        if (this.paramInfo.isHasHalfYear()) {
            pre = PREFIX_HY;
            flag = 0x11000000;
            if (this.paramInfo.isYearInHYear()) {
                pre = "Y_HY";
            }
            this.createTree(year, flag, pre);
        }
        if (this.paramInfo.isHasQuarter()) {
            pre = PREFIX_SE;
            flag = 0x10100000;
            if (this.paramInfo.isHalfYearInQuarter()) {
                flag |= 0x1000000;
                pre = "HY_Q";
            }
            if (this.paramInfo.isYearInQuarter()) {
                pre = "Y_Q";
            }
            this.createTree(year, flag, pre);
        }
        if (this.paramInfo.isHasMonth()) {
            pre = PREFIX_M;
            flag = 0x10010000;
            if (this.paramInfo.isQuarterinMonth()) {
                flag |= 0x100000;
                pre = "Q_M";
            }
            if (this.paramInfo.isHalfyearinMonth()) {
                flag |= 0x1000000;
                pre = "HY_M";
            }
            if (this.paramInfo.isYearInMonth()) {
                flag |= 0x10000000;
                pre = "Y_M";
            }
            this.createTree(year, flag, pre);
        }
        if (this.paramInfo.isHastenDay()) {
            pre = PREFIX_TD;
            flag = 0x10001000;
            if (this.paramInfo.isMonthInTenday()) {
                flag |= 0x10000;
                pre = "M_TD";
            }
            this.createTree(year, flag, pre);
        }
        if (this.paramInfo.isHasYearWeek()) {
            flag = 0x12000000;
            this.createTree(year, flag, PREFIX_YW);
        }
        if (this.paramInfo.isHasMonthWeek()) {
            pre = PREFIX_MW;
            flag = 0x10000100;
            if (this.paramInfo.isMonthInMonthWeek()) {
                flag |= 0x10000;
                pre = "M_MW";
            }
            this.createTree(year, flag, pre);
        }
        if (this.paramInfo.isHasDay()) {
            pre = PREFIX_D;
            flag = 0x10000010;
            if (this.paramInfo.isYearWeekInDay()) {
                flag |= 0x2000000;
                pre = "YW_D";
            } else if (this.paramInfo.isMonthWeekInDay()) {
                flag |= 0x100;
                pre = "MW_D";
                if (this.paramInfo.isMonthInDay()) {
                    flag |= 0x10000;
                }
            } else if (this.paramInfo.isTenDayInDay()) {
                flag |= 0x1000;
                pre = "TD_D";
                if (this.paramInfo.isMonthInDay()) {
                    flag |= 0x10000;
                }
            } else if (this.paramInfo.isMonthInDay()) {
                flag |= 0x10000;
                pre = "M_D";
            }
            this.createTree(year, flag, pre);
        }
    }

    private void createTree(int year, int flag, String prefix) {
        int interval;
        int dayOfWeek;
        String number;
        String name;
        ArrayList<PeriodMemTree> currTreeList;
        ArrayList<List<PeriodMemTree>> treeList = new ArrayList<List<PeriodMemTree>>(10);
        if ((flag & 0x10000000) == 0x10000000) {
            currTreeList = new ArrayList<PeriodMemTree>(10);
            int seq = year * 100 + PREFIX_LIST.indexOf(prefix) + 1;
            name = this.getTreeName(0x10000000, year);
            number = this.getTreeNumber(prefix, 0x10000000, year);
            currTreeList.add(this.genTree(name, number, PREFIX_Y, year, 1, 1, 12, 31, seq));
            treeList.add(currTreeList);
        }
        if ((flag & 0x2000000) == 0x2000000) {
            currTreeList = new ArrayList(10);
            WeekEnum customStartNode = this.paramInfo.getStartNode();
            Calendar calendar = Calendar.getInstance();
            calendar.setFirstDayOfWeek(customStartNode.getWeekVal());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                calendar.setTime(sdf.parse(String.format("%d-01-01", year)));
            }
            catch (ParseException ignore) {
                logger.error("\u65f6\u95f4\u8bbe\u7f6e\u5f02\u5e38\uff1a", (Throwable)ignore);
            }
            int yearLastDay = 31;
            int week = 1;
            while (true) {
                int endDay;
                int month = calendar.get(2) + 1;
                int startDay = calendar.get(5);
                if (week == 1) {
                    dayOfWeek = calendar.get(7);
                    if (dayOfWeek == customStartNode.getPreWeekVal()) {
                        calendar.add(5, 7);
                    } else if (dayOfWeek >= customStartNode.getWeekVal()) {
                        interval = 6 - (dayOfWeek - customStartNode.getWeekVal());
                        calendar.add(5, interval);
                    } else if (dayOfWeek < customStartNode.getWeekVal()) {
                        interval = customStartNode.getWeekVal() - 1 - dayOfWeek;
                        calendar.add(5, interval);
                    }
                    endDay = calendar.get(5);
                    calendar.add(5, 1);
                } else if (month == 12 && startDay + 7 >= yearLastDay) {
                    endDay = yearLastDay;
                } else {
                    calendar.add(5, 6);
                    endDay = calendar.get(5);
                    calendar.add(5, 1);
                }
                name = this.getTreeName(0x10000000, year) + this.getTreeName(0x2000000, week);
                number = this.getTreeNumber(prefix, 0x10000000, year) + "." + this.getTreeNumber(prefix, 0x2000000, week);
                currTreeList.add(this.genTree(name, number, PREFIX_YW, year, month, startDay, month, endDay, week));
                if (month == 12 && endDay == yearLastDay) break;
                ++week;
            }
            treeList.add(currTreeList);
        }
        if ((flag & 0x1000000) == 0x1000000) {
            currTreeList = new ArrayList();
            name = this.getTreeName(0x10000000, year) + this.getTreeName(0x1000000, 1);
            number = this.getTreeNumber(prefix, 0x10000000, year) + "." + this.getTreeNumber(prefix, 0x1000000, 1);
            currTreeList.add(this.genTree(name, number, PREFIX_HY, year, 1, 1, 6, 30, 1));
            name = this.getTreeName(0x10000000, year) + this.getTreeName(0x1000000, 2);
            number = this.getTreeNumber(prefix, 0x10000000, year) + "." + this.getTreeNumber(prefix, 0x1000000, 2);
            currTreeList.add(this.genTree(name, number, PREFIX_HY, year, 7, 1, 12, 31, 2));
            treeList.add(currTreeList);
        }
        if ((flag & 0x100000) == 0x100000) {
            currTreeList = new ArrayList();
            name = this.getTreeName(0x10000000, year) + this.getTreeName(0x100000, 1);
            number = this.getTreeNumber(prefix, 0x10000000, year) + "." + this.getTreeNumber(prefix, 0x1000000, 1) + "." + this.getTreeNumber(prefix, 0x100000, 1);
            currTreeList.add(this.genTree(name, number, PREFIX_SE, year, 1, 1, 3, 31, 1));
            name = this.getTreeName(0x10000000, year) + this.getTreeName(0x100000, 2);
            number = this.getTreeNumber(prefix, 0x10000000, year) + "." + this.getTreeNumber(prefix, 0x1000000, 1) + "." + this.getTreeNumber(prefix, 0x100000, 2);
            currTreeList.add(this.genTree(name, number, PREFIX_SE, year, 4, 1, 6, 30, 2));
            name = this.getTreeName(0x10000000, year) + this.getTreeName(0x100000, 3);
            number = this.getTreeNumber(prefix, 0x10000000, year) + "." + this.getTreeNumber(prefix, 0x1000000, 2) + "." + this.getTreeNumber(prefix, 0x100000, 3);
            currTreeList.add(this.genTree(name, number, PREFIX_SE, year, 7, 1, 9, 30, 3));
            name = this.getTreeName(0x10000000, year) + this.getTreeName(0x100000, 4);
            number = this.getTreeNumber(prefix, 0x10000000, year) + "." + this.getTreeNumber(prefix, 0x1000000, 2) + "." + this.getTreeNumber(prefix, 0x100000, 4);
            currTreeList.add(this.genTree(name, number, PREFIX_SE, year, 10, 1, 12, 31, 4));
            treeList.add(currTreeList);
        }
        if ((flag & 0x10000) == 65536) {
            currTreeList = new ArrayList(10);
            Calendar calendar = this.getYearFirstDayCalendar(year);
            while (calendar.get(1) == year) {
                int month = calendar.get(2) + 1;
                int endDay = this.getMonthLastDay(year, month - 1);
                name = this.getTreeName(0x10000000, year) + this.getTreeName(65536, month);
                number = this.getTreeNumber(prefix, 0x10000000, year) + "." + this.getTreeNumber(prefix, 0x100000, (int)Math.ceil((double)month / 3.0)) + "." + this.getTreeNumber(prefix, 65536, month);
                currTreeList.add(this.genTree(name, number, PREFIX_M, year, month, 1, month, endDay, month));
                calendar.add(2, 1);
            }
            treeList.add(currTreeList);
        }
        if ((flag & 0x100) == 256) {
            currTreeList = new ArrayList(10);
            Calendar calendar = this.getYearFirstDayCalendar(year);
            WeekEnum customStartNode = this.paramInfo.getStartNode();
            while (calendar.get(1) == year) {
                int month = calendar.get(2) + 1;
                int monthLastDay = this.getMonthLastDay(year, month - 1);
                Calendar inMonthCalendar = Calendar.getInstance();
                inMonthCalendar.setFirstDayOfWeek(customStartNode.getWeekVal());
                inMonthCalendar.set(calendar.get(1), calendar.get(2), 1, 0, 0, 0);
                int week = 1;
                while (true) {
                    int endDay;
                    int startDay = inMonthCalendar.get(5);
                    if (week == 1) {
                        dayOfWeek = inMonthCalendar.get(7);
                        if (dayOfWeek == customStartNode.getPreWeekVal()) {
                            inMonthCalendar.add(5, 7);
                        } else if (dayOfWeek >= customStartNode.getWeekVal()) {
                            interval = 6 - (dayOfWeek - customStartNode.getWeekVal());
                            inMonthCalendar.add(5, interval);
                        } else if (dayOfWeek < customStartNode.getWeekVal()) {
                            interval = customStartNode.getWeekVal() - 1 - dayOfWeek;
                            inMonthCalendar.add(5, interval);
                        }
                        endDay = inMonthCalendar.get(5);
                        inMonthCalendar.add(5, 1);
                    } else if (startDay + 7 >= monthLastDay) {
                        endDay = monthLastDay;
                    } else {
                        inMonthCalendar.add(5, 6);
                        endDay = inMonthCalendar.get(5);
                        inMonthCalendar.add(5, 1);
                    }
                    name = this.getTreeName(0x10000000, year) + this.getTreeName(65536, month) + this.getTreeName(256, week);
                    number = this.getTreeNumber(prefix, 0x10000000, year) + "." + this.getTreeNumber(prefix, 65536, month) + "." + this.getTreeNumber(prefix, 256, week);
                    currTreeList.add(this.genTree(name, number, PREFIX_MW, year, month, startDay, month, endDay, month * 100 + week));
                    if (endDay == monthLastDay) break;
                    ++week;
                }
                calendar.add(2, 1);
            }
            treeList.add(currTreeList);
        }
        if ((flag & 0x1000) == 4096) {
            currTreeList = new ArrayList(10);
            Calendar calendar = this.getYearFirstDayCalendar(year);
            while (calendar.get(1) == year) {
                int month = calendar.get(2) + 1;
                int lastDay = this.getMonthLastDay(year, month - 1);
                name = this.getTreeName(0x10000000, year) + this.getTreeName(65536, month) + this.getTreeName(4096, 1);
                number = this.getTreeNumber(prefix, 0x10000000, year) + "." + this.getTreeNumber(prefix, 65536, month) + "." + this.getTreeNumber(prefix, 4096, 1);
                currTreeList.add(this.genTree(name, number, PREFIX_TD, year, month, 1, month, 10, month * 100 + 1));
                name = this.getTreeName(0x10000000, year) + this.getTreeName(65536, month) + this.getTreeName(4096, 2);
                number = this.getTreeNumber(prefix, 0x10000000, year) + "." + this.getTreeNumber(prefix, 65536, month) + "." + this.getTreeNumber(prefix, 4096, 2);
                currTreeList.add(this.genTree(name, number, PREFIX_TD, year, month, 11, month, 20, month * 100 + 2));
                name = this.getTreeName(0x10000000, year) + this.getTreeName(65536, month) + this.getTreeName(4096, 3);
                number = this.getTreeNumber(prefix, 0x10000000, year) + "." + this.getTreeNumber(prefix, 65536, month) + "." + this.getTreeNumber(prefix, 4096, 3);
                currTreeList.add(this.genTree(name, number, PREFIX_TD, year, month, 21, month, lastDay, month * 100 + 3));
                calendar.add(2, 1);
            }
            treeList.add(currTreeList);
        }
        if ((flag & 0x10) == 16) {
            currTreeList = new ArrayList(10);
            Calendar calendar = this.getYearFirstDayCalendar(year);
            while (calendar.get(1) == year) {
                int month = calendar.get(2) + 1;
                int day = calendar.get(5);
                name = this.getTreeName(0x10000000, year) + this.getTreeName(65536, month) + this.getTreeName(16, day);
                number = this.getTreeNumber(prefix, 0x10000000, year) + "." + this.getTreeNumber(prefix, 65536, month) + "." + this.getTreeNumber(prefix, 16, day);
                currTreeList.add(this.genTree(name, number, PREFIX_D, year, month, day, month, day, month * 100 + day));
                calendar.add(5, 1);
            }
            treeList.add(currTreeList);
        }
        this.setHierarchy(year, treeList);
        List<DynamicObject> periodObjs = treeList.stream().flatMap(Collection::stream).map(this::initToDyna).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(periodObjs)) {
            return;
        }
        try (TXHandle tx = TX.required();){
            try {
                final DynamicObject[] saveData = periodObjs.toArray(new DynamicObject[0]);
                SaveServiceHelper.save((DynamicObject[])saveData);
                TX.addCommitListener((CommitListener)new CommitListener(){

                    public void onCommitted() {
                        try (TXHandle tx = TX.requiresNew();){
                            ShrekMemberSyncService shrekMemberSyncService = new ShrekMemberSyncService();
                            try {
                                shrekMemberSyncService.process(saveData);
                                shrekMemberSyncService.afterProcess(saveData);
                            }
                            catch (Exception e) {
                                shrekMemberSyncService.handlerException(saveData);
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private void setHierarchy(int year, List<List<PeriodMemTree>> treeList) {
        for (int i = 0; i < treeList.size(); ++i) {
            String dateStr;
            List<PeriodMemTree> currTreeList = treeList.get(i);
            if (i == 0) {
                for (PeriodMemTree currTree : currTreeList) {
                    this.setParent(this, currTree);
                }
                continue;
            }
            List<PeriodMemTree> directPTreeList = treeList.get(i - 1);
            if (directPTreeList.size() == 0) continue;
            HashMap<String, PeriodMemTree> dateMap = new HashMap<String, PeriodMemTree>();
            Calendar calendar = this.getYearFirstDayCalendar(year);
            int pTreeIdx = 0;
            PeriodMemTree pTree = directPTreeList.get(pTreeIdx);
            while (calendar.get(1) == year) {
                Date curDate = calendar.getTime();
                if (pTree.getEndDate().compareTo(curDate) < 0) {
                    if (pTreeIdx == directPTreeList.size() - 1) break;
                    pTree = directPTreeList.get(++pTreeIdx);
                }
                dateStr = DateTimeUtil.formatDate((Date)curDate);
                dateMap.put(dateStr, pTree);
                calendar.add(5, 1);
            }
            for (PeriodMemTree currTree : currTreeList) {
                dateStr = DateTimeUtil.formatDate((Date)currTree.getStartDate());
                PeriodMemTree matchedPTree = (PeriodMemTree)dateMap.get(dateStr);
                if (matchedPTree == null) continue;
                this.setParent(matchedPTree, currTree);
            }
        }
    }

    private String getTreeNumber(String prefix, int flag, int val) {
        String valStr = String.format("%02d", val);
        String yearSign = this.paramInfo.isHasYear() || this.paramInfo.isHasQuarter() || this.paramInfo.isHasHalfYear() || this.paramInfo.isYearInMonth() || this.paramInfo.isQuarterinMonth() || this.paramInfo.isHalfyearinMonth() ? "_Y" : "_FY";
        switch (flag) {
            case 0x10000000: {
                return prefix + yearSign + valStr;
            }
            case 0x2000000: {
                return PREFIX_YW + valStr;
            }
            case 0x1000000: {
                return "HF" + valStr;
            }
            case 0x100000: {
                return PREFIX_SE + valStr;
            }
            case 65536: {
                return PREFIX_M + valStr;
            }
            case 4096: {
                return PREFIX_TD + valStr;
            }
            case 256: {
                return PREFIX_MW + valStr;
            }
            case 16: {
                return PREFIX_D + valStr;
            }
        }
        return null;
    }

    private String getTreeName(int flag, int val) {
        String valStr = String.format("%02d", val);
        switch (flag) {
            case 0x10000000: {
                return String.join((CharSequence)"", val + "", ResManager.loadKDString((String)"\u5e74", (String)"PeriodMemTree_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            }
            case 0x2000000: {
                return String.join((CharSequence)"", valStr, ResManager.loadKDString((String)"\u5468", (String)"PeriodMemTree_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            }
            case 0x1000000: {
                return val == 1 ? ResManager.loadKDString((String)"\u4e0a\u534a\u5e74", (String)"PeriodMemTree_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0b\u534a\u5e74", (String)"PeriodMemTree_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            }
            case 0x100000: {
                return String.join((CharSequence)"", valStr, ResManager.loadKDString((String)"\u5b63\u5ea6", (String)"PeriodMemTree_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            }
            case 65536: {
                return String.join((CharSequence)"", val + "", ResManager.loadKDString((String)"\u6708", (String)"PeriodMemTree_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            }
            case 4096: {
                return val == 1 ? ResManager.loadKDString((String)"\u4e0a\u65ec", (String)"PeriodMemTree_6", (String)"tmc-fpm-formplugin", (Object[])new Object[0]) : (val == 2 ? ResManager.loadKDString((String)"\u4e2d\u65ec", (String)"PeriodMemTree_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0b\u65ec", (String)"PeriodMemTree_8", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            }
            case 256: {
                return String.join((CharSequence)"", valStr, ResManager.loadKDString((String)"\u5468", (String)"PeriodMemTree_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            }
            case 16: {
                return String.join((CharSequence)"", val + "", ResManager.loadKDString((String)"\u65e5", (String)"PeriodMemTree_9", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            }
        }
        return null;
    }

    private void setParent(PeriodMemTree parent, PeriodMemTree currTree) {
        parent.getChildren().add(currTree);
        parent.setIsleaf(false);
        if (this.getId().compareTo(parent.getId()) == 0) {
            currTree.setParent(Long.valueOf("0"));
            String reportTypeNumber = BusinessDataServiceHelper.loadSingle((Object)this.paramInfo.getReportType(), (String)"fpm_orgreporttype").getString("number");
            currTree.setLongnumber(reportTypeNumber + "." + currTree.getNumber());
        } else {
            currTree.setParent(parent.getId());
            currTree.setLongnumber(parent.getLongnumber() + "." + currTree.getNumber());
        }
        currTree.setLevel(parent.getLevel() + 1);
    }

    private PeriodMemTree genTree(String name, String number, String type, int year, int startMonth, int startDay, int endMonth, int endDay, int seq) {
        PeriodMemTree tree = new PeriodMemTree();
        tree.setName(name);
        tree.setNumber(number);
        tree.setCreator(Long.valueOf(RequestContext.get().getUserId()));
        tree.setBodysystem(Long.parseLong(this.paramInfo.getModel()));
        tree.setDimType(DimsionEnums.PERIOD.getNumber());
        tree.setEnable("1");
        tree.setStatus("C");
        tree.setReportType(this.paramInfo.getReportType());
        tree.setIsleaf(true);
        tree.setYear(year);
        tree.setSerial(Long.valueOf(seq));
        tree.setPeriodtype(type);
        tree.setCreateTime(DateUtils.getCurrentTime());
        tree.setModifytime(DateUtils.getCurrentTime());
        tree.setModifier(Long.valueOf(RequestContext.get().getUserId()));
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, startMonth - 1, startDay, 0, 0, 0);
        Date startDate = DateUtils.getDataFormat((Date)calendar.getTime(), (boolean)true);
        tree.setStartDate(startDate);
        if (startDay > endDay) {
            ++endMonth;
        }
        calendar.set(year, endMonth - 1, endDay, 0, 0, 0);
        Date endDate = DateUtils.getDataFormat((Date)calendar.getTime(), (boolean)false);
        tree.setEndDate(endDate);
        return tree;
    }

    private Calendar getYearFirstDayCalendar(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            calendar.setTime(sdf.parse(String.format("%d-01-01", year)));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return calendar;
    }

    private int getMonthLastDay(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, 1, 0, 0, 0);
        calendar.add(2, 1);
        calendar.add(5, -1);
        return calendar.get(5);
    }

    public String getDynaEntityname() {
        return PERIODMEMBER;
    }

    public List<PeriodMemTree> getChildren() {
        return this.children;
    }

    public void setChildren(List<PeriodMemTree> children) {
        this.children = children;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Long getParent() {
        return this.parent;
    }

    public void setParent(Long parent) {
        this.parent = parent;
    }

    public Boolean getIsleaf() {
        return this.isleaf;
    }

    public void setIsleaf(Boolean isleaf) {
        this.isleaf = isleaf;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getLongnumber() {
        return this.longnumber;
    }

    public void setLongnumber(String longnumber) {
        this.longnumber = longnumber;
    }

    public PeriodParamInfo getParamInfo() {
        return this.paramInfo;
    }

    public void setParamInfo(PeriodParamInfo paramInfo) {
        this.paramInfo = paramInfo;
    }

    public Long getId() {
        return this.id;
    }

    public Object readResolve() {
        this.id = GlobalIdUtil.genGlobalLongId();
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getCreator() {
        return this.creator;
    }

    public void setCreator(Long creator) {
        this.creator = creator;
    }

    public String getEnable() {
        return this.enable;
    }

    public void setEnable(String enable) {
        this.enable = enable;
    }

    public Long getReportType() {
        return this.reporttype;
    }

    public void setReportType(Long reportType) {
        this.reporttype = reportType;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getDimType() {
        return this.dimtype;
    }

    public void setDimType(String dimType) {
        this.dimtype = dimType;
    }

    public Long getBodysystem() {
        return this.bodysystem;
    }

    public void setBodysystem(Long bodysystem) {
        this.bodysystem = bodysystem;
    }

    public Date getModifytime() {
        return this.modifytime;
    }

    public void setModifytime(Date modifytime) {
        this.modifytime = modifytime;
    }

    public Long getModifier() {
        return this.modifier;
    }

    public void setModifier(Long modifier) {
        this.modifier = modifier;
    }

    public Date getStartDate() {
        return this.startdate;
    }

    public void setStartDate(Date startDate) {
        this.startdate = startDate;
    }

    public Date getEndDate() {
        return this.enddate;
    }

    public void setEndDate(Date endDate) {
        this.enddate = endDate;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public Long getSerial() {
        return this.serial;
    }

    public void setSerial(Long serial) {
        this.serial = serial;
    }

    public String getPeriodtype() {
        return this.periodtype;
    }

    public void setPeriodtype(String periodtype) {
        this.periodtype = periodtype;
    }

    public Long getDimension() {
        return this.dimension;
    }

    public void setDimension(Long dimension) {
        this.dimension = dimension;
    }
}

