/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.ie.gather.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.service.ie.gather.convert.GatherLoggerConvert;
import kd.tmc.fpm.business.service.ie.gather.model.GatherRecord;

public class GatherLoggerHelper {
    public static List<GatherRecord> gatherExecLogger(String opName, OperationResult operationResult, List<DynamicObject> opbills, String numberProp) {
        ArrayList<GatherRecord> records = new ArrayList<GatherRecord>(10);
        ArrayList<DynamicObject> errBills = new ArrayList<DynamicObject>(10);
        List validateErrors = operationResult.getValidateResult().getValidateErrors();
        for (ValidateResult validateError : validateErrors) {
            List allErrorInfo = validateError.getAllErrorInfo();
            Map<Integer, List<OperateErrorInfo>> errMsgGroupMap = allErrorInfo.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(o -> o.getDataEntityIndex()));
            for (Map.Entry<Integer, List<OperateErrorInfo>> next : errMsgGroupMap.entrySet()) {
                Integer inx = next.getKey();
                List<OperateErrorInfo> operateErrorInfos = next.getValue();
                String errMsg = operateErrorInfos.stream().filter(Objects::nonNull).map(o -> o.getMessage()).collect(Collectors.joining(";\n"));
                DynamicObject opbill = opbills.get(inx);
                errBills.add(opbill);
                errMsg = String.format("%s:%s:%s", opName, operationResult.getMessage(), errMsg);
                GatherRecord gatherRecord = GatherLoggerConvert.createGatherRecord(opbill, errMsg, Boolean.FALSE, false, numberProp);
                records.add(gatherRecord);
            }
        }
        opbills.removeAll(errBills);
        if (EmptyUtil.isNoEmpty(opbills)) {
            for (DynamicObject opbill : opbills) {
                String message = String.format("%s:%s", opName, ResManager.loadKDString((String)"\u91c7\u96c6\u6210\u529f", (String)"GatherLoggerHelper_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
                GatherRecord gatherRecord = GatherLoggerConvert.createGatherRecord(opbill, message, Boolean.TRUE, false, numberProp);
                records.add(gatherRecord);
            }
        }
        return records;
    }

    public static String cut(String str) {
        if (EmptyUtil.isEmpty((String)str)) {
            return null;
        }
        return str.length() > 80 ? str.substring(0, 79) : str;
    }
}

