/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.ie.gather.service.gather;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.ext.tmc.bizrule.fpm.sync.SyncData;
import kd.bos.ext.tmc.bizrule.fpm.sync.SyncDataManager;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fpm.business.service.ie.gather.convert.GatherLoggerConvert;
import kd.tmc.fpm.business.service.ie.gather.convert.IEGatherSchemeDataConvert;
import kd.tmc.fpm.business.service.ie.gather.helper.MetadateDealHelper;
import kd.tmc.fpm.business.service.ie.gather.helper.SchemeGatherHelper;
import kd.tmc.fpm.business.service.ie.gather.model.GatherLogger;
import kd.tmc.fpm.business.service.ie.gather.model.GatherRecord;
import kd.tmc.fpm.business.service.ie.gather.model.IntelligentGatherScheme;
import kd.tmc.fpm.business.service.ie.gather.service.gather.FpmCollectTransfer;
import kd.tmc.fpm.business.service.ie.gather.service.gather.impl.BalancePoolDiscardService;
import kd.tmc.fpm.business.service.ie.gather.service.gather.impl.ICollectStrategy;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FpmCollectService {
    private static final Log logger = LogFactory.getLog(FpmCollectService.class);
    private static final int DEFAULT_PAGE_SIZE = 800;
    public static final String MUTEXLOCK_MARK = "_collect_";
    private List<Long> schemeIdList;
    private ICollectStrategy strategy;
    private Set<Long> syncedRecordIdSet;

    public FpmCollectService(List<Long> schemeIdList, ICollectStrategy strategy) {
        this.schemeIdList = schemeIdList;
        this.strategy = strategy;
        this.syncedRecordIdSet = new HashSet<Long>(8);
    }

    public void collect(boolean entireCollect) {
        List<IntelligentGatherScheme> schemes = IEGatherSchemeDataConvert.getSmartCollectScheme(new HashSet<Long>(this.schemeIdList));
        Map<String, List<IntelligentGatherScheme>> groupedMap = schemes.stream().collect(Collectors.groupingBy(IntelligentGatherScheme::getSourceBill));
        for (Map.Entry<String, List<IntelligentGatherScheme>> entry : groupedMap.entrySet()) {
            String entityType = entry.getKey();
            HashMap<String, SyncDataManager> dataMgrMap = new HashMap<String, SyncDataManager>(8);
            SyncDataManager syncDataMgr = new SyncDataManager(entityType);
            List discardList = syncDataMgr.getDiscardIdList();
            if (discardList.size() > 0) {
                BalancePoolDiscardService.getInstance().discard(entityType, discardList, new Date());
            }
            SyncDataManager mgr = dataMgrMap.computeIfAbsent(entityType, SyncDataManager::new);
            for (IntelligentGatherScheme scheme : entry.getValue()) {
                this.doWork(scheme, mgr, entireCollect);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork(IntelligentGatherScheme scheme, SyncDataManager syncDataManager, boolean entireCollect) {
        int pageSize = scheme.getBatchSize() == 0 ? 800 : scheme.getBatchSize();
        int billCount = 0;
        logger.info(String.format("%s \u91c7\u96c6\u65b9\u6848\u5f00\u59cb\u91c7\u96c6\uff1a\u91c7\u96c6\u5206\u9875\u5927\u5c0f\u4e3a-> %d\uff0c\u5f00\u59cb\u91c7\u96c6\u65f6\u95f4\u4e3a -> %s", scheme.getName(), pageSize, DateUtils.formatString((Date)new Date(), (String)"yyyyMMdd HH:mm:ss")));
        String breakError = null;
        ArrayList<GatherRecord> records = new ArrayList<GatherRecord>(10);
        MainEntityType sourceMainEntityType = MetadataServiceHelper.getDataEntityType((String)scheme.getSourceBill());
        String numberProp = ((BillEntityType)sourceMainEntityType).getBillNo();
        String mainOrg = sourceMainEntityType.getMainOrg();
        Set<Object> orgs = Sets.newHashSetWithExpectedSize((int)0);
        try {
            orgs = this.strategy.getMainOrgSet(scheme);
            CRCondition applyFilter = (CRCondition)SerializationUtils.fromJsonString((String)scheme.getApplyCondi(), CRCondition.class);
            Set<String> attrs = SchemeGatherHelper.collectQueryAttr(scheme, sourceMainEntityType, applyFilter);
            String queryProps = String.join((CharSequence)",", attrs);
            logger.info(String.format("\u672c\u6b21\u9700\u8981\u67e5\u8be2\u7684\u5c5e\u6027\u6709\uff1a%s", queryProps));
            FilterBuilder filterBuilder = new FilterBuilder(sourceMainEntityType, applyFilter.getFilterCondition(), true);
            filterBuilder.buildFilter(true);
            QFilter qFilter = filterBuilder.getQFilter();
            if (qFilter == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f02\u5e38\uff1a\u9002\u7528\u6761\u4ef6\u4e3a\u7a7a\uff0c\u68c0\u67e5\u63d2\u4ef6\u6821\u9a8c", (String)"FpmCollectService_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            if (orgs != null) {
                qFilter.and(new QFilter(mainOrg, "in", (Object)orgs));
            }
            logger.info(String.format("\u9002\u7528\u6761\u4ef6\u8fc7\u6ee4 QFilter\uff1a%s", qFilter));
            long lastId = 0L;
            while (true) {
                QFilter pageFilter = new QFilter("id", ">", (Object)lastId);
                String entityName = scheme.getSourceBill();
                DynamicObjectCollection idCollection = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{pageFilter, qFilter}, (String)"id", (int)pageSize);
                if (idCollection.isEmpty()) break;
                lastId = ((DynamicObject)idCollection.get(idCollection.size() - 1)).getLong("id");
                Set waitSyncIdSet = idCollection.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
                List syncInfo = syncDataManager.getSyncInfo(new ArrayList(waitSyncIdSet));
                HashMap<Long, SyncData> syncMap = new HashMap<Long, SyncData>(8);
                for (SyncData syncData : syncInfo) {
                    if (!entireCollect && syncData.getStatus() != 0) {
                        waitSyncIdSet.remove(syncData.getId());
                        continue;
                    }
                    syncMap.put(syncData.getId(), syncData);
                }
                if (waitSyncIdSet.isEmpty()) continue;
                QFilter idFilter = new QFilter("id", "in", waitSyncIdSet);
                DataSet dsn = ORM.create().queryDataSet(FpmCollectService.class.getName(), entityName, queryProps, new QFilter[]{idFilter, qFilter});
                Tuple<DynamicObjectCollection, Map<String, DynamicProperty>> tuple = MetadateDealHelper.toPlainDynamicObject(dsn, attrs, scheme);
                DynamicObjectCollection rets = (DynamicObjectCollection)tuple.item1;
                DynamicObject[] bills = (DynamicObject[])rets.toArray((Object[])new DynamicObject[0]);
                billCount += rets.size();
                Map<String, List<DynamicObject>> billMap = Arrays.stream(bills).filter(Objects::nonNull).collect(Collectors.groupingBy(o -> o.getString("id")));
                ArrayList<String> lockIds = new ArrayList<String>(billMap.keySet());
                Map lockResult = MutexServiceHelper.batchRequest(lockIds, (String)scheme.getSourceBill(), (String)MUTEXLOCK_MARK);
                HashSet<String> successLockIds = new HashSet<String>();
                HashSet<String> failedLockIds = new HashSet<String>();
                try (TXHandle tx = TX.requiresNew();){
                    try {
                        for (Map.Entry entry : lockResult.entrySet()) {
                            String key = (String)entry.getKey();
                            if (((Boolean)entry.getValue()).booleanValue()) {
                                successLockIds.add(key);
                                continue;
                            }
                            failedLockIds.add(key);
                        }
                        if (failedLockIds.size() > 0) {
                            for (String failedLockId : failedLockIds) {
                                DynamicObject sourceBill = billMap.get(failedLockId).get(0);
                                String message = String.format(ResManager.loadKDString((String)"\u5355\u636e\u3010%1$s\u3011\u6b63\u5728\u91c7\u96c6\u4e2d\uff0c\u65e0\u6cd5\u91cd\u590d\u8fdb\u884c\u91c7\u96c6", (String)"FpmCollectService_1", (String)"tmc-fpm-business", (Object[])new Object[0]), sourceBill.getString("id"));
                                GatherRecord gatherRecord = GatherLoggerConvert.createGatherRecord(sourceBill, message, Boolean.FALSE, true, numberProp);
                                records.add(gatherRecord);
                            }
                        }
                        DynamicObject[] needGatherBills = (DynamicObject[])Arrays.stream(bills).filter(Objects::nonNull).filter(o -> successLockIds.contains(o.getString("id"))).toArray(DynamicObject[]::new);
                        FpmCollectTransfer transfer = new FpmCollectTransfer(scheme, this.strategy.getUser(), new Date());
                        List<GatherRecord> gatherRecordLst = transfer.transfer(needGatherBills, (Map)tuple.item2);
                        records.addAll(gatherRecordLst);
                        Set successIdSet = records.stream().filter(GatherRecord::getExecuteResult).map(GatherRecord::getSourceBillId).collect(Collectors.toSet());
                        CommonParam param = new CommonParam();
                        ArrayList syncDataList = new ArrayList(waitSyncIdSet.size());
                        waitSyncIdSet = successIdSet;
                        waitSyncIdSet.removeAll(this.syncedRecordIdSet);
                        if (!waitSyncIdSet.isEmpty()) {
                            for (Long dataId : waitSyncIdSet) {
                                SyncData prevSyncInfo = (SyncData)syncMap.get(dataId);
                                HashMap<String, Number> syncInfoMap = new HashMap<String, Number>();
                                syncInfoMap.put("__KEY_DATA_ID", dataId);
                                int version = 1;
                                if (prevSyncInfo != null) {
                                    version = prevSyncInfo.getVersion();
                                }
                                syncInfoMap.put("__KEY_VERSION", version);
                                syncDataList.add(syncInfoMap);
                            }
                            param.put((Object)"__ENTITY_TYPE", (Object)entityName);
                            param.put((Object)"__DATA", syncDataList);
                            param.put((Object)"__OPERATE_TYPE", (Object)"UPDATE");
                            ECGlobalSession.begin((String)"fpm_etlupdate", (DBRoute)DBRoute.of((String)"tmc"), (boolean)true);
                            ECGlobalSession.setAsync((boolean)true);
                            ECGlobalSession.register((String)"tmc", (String)"fpm", (String)"FpmETLUpdateDataService", (Param)param);
                        }
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw e;
                    }
                }
                finally {
                    MutexServiceHelper.batchRelease(new ArrayList(successLockIds), (String)scheme.getSourceBill(), (String)MUTEXLOCK_MARK);
                }
                this.syncedRecordIdSet.addAll(waitSyncIdSet);
            }
        }
        catch (Exception e) {
            try {
                logger.error("\u91c7\u96c6\u4e2d\u65ad\u5f02\u5e38\uff0c\u6392\u67e5\uff1a", (Throwable)e);
                breakError = ExceptionUtils.getStackTrace((Throwable)e);
            }
            catch (Throwable throwable) {
                GatherLogger gatherLogger = GatherLoggerConvert.createGatherLogger(billCount, breakError, records, orgs, scheme);
                DynamicObject gatherLoggerDy = GatherLoggerConvert.convert(gatherLogger, this.strategy.getUser());
                TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{gatherLoggerDy});
                throw throwable;
            }
            GatherLogger gatherLogger = GatherLoggerConvert.createGatherLogger(billCount, breakError, records, orgs, scheme);
            DynamicObject gatherLoggerDy = GatherLoggerConvert.convert(gatherLogger, this.strategy.getUser());
            TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{gatherLoggerDy});
        }
        GatherLogger gatherLogger = GatherLoggerConvert.createGatherLogger(billCount, breakError, records, orgs, scheme);
        DynamicObject gatherLoggerDy = GatherLoggerConvert.convert(gatherLogger, this.strategy.getUser());
        TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{gatherLoggerDy});
    }
}

