/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.ie.gather.service.gather.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.tmc.bizrule.fpm.sync.SyncDataManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.service.ie.gather.convert.GatherLoggerConvert;
import kd.tmc.fpm.business.service.ie.gather.helper.GatherLoggerHelper;
import kd.tmc.fpm.business.service.ie.gather.helper.MetadateDealHelper;
import kd.tmc.fpm.business.service.ie.gather.model.GatherRecord;
import kd.tmc.fpm.business.service.ie.gather.model.IntelligentGatherScheme;
import kd.tmc.fpm.business.service.ie.gather.service.gather.IGatherWorker;
import kd.tmc.fpm.business.service.ie.gather.service.gather.impl.BalancePoolBillGatherServiceImpl;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class AbsIntelligentGatherWorker
implements IGatherWorker {
    private static final Log logger = LogFactory.getLog(AbsIntelligentGatherWorker.class);
    private static final String MUTEXLOCK_MARK = "INTELLIGENT_GATHER_SCHEME_SOURCEBILL_LOCK_KEY";
    private IntelligentGatherScheme scheme;
    private MainEntityType targetMainEntityType;
    private MainEntityType sourceMainEntityType;
    private Set<String> targetAllProps;
    private DynamicObject currUser;
    protected SyncDataManager syncDataManager;

    public AbsIntelligentGatherWorker(IntelligentGatherScheme scheme, DynamicObject currUser) {
        this(scheme, currUser, null);
    }

    public AbsIntelligentGatherWorker(IntelligentGatherScheme scheme, DynamicObject currUser, SyncDataManager syncDataManager) {
        this.scheme = scheme;
        this.currUser = currUser;
        this.targetMainEntityType = MetadataServiceHelper.getDataEntityType((String)scheme.getTargetBill());
        this.sourceMainEntityType = MetadataServiceHelper.getDataEntityType((String)scheme.getSourceBill());
        this.targetAllProps = MetadateDealHelper.collectBillAllProp(this.targetMainEntityType);
        this.syncDataManager = syncDataManager;
    }

    protected List<GatherRecord> work(DynamicObject[] sourceBills, Map<String, DynamicProperty> fldProperties) {
        Map<String, List<DynamicObject>> billMap = Arrays.stream(sourceBills).filter(Objects::nonNull).collect(Collectors.groupingBy(o -> o.getString("id")));
        ArrayList<String> lockIds = new ArrayList<String>(billMap.keySet());
        Map lockResult = MutexServiceHelper.batchRequest(lockIds, (String)this.scheme.getSourceBill(), (String)MUTEXLOCK_MARK);
        ArrayList<String> successLockIds = new ArrayList<String>(10);
        ArrayList<String> failedLockIds = new ArrayList<String>(5);
        ArrayList<GatherRecord> records = new ArrayList<GatherRecord>(10);
        String numberProp = ((BillEntityType)this.sourceMainEntityType).getBillNo();
        try {
            List needGatherBills;
            for (Map.Entry entry : lockResult.entrySet()) {
                String key = (String)entry.getKey();
                if (((Boolean)entry.getValue()).booleanValue()) {
                    successLockIds.add(key);
                    continue;
                }
                failedLockIds.add(key);
            }
            if (failedLockIds.size() > 0) {
                for (String string : failedLockIds) {
                    DynamicObject sourceBill = billMap.get(string).get(0);
                    String message = String.format(ResManager.loadKDString((String)"\u5355\u636e\u3010%1$s\u3011\u6b63\u5728\u91c7\u96c6\u4e2d\uff0c\u65e0\u6cd5\u91cd\u590d\u8fdb\u884c\u91c7\u96c6", (String)"AbsIntelligentGatherWorker_0", (String)"tmc-fpm-business", (Object[])new Object[0]), sourceBill.getString("id"));
                    GatherRecord gatherRecord = GatherLoggerConvert.createGatherRecord(sourceBill, message, Boolean.FALSE, true, numberProp);
                    records.add(gatherRecord);
                }
            }
            if (EmptyUtil.isEmpty(needGatherBills = Arrays.stream(sourceBills).filter(Objects::nonNull).filter(o -> successLockIds.contains(o.getString("id"))).collect(Collectors.toList()))) {
                ArrayList<GatherRecord> arrayList = records;
                return arrayList;
            }
            List list = successLockIds.stream().map(Long::valueOf).collect(Collectors.toList());
            QFilter sourceIdFilter = new QFilter("sourcebillid", "in", list);
            QFilter sourceBillTypeFilter = new QFilter("sourcebill", "=", (Object)this.scheme.getSourceBill());
            DynamicObject[] idWithDiscardStatus = TmcDataServiceHelper.load((String)this.scheme.getTargetBill(), (String)String.join((CharSequence)"id", "abandonstatus", "discard"), (QFilter[])new QFilter[]{sourceBillTypeFilter, sourceIdFilter});
            HashSet<Long> discardIdSet = new HashSet<Long>();
            ArrayList<Long> idList = new ArrayList<Long>();
            for (DynamicObject obj : idWithDiscardStatus) {
                long id = obj.getLong("id");
                boolean abandon = obj.getBoolean("abandonstatus");
                boolean discard = obj.getBoolean("discard");
                if (abandon && !discard) {
                    discardIdSet.add(id);
                    continue;
                }
                idList.add(id);
            }
            DynamicObject[] balancePoolBillArr = BusinessDataServiceHelper.load((String)this.scheme.getTargetBill(), (String)this.targetAllProps.stream().collect(Collectors.joining(",")), (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
            ArrayList<DynamicObject> saveBills = new ArrayList<DynamicObject>(10);
            ArrayList<DynamicObject> updateBills = new ArrayList<DynamicObject>(10);
            for (DynamicObject sourceBill : needGatherBills) {
                try {
                    DynamicObject newBill;
                    BalancePoolBillGatherServiceImpl gatherService = new BalancePoolBillGatherServiceImpl(balancePoolBillArr, fldProperties, this.targetMainEntityType, this.sourceMainEntityType, this.currUser);
                    Tuple gathers = gatherService.gather(this.scheme, sourceBill);
                    DynamicObject updateBill = (DynamicObject)gathers.item1;
                    if (EmptyUtil.isNoEmpty((DynamicObject)updateBill)) {
                        updateBills.add(updateBill);
                        if (discardIdSet.contains(updateBill.getLong("id"))) {
                            updateBill.set("repeatcollect", (Object)"1");
                        }
                    }
                    if (!EmptyUtil.isNoEmpty((DynamicObject)(newBill = (DynamicObject)gathers.item2))) continue;
                    saveBills.add(newBill);
                }
                catch (Exception e) {
                    String message = String.format(ResManager.loadKDString((String)"\u5355\u636e\u3010%1$s\u3011\u91c7\u96c6\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a\n %2$s", (String)"AbsIntelligentGatherWorker_1", (String)"tmc-fpm-business", (Object[])new Object[0]), sourceBill.getString("id"), ExceptionUtils.getStackTrace((Throwable)e));
                    GatherRecord gatherRecord = GatherLoggerConvert.createGatherRecord(sourceBill, message, Boolean.FALSE, true, numberProp);
                    records.add(gatherRecord);
                }
            }
            if (EmptyUtil.isNoEmpty(updateBills)) {
                OperationResult updateResult = TmcOperateServiceHelper.execOperate((String)"save", (String)this.scheme.getTargetBill(), (DynamicObject[])updateBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                List<GatherRecord> upRecords = GatherLoggerHelper.gatherExecLogger("update-op", updateResult, updateBills, numberProp);
                records.addAll(upRecords);
            }
            if (EmptyUtil.isNoEmpty(saveBills)) {
                OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)this.scheme.getTargetBill(), (DynamicObject[])saveBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                List<GatherRecord> saRecords = GatherLoggerHelper.gatherExecLogger("save-op", saveResult, saveBills, numberProp);
                records.addAll(saRecords);
            }
            logger.info("%s \u91c7\u96c6\u65b9\u6848\u91c7\u96c6\u6570\u636e\u7ed3\u675f\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a%s", (Object)this.scheme.getName(), (Object)DateUtils.formatString((Date)new Date(), (String)"yyyyMMdd HH:mm:ss"));
        }
        catch (Exception e) {
            logger.error("\u91c7\u96c6\u4e2d\u65ad\u9519\u8bef: ", (Throwable)e);
            throw new KDBizException(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            MutexServiceHelper.batchRelease(successLockIds, (String)this.scheme.getSourceBill(), (String)MUTEXLOCK_MARK);
        }
        return records;
    }
}

