/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.ie.gather.service.gather.impl;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.service.ie.gather.model.ApplyOrg;
import kd.tmc.fpm.business.service.ie.gather.model.IntelligentGatherScheme;
import kd.tmc.fpm.business.service.ie.gather.service.gather.impl.ICollectStrategy;

public class ManualCollectStrategy
implements ICollectStrategy {
    private Set<Long> orgs;

    public ManualCollectStrategy(Set<Long> orgs) {
        this.orgs = orgs;
    }

    @Override
    public Set<Long> getMainOrgSet(IntelligentGatherScheme schema) {
        Set<Long> mainOrgIdSet = this.orgs;
        List<ApplyOrg> applyOrgs = schema.getApplyOrgs();
        if (EmptyUtil.isNoEmpty(applyOrgs)) {
            Set schemeApplyOrgIds = applyOrgs.stream().filter(Objects::nonNull).map(o -> o.getOrgId()).collect(Collectors.toSet());
            mainOrgIdSet = this.orgs.stream().filter(Objects::nonNull).filter(o -> schemeApplyOrgIds.contains(o)).collect(Collectors.toSet());
        }
        if (EmptyUtil.isEmpty(mainOrgIdSet)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f02\u5e38\uff1a\u7b26\u5408\u8981\u6c42\u7684\u4f7f\u7528\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u91c7\u96c6\u65b9\u6848\u914d\u7f6e\u7684\u9002\u7528\u7ec4\u7ec7", (String)"ManualCollectStrategy_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        return mainOrgIdSet;
    }

    @Override
    public DynamicObject getUser() {
        Long currentUserId = Long.valueOf(RequestContext.get().getUserId());
        DynamicObject currUser = BusinessDataServiceHelper.loadSingleFromCache((Object)currentUserId, (String)"bos_user");
        return currUser;
    }
}

