/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.ie.gather.service.gather.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.ext.tmc.bizrule.fpm.sync.SyncData;
import kd.bos.ext.tmc.bizrule.fpm.sync.SyncDataManager;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.service.ie.gather.convert.GatherLoggerConvert;
import kd.tmc.fpm.business.service.ie.gather.helper.MetadateDealHelper;
import kd.tmc.fpm.business.service.ie.gather.helper.SchemeGatherHelper;
import kd.tmc.fpm.business.service.ie.gather.model.ApplyOrg;
import kd.tmc.fpm.business.service.ie.gather.model.GatherLogger;
import kd.tmc.fpm.business.service.ie.gather.model.GatherRecord;
import kd.tmc.fpm.business.service.ie.gather.model.IntelligentGatherScheme;
import kd.tmc.fpm.business.service.ie.gather.service.gather.impl.AbsIntelligentGatherWorker;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ManualIntelligentGatherWorker
extends AbsIntelligentGatherWorker {
    private static final Log logger = LogFactory.getLog(ManualIntelligentGatherWorker.class);
    private IntelligentGatherScheme scheme;
    private int pageSize = 800;
    private Set<Long> orgs;
    private DynamicObject currUser;

    public ManualIntelligentGatherWorker(IntelligentGatherScheme scheme, Set<Long> orgs, DynamicObject currUser, int pageSize, SyncDataManager syncDataManager) {
        super(scheme, currUser, syncDataManager);
        this.scheme = scheme;
        this.pageSize = pageSize;
        this.orgs = orgs;
        this.currUser = currUser;
    }

    public ManualIntelligentGatherWorker(IntelligentGatherScheme scheme, Set<Long> orgs, DynamicObject currUser, SyncDataManager syncDataManager) {
        this(scheme, orgs, currUser, 800, syncDataManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWork() {
        Integer cnt;
        logger.info(String.format("%s \u91c7\u96c6\u65b9\u6848\u5f00\u59cb\u91c7\u96c6\uff1a\u91c7\u96c6\u5206\u9875\u5927\u5c0f\u4e3a-> %d\uff0c\u5f00\u59cb\u91c7\u96c6\u65f6\u95f4\u4e3a -> %s", this.scheme.getName(), this.pageSize, DateUtils.formatString((Date)new Date(), (String)"yyyyMMdd HH:mm:ss")));
        String breakError = null;
        DynamicObject[] bills = null;
        ArrayList<GatherRecord> records = new ArrayList<GatherRecord>(10);
        try {
            MainEntityType sourceMainEntityType = MetadataServiceHelper.getDataEntityType((String)this.scheme.getSourceBill());
            CRCondition applyFilter = (CRCondition)SerializationUtils.fromJsonString((String)this.scheme.getApplyCondi(), CRCondition.class);
            Set<String> attrs = SchemeGatherHelper.collectQueryAttr(this.scheme, sourceMainEntityType, applyFilter);
            String queryProps = attrs.stream().collect(Collectors.joining(","));
            logger.info(String.format("\u672c\u6b21\u9700\u8981\u67e5\u8be2\u7684\u5c5e\u6027\u6709\uff1a%s", queryProps));
            FilterBuilder filterBuilder = new FilterBuilder(sourceMainEntityType, applyFilter.getFilterCondition(), true);
            filterBuilder.buildFilter(true);
            QFilter qFilter = filterBuilder.getQFilter();
            if (qFilter == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f02\u5e38\uff1a\u9002\u7528\u6761\u4ef6\u4e3a\u7a7a\uff0c\u68c0\u67e5\u63d2\u4ef6\u6821\u9a8c", (String)"ManualIntelligentGatherWorker_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            String mainOrg = sourceMainEntityType.getMainOrg();
            List<ApplyOrg> applyOrgs = this.scheme.getApplyOrgs();
            if (EmptyUtil.isNoEmpty(applyOrgs)) {
                Set schemeApplyOrgIds = applyOrgs.stream().filter(Objects::nonNull).map(o -> o.getOrgId()).collect(Collectors.toSet());
                this.orgs = this.orgs.stream().filter(Objects::nonNull).filter(o -> schemeApplyOrgIds.contains(o)).collect(Collectors.toSet());
            }
            if (EmptyUtil.isEmpty(this.orgs)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f02\u5e38\uff1a\u7b26\u5408\u8981\u6c42\u7684\u4f7f\u7528\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u91c7\u96c6\u65b9\u6848\u914d\u7f6e\u7684\u9002\u7528\u7ec4\u7ec7", (String)"ManualIntelligentGatherWorker_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            qFilter.and(new QFilter(mainOrg, "in", this.orgs));
            logger.info(String.format("\u9002\u7528\u6761\u4ef6\u8fc7\u6ee4 QFilter\uff1a%s", qFilter.toString()));
            long lastId = 0L;
            while (true) {
                TXHandle tx = TX.requiresNew();
                Throwable throwable = null;
                try {
                    QFilter pageFilter = new QFilter("id", ">", (Object)lastId);
                    String entityName = this.scheme.getSourceBill();
                    DynamicObjectCollection idCollection = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{pageFilter, qFilter}, (String)"id", (int)this.pageSize);
                    if (idCollection.isEmpty()) break;
                    lastId = ((DynamicObject)idCollection.get(idCollection.size() - 1)).getLong("id");
                    Set waitSyncIdSet = idCollection.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
                    List syncInfo = this.syncDataManager.getSyncInfo(new ArrayList(waitSyncIdSet));
                    HashMap<Long, SyncData> syncMap = new HashMap<Long, SyncData>(8);
                    for (SyncData syncData : syncInfo) {
                        if (syncData.getStatus() != 0) {
                            waitSyncIdSet.remove(syncData.getId());
                            continue;
                        }
                        syncMap.put(syncData.getId(), syncData);
                    }
                    if (waitSyncIdSet.isEmpty()) break;
                    try {
                        QFilter idFilter = new QFilter("id", "in", waitSyncIdSet);
                        DataSet dsn = ORM.create().queryDataSet(ManualIntelligentGatherWorker.class.getName(), entityName, queryProps, new QFilter[]{idFilter, qFilter});
                        Tuple<DynamicObjectCollection, Map<String, DynamicProperty>> tuple = MetadateDealHelper.toPlainDynamicObject(dsn, attrs, this.scheme);
                        DynamicObjectCollection rets = (DynamicObjectCollection)tuple.item1;
                        bills = (DynamicObject[])rets.toArray((Object[])new DynamicObject[0]);
                        List<GatherRecord> gatherRecordLst = super.work(bills, (Map)tuple.item2);
                        records.addAll(gatherRecordLst);
                        CommonParam param = new CommonParam();
                        ArrayList syncDataList = new ArrayList(waitSyncIdSet.size());
                        for (Long dataId : waitSyncIdSet) {
                            SyncData prevSyncInfo = (SyncData)syncMap.get(dataId);
                            HashMap<String, Number> syncInfoMap = new HashMap<String, Number>();
                            syncInfoMap.put("__KEY_DATA_ID", dataId);
                            int version = 1;
                            if (prevSyncInfo != null) {
                                version = prevSyncInfo.getVersion();
                            }
                            syncInfoMap.put("__KEY_VERSION", version);
                            syncDataList.add(syncInfoMap);
                        }
                        param.put((Object)"__ENTITY_TYPE", (Object)entityName);
                        param.put((Object)"__DATA", syncDataList);
                        param.put((Object)"__OPERATE_TYPE", (Object)"UPDATE");
                        ECGlobalSession.begin((String)"fpm_etlupdate", (DBRoute)DBRoute.of((String)"tmc"), (boolean)true);
                        ECGlobalSession.setAsync((boolean)true);
                        ECGlobalSession.register((String)"tmc", (String)"fpm", (String)"FpmETLUpdateDataService", (Param)param);
                        continue;
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw e;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tx.close();
                    continue;
                }
                break;
            }
            cnt = Optional.ofNullable(bills).map(o -> ((DynamicObject[])o).length).orElseGet(() -> 0);
        }
        catch (Exception e) {
            Integer cnt2;
            try {
                logger.error("\u91c7\u96c6\u4e2d\u65ad\u5f02\u5e38\uff0c\u6392\u67e5\uff1a", (Throwable)e);
                breakError = ExceptionUtils.getStackTrace((Throwable)e);
                cnt2 = Optional.ofNullable(bills).map(o -> ((DynamicObject[])o).length).orElseGet(() -> 0);
            }
            catch (Throwable throwable) {
                Integer cnt3 = Optional.ofNullable(bills).map(o -> ((DynamicObject[])o).length).orElseGet(() -> 0);
                GatherLogger gatherLogger = GatherLoggerConvert.createGatherLogger(cnt3, breakError, records, this.orgs, this.scheme);
                DynamicObject gatherLoggerDy = GatherLoggerConvert.convert(gatherLogger, this.currUser);
                TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{gatherLoggerDy});
                throw throwable;
            }
            GatherLogger gatherLogger = GatherLoggerConvert.createGatherLogger(cnt2, breakError, records, this.orgs, this.scheme);
            DynamicObject gatherLoggerDy = GatherLoggerConvert.convert(gatherLogger, this.currUser);
            TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{gatherLoggerDy});
        }
        GatherLogger gatherLogger = GatherLoggerConvert.createGatherLogger(cnt, breakError, records, this.orgs, this.scheme);
        DynamicObject gatherLoggerDy = GatherLoggerConvert.convert(gatherLogger, this.currUser);
        TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{gatherLoggerDy});
    }
}

