/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.ie.gather.service.gather.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.service.ie.gather.convert.GatherLoggerConvert;
import kd.tmc.fpm.business.service.ie.gather.helper.MetadateDealHelper;
import kd.tmc.fpm.business.service.ie.gather.helper.SchemeGatherHelper;
import kd.tmc.fpm.business.service.ie.gather.model.ApplyOrg;
import kd.tmc.fpm.business.service.ie.gather.model.GatherLogger;
import kd.tmc.fpm.business.service.ie.gather.model.GatherRecord;
import kd.tmc.fpm.business.service.ie.gather.model.IntelligentGatherScheme;
import kd.tmc.fpm.business.service.ie.gather.service.gather.impl.AbsIntelligentGatherWorker;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class TimingIntelligentGatherWorker
extends AbsIntelligentGatherWorker {
    private static final Log logger = LogFactory.getLog(TimingIntelligentGatherWorker.class);
    private int pageSize = 800;
    private IntelligentGatherScheme scheme;

    public TimingIntelligentGatherWorker(IntelligentGatherScheme scheme) {
        super(scheme, null);
        this.scheme = scheme;
        this.pageSize = scheme.getBatchSize();
    }

    public TimingIntelligentGatherWorker(IntelligentGatherScheme scheme, int pageSize) {
        super(scheme, null);
        this.scheme = scheme;
        this.pageSize = pageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWork() {
        Integer cnt;
        logger.info(String.format("%s \u91c7\u96c6\u65b9\u6848\u5f00\u59cb\u91c7\u96c6\uff1a\u91c7\u96c6\u5206\u9875\u5927\u5c0f\u4e3a-> %d\uff0c\u5f00\u59cb\u91c7\u96c6\u65f6\u95f4\u4e3a -> %s", this.scheme.getName(), this.pageSize, DateUtils.formatString((Date)new Date(), (String)"yyyyMMdd HH:mm:ss")));
        String breakError = null;
        DynamicObject[] bills = null;
        Set<Long> orgs = null;
        ArrayList<GatherRecord> records = new ArrayList<GatherRecord>(10);
        try {
            DataSet dsn;
            MainEntityType sourceMainEntityType = MetadataServiceHelper.getDataEntityType((String)this.scheme.getSourceBill());
            CRCondition applyFilter = (CRCondition)SerializationUtils.fromJsonString((String)this.scheme.getApplyCondi(), CRCondition.class);
            FilterBuilder filterBuilder = new FilterBuilder(sourceMainEntityType, applyFilter.getFilterCondition(), true);
            filterBuilder.buildFilter(true);
            QFilter qFilter = filterBuilder.getQFilter();
            if (qFilter == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f02\u5e38\uff1a\u9002\u7528\u6761\u4ef6\u4e3a\u7a7a\uff0c\u68c0\u67e5\u63d2\u4ef6\u6821\u9a8c", (String)"TimingIntelligentGatherWorker_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            List<ApplyOrg> applyOrgs = this.scheme.getApplyOrgs();
            if (EmptyUtil.isNoEmpty(applyOrgs)) {
                orgs = applyOrgs.stream().filter(Objects::nonNull).map(o -> o.getOrgId()).collect(Collectors.toSet());
                String mainOrg = sourceMainEntityType.getMainOrg();
                qFilter.and(new QFilter(mainOrg, "in", orgs));
            }
            logger.info(String.format("\u9002\u7528\u6761\u4ef6\u8fc7\u6ee4 QFilter\uff1a%s", qFilter.toString()));
            int count = TmcDataServiceHelper.count((String)this.scheme.getSourceBill(), (QFilter[])new QFilter[]{qFilter});
            logger.info(String.format("\u4e1a\u52a1\u6765\u6e90\u5355\u3010%s\u3011\u7ecf\u9002\u7528\u6761\u4ef6\u8fc7\u6ee4\u4e4b\u540e\u7684\u603b\u5355\u6570\uff1a%d", this.scheme.getSourceBill(), count));
            Set<String> attrs = SchemeGatherHelper.collectQueryAttr(this.scheme, sourceMainEntityType, applyFilter);
            String queryProps = attrs.stream().collect(Collectors.joining(","));
            logger.info(String.format("\u672c\u6b21\u9700\u8981\u67e5\u8be2\u7684\u5c5e\u6027\u6709\uff1a%s", queryProps));
            ORM orm = ORM.create();
            int page = 0;
            while (!(dsn = ORM.create().queryDataSet(TimingIntelligentGatherWorker.class.getName(), this.scheme.getSourceBill(), queryProps, new QFilter[]{qFilter}, "id desc", page * this.pageSize, this.pageSize)).isEmpty()) {
                Tuple<DynamicObjectCollection, Map<String, DynamicProperty>> tuple = MetadateDealHelper.toPlainDynamicObject(dsn, attrs, this.scheme);
                DynamicObjectCollection rets = (DynamicObjectCollection)tuple.item1;
                bills = (DynamicObject[])rets.toArray((Object[])new DynamicObject[0]);
                List<GatherRecord> gatherRecordLst = super.work(bills, (Map)tuple.item2);
                records.addAll(gatherRecordLst);
                logger.info(String.format("\u3010%s\u3011\u91c7\u96c6\u65b9\u6848\u5f00\u59cb\u7b2c %d \u6279\u6b21\u91c7\u96c6\u6570\u636e\uff0c\u672c\u6b21\u91c7\u96c6 %s \u6761...", this.scheme.getName(), page, rets.size()));
                ++page;
            }
            cnt = Optional.ofNullable(bills).map(o -> ((DynamicObject[])o).length).orElseGet(() -> 0);
        }
        catch (Exception e) {
            Integer cnt2;
            try {
                logger.error("\u91c7\u96c6\u4e2d\u65ad\u5f02\u5e38\uff0c\u6392\u67e5\uff1a", (Throwable)e);
                breakError = ExceptionUtils.getStackTrace((Throwable)e);
                cnt2 = Optional.ofNullable(bills).map(o -> ((DynamicObject[])o).length).orElseGet(() -> 0);
            }
            catch (Throwable throwable) {
                Integer cnt3 = Optional.ofNullable(bills).map(o -> ((DynamicObject[])o).length).orElseGet(() -> 0);
                GatherLogger gatherLogger = GatherLoggerConvert.createGatherLogger(cnt3, breakError, records, orgs, this.scheme);
                DynamicObject gatherLoggerDy = GatherLoggerConvert.convert(gatherLogger, null);
                TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{gatherLoggerDy});
                throw throwable;
            }
            GatherLogger gatherLogger = GatherLoggerConvert.createGatherLogger(cnt2, breakError, records, orgs, this.scheme);
            DynamicObject gatherLoggerDy = GatherLoggerConvert.convert(gatherLogger, null);
            TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{gatherLoggerDy});
        }
        GatherLogger gatherLogger = GatherLoggerConvert.createGatherLogger(cnt, breakError, records, orgs, this.scheme);
        DynamicObject gatherLoggerDy = GatherLoggerConvert.convert(gatherLogger, null);
        TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{gatherLoggerDy});
    }
}

