/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.ie.gather.service.parse.impl;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.builder.FormulaGetHandle;
import kd.tmc.fbp.common.builder.ISingleTaskContext;
import kd.tmc.fbp.common.builder.SingleTaskContext;
import kd.tmc.fpm.business.service.ie.gather.service.parse.ICondiExpressParse;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FormulaExpressParseServiceImpl
implements ICondiExpressParse<CRCondition> {
    private static final Log logger = LogFactory.getLog(FormulaExpressParseServiceImpl.class);
    private Map<String, DynamicProperty> fldProperties;

    public FormulaExpressParseServiceImpl(Map<String, DynamicProperty> fldProperties) {
        this.fldProperties = fldProperties;
    }

    @Override
    public Object parse(DynamicObject sourceBill, CRCondition condition) {
        if (sourceBill == null) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u6267\u884c\u8868\u8fbe\u5f0f\u89e3\u6790\u7684\u6e90\u5355\u4e3a\u7a7a", (String)"FormulaExpressParseServiceImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        if (condition == null) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u6267\u884c\u8868\u8fbe\u5f0f\u7684\u89e3\u6790\u8868\u8fbe\u5f0f\u6761\u4ef6\u4e3a\u7a7a", (String)"FormulaExpressParseServiceImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        if (this.fldProperties == null || this.fldProperties.isEmpty()) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u6e90\u5355\u5b57\u6bb5\u5339\u914d\u5173\u7cfbMap\u96c6\u5408\u4e3a\u7a7a", (String)"FormulaExpressParseServiceImpl_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        Object value = null;
        String billNo = sourceBill.getDataEntityType().getName();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)billNo);
        String filterStr = condition.buildFullFormula(mainEntityType);
        SingleTaskContext taskContext = new SingleTaskContext();
        taskContext.setSrcEntityType(mainEntityType);
        if (!StringUtils.isEmpty((String)filterStr)) {
            try {
                FormulaGetHandle basebillFilterHandle = new FormulaGetHandle((ISingleTaskContext)taskContext, filterStr, (Object)Boolean.FALSE);
                value = basebillFilterHandle.GetVchFldValue(this.fldProperties, sourceBill, null);
            }
            catch (Exception e) {
                value = String.format("%s%s => %s", ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u662f\u5426\u9519\u8bef\uff1a", (String)"FormulaExpressParseServiceImpl_3", (String)"tmc-fpm-business", (Object[])new Object[0]), condition.getExpression(), ExceptionUtils.getStackTrace((Throwable)e));
                logger.error(value.toString());
            }
        } else {
            value = "";
        }
        return value;
    }
}

