/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.interior.offset.factory;

import kd.tmc.fpm.business.domain.enums.DiffProcessModeType;
import kd.tmc.fpm.business.service.interior.offset.model.InternalOffsetParam;
import kd.tmc.fpm.business.service.interior.offset.service.IInternalOffset;
import kd.tmc.fpm.business.service.interior.offset.service.impl.AbsInternalOffsetStrategy;
import kd.tmc.fpm.business.service.interior.offset.service.impl.DiffOffsetStrategy;
import kd.tmc.fpm.business.service.interior.offset.service.impl.FullOffsetStrategy;
import kd.tmc.fpm.business.service.interior.offset.service.impl.MaxOrMinStrategy;

public class InternalOffsetStrategyFactory {
    public static IInternalOffset getInternalOffsetStrategy(InternalOffsetParam internalOffsetParam) {
        DiffProcessModeType diffProcessMode = internalOffsetParam.getAuxiliaryData().getSubjectConfig().getDiffProcessMode();
        AbsInternalOffsetStrategy strategy = null;
        switch (diffProcessMode.getNumber()) {
            case "Big": 
            case "Small": {
                strategy = new MaxOrMinStrategy(internalOffsetParam);
                break;
            }
            case "FullOffset": {
                strategy = new FullOffsetStrategy(internalOffsetParam);
                break;
            }
            case "InflowDiff": 
            case "OutflowDiff": {
                strategy = new DiffOffsetStrategy(internalOffsetParam);
            }
        }
        return strategy;
    }
}

