/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.interior.offset.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DiffProcessModeType;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancelDetail;
import kd.tmc.fpm.common.enums.DiffDirectionEnum;

public class InternalOffsetDetailModel
implements Serializable {
    private List<InnerCancelDetail> inflowCancelDetails;
    private List<InnerCancelDetail> outflowCancelDetails;
    private boolean isOtherDimEmpty = false;

    public InternalOffsetDetailModel() {
        this.inflowCancelDetails = new ArrayList<InnerCancelDetail>(5);
        this.outflowCancelDetails = new ArrayList<InnerCancelDetail>(5);
    }

    public InternalOffsetDetailModel(boolean isOtherDimEmpty) {
        this.isOtherDimEmpty = isOtherDimEmpty;
        this.inflowCancelDetails = new ArrayList<InnerCancelDetail>(5);
        this.outflowCancelDetails = new ArrayList<InnerCancelDetail>(5);
    }

    public BigDecimal getSumCancelAmt(DiffProcessModeType diffProcessModeType) {
        BigDecimal inflowCancleAmt = this.inflowCancelDetails.stream().map(InnerCancelDetail::getCancelAmt).reduce(BigDecimal::add).orElseGet(() -> BigDecimal.ZERO);
        if (diffProcessModeType == DiffProcessModeType.BIG || diffProcessModeType == DiffProcessModeType.SMALL) {
            return inflowCancleAmt;
        }
        if (diffProcessModeType == DiffProcessModeType.FULLOFFSET || diffProcessModeType == DiffProcessModeType.INFLOWDIFF || diffProcessModeType == DiffProcessModeType.OUTFLOWDIFF) {
            BigDecimal outflowCancleAmt = this.outflowCancelDetails.stream().map(InnerCancelDetail::getCancelAmt).reduce(BigDecimal::add).orElseGet(() -> BigDecimal.ZERO);
            return inflowCancleAmt.compareTo(outflowCancleAmt) > 0 ? inflowCancleAmt : outflowCancleAmt;
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getSumDiffAmt(DiffProcessModeType diffProcessModeType) {
        if (diffProcessModeType == DiffProcessModeType.BIG || diffProcessModeType == DiffProcessModeType.SMALL || diffProcessModeType == DiffProcessModeType.INFLOWDIFF || diffProcessModeType == DiffProcessModeType.OUTFLOWDIFF) {
            BigDecimal inflowSumCancelAmt = this.inflowCancelDetails.stream().map(InnerCancelDetail::getBalanceAmt).reduce(BigDecimal::add).orElseGet(() -> BigDecimal.ZERO);
            BigDecimal outflowSumCancelAmt = this.outflowCancelDetails.stream().map(InnerCancelDetail::getBalanceAmt).reduce(BigDecimal::add).orElseGet(() -> BigDecimal.ZERO);
            return inflowSumCancelAmt.add(outflowSumCancelAmt);
        }
        return BigDecimal.ZERO;
    }

    public DiffDirectionEnum getDiffDirection() {
        BigDecimal inflowSumCancleAmt = this.inflowCancelDetails.stream().map(InnerCancelDetail::getBalanceAmt).reduce(BigDecimal::add).orElseGet(() -> BigDecimal.ZERO);
        if (inflowSumCancleAmt.compareTo(BigDecimal.ZERO) != 0) {
            return DiffDirectionEnum.INFLOW;
        }
        BigDecimal outflowSumCancelAmt = this.outflowCancelDetails.stream().map(InnerCancelDetail::getBalanceAmt).reduce(BigDecimal::add).orElseGet(() -> BigDecimal.ZERO);
        if (outflowSumCancelAmt.compareTo(BigDecimal.ZERO) != 0) {
            return DiffDirectionEnum.OUTFLOW;
        }
        return null;
    }

    public List<InnerCancelDetail> getAllCancleDetails() {
        ArrayList<InnerCancelDetail> details = new ArrayList<InnerCancelDetail>(10);
        if (EmptyUtil.isNoEmpty(this.inflowCancelDetails)) {
            details.addAll(this.inflowCancelDetails);
        }
        if (EmptyUtil.isNoEmpty(this.outflowCancelDetails)) {
            details.addAll(this.outflowCancelDetails);
        }
        return details;
    }

    public List<InnerCancelDetail> getInflowCancelDetails() {
        return this.inflowCancelDetails;
    }

    public void setInflowCancelDetails(List<InnerCancelDetail> inflowCancelDetails) {
        this.inflowCancelDetails = inflowCancelDetails;
    }

    public List<InnerCancelDetail> getOutflowCancelDetails() {
        return this.outflowCancelDetails;
    }

    public void setOutflowCancelDetails(List<InnerCancelDetail> outflowCancelDetails) {
        this.outflowCancelDetails = outflowCancelDetails;
    }
}

