/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.interior.offset.service.compare.provider.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.BasedataEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.common.compare.data.CompareRule;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.domain.enums.DetailDataType;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.sumplan.AccurateMatchScheme;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.service.interior.offset.service.compare.provider.IInternalOffsetDataProvider;
import kd.tmc.fpm.common.enums.MatchRelationEnum;

public class InternalOffsetCompareDataProvider
implements IInternalOffsetDataProvider {
    private FundPlanSystem fundPlanSystem;
    private AccurateMatchScheme scheme;

    public InternalOffsetCompareDataProvider(FundPlanSystem fundPlanSystem, AccurateMatchScheme scheme) {
        this.fundPlanSystem = fundPlanSystem;
        this.scheme = scheme;
    }

    @Override
    public List<Map<String, Object>> buildCompareDataMap(List<ReportDataQueryResult> datas) {
        Map<Long, DimMember> memberMappingRelationMap = this.fundPlanSystem.getDimList().stream().map(o -> o.getAllDimMemberList()).flatMap(Collection::stream).collect(Collectors.toMap(o -> o.getId(), o -> o));
        Map<Long, String> dimIdMappingDimNumber = this.fundPlanSystem.getDimList().stream().collect(Collectors.toMap(dim -> dim.getId(), dim -> dim.getDimType() == DimensionType.DETAILDIM ? dim.getDetailDimType().getNumber() : dim.getNumber()));
        return this.createDataMap(memberMappingRelationMap, dimIdMappingDimNumber, datas, this.scheme);
    }

    @Override
    public List<List<CompareRule>> getRule(AccurateMatchScheme scheme) {
        List rules = scheme.getSchemeEntrys().stream().filter(Objects::nonNull).map(schemeEntry -> {
            ArrayList<CompareRule> tempCR = new ArrayList<CompareRule>(2);
            Integer extraVal = null;
            CompareRule.Symbol symbol = CompareRule.Symbol.EQUALS;
            if (schemeEntry.getRelation() == MatchRelationEnum.LIKE) {
                symbol = CompareRule.Symbol.STR_MATCH;
                extraVal = 0;
            }
            CompareRule cr1 = new CompareRule(symbol, (Object)extraVal, schemeEntry.getOurSideField(), schemeEntry.getOtherSideField(), false);
            tempCR.add(cr1);
            CompareRule cr2 = new CompareRule(symbol, (Object)extraVal, schemeEntry.getOtherSideField(), schemeEntry.getOurSideField(), false);
            tempCR.add(cr2);
            return tempCR;
        }).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(rules)) {
            return Collections.singletonList(rules);
        }
        return null;
    }

    protected String getDimMemberVal(String dimTypeNumber, ReportDataQueryResult queryResult, Map<Long, DimMember> memberMappingRelationMap, Map<Long, String> dimIdMappingDimNumber, String attr) {
        Tuple<Object, DetailDataType> tuple = this.getValByDimType(dimTypeNumber, dimIdMappingDimNumber, queryResult);
        if (tuple == null) {
            return null;
        }
        Object memberVal = tuple.item1;
        if (EmptyUtil.isEmpty((Object)memberVal)) {
            return null;
        }
        String billSign = null;
        if (dimTypeNumber.equals("business_partner")) {
            billSign = DetailDimType.BUSINESS_PARTNER.getExtVal().toString();
        } else if (dimTypeNumber.equals(DetailDimType.COUNTERPARTY_NAME.getNumber())) {
            Tuple<Object, DetailDataType> typeTuple = this.getValByDimType(DetailDimType.CONNTERPARTY_TYPE.getNumber(), dimIdMappingDimNumber, queryResult);
            if (typeTuple == null) {
                throw new KDBizException("not find bill sign.");
            }
            billSign = typeTuple.item1.toString();
        }
        String returnVal = "";
        if (billSign == null) {
            if (tuple.item2 == DetailDataType.TEXT || memberVal instanceof String) {
                returnVal = Optional.ofNullable(memberVal).map(o -> o.toString()).orElseGet(() -> null);
            } else {
                DimMember dimMember = memberMappingRelationMap.get(memberVal);
                if (EmptyUtil.isEmpty((Object)dimMember)) {
                    return null;
                }
                returnVal = attr.equals("name") ? dimMember.getName() : dimMember.getNumber();
            }
        } else {
            String billNo = ((BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)billSign)).getBillNo();
            DynamicObject billDataDy = TmcDataServiceHelper.loadSingle((Object)memberVal, (String)billSign, (String)String.format("id,name,%s", billNo));
            if (null != billDataDy) {
                returnVal = attr.equals("name") ? billDataDy.getString("name") : billDataDy.getString(billNo);
            }
        }
        return returnVal;
    }

    private List<Map<String, Object>> createDataMap(Map<Long, DimMember> memberMappingRelationMap, Map<Long, String> dimIdMappingDimNumber, List<ReportDataQueryResult> datas, AccurateMatchScheme scheme) {
        ArrayList<Map<String, Object>> dataMaps = new ArrayList<Map<String, Object>>(datas.size());
        for (ReportDataQueryResult data : datas) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            dataMap.put("id", data.getId());
            for (AccurateMatchScheme.AccurateMatchSchemeEntry schemeEntry : scheme.getSchemeEntrys()) {
                String attr = schemeEntry.getAttr();
                String ourSideField = schemeEntry.getOurSideField();
                dataMap.put(ourSideField, this.getDimMemberVal(ourSideField, data, memberMappingRelationMap, dimIdMappingDimNumber, attr));
                String otherSideField = schemeEntry.getOtherSideField();
                dataMap.put(otherSideField, this.getDimMemberVal(otherSideField, data, memberMappingRelationMap, dimIdMappingDimNumber, attr));
            }
            dataMaps.add(dataMap);
        }
        return dataMaps;
    }

    private Tuple<Object, DetailDataType> getValByDimType(String dimTypeNumber, Map<Long, String> dimIdMappingDimNumber, ReportDataQueryResult queryResult) {
        List<TemplateDim> dimList = queryResult.getDimList();
        DetailDataType detailDataType = null;
        for (int i = 0; i < dimList.size(); ++i) {
            String curDimNumber = dimIdMappingDimNumber.get(dimList.get(i).getDimensionId());
            detailDataType = dimList.get(i).getDetailDataType();
            if (!Objects.equals(dimTypeNumber, curDimNumber)) continue;
            Object value = Optional.of(queryResult.getDimValList().get(i)).orElseGet(null);
            return Tuple.create((Object)value, (Object)detailDataType);
        }
        return null;
    }
}

