/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.interior.offset.service.datasource;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.MessageType;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryObject;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryService;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.generate.DimensionIndexTreeGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.IndexTreeGenerateStrategy;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.IndexTreeGenerateStrategyFactory;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancelRule;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancelRuleParam;
import kd.tmc.fpm.business.domain.model.sumplan.InnerRuleSubjectConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.ISumPlanRepository;
import kd.tmc.fpm.business.mvc.repository.dto.ReportNeedPropDTO;
import kd.tmc.fpm.business.service.interior.offset.model.AuxiliaryDataInfo;
import kd.tmc.fpm.business.service.interior.offset.model.InternalOffsetMessage;
import kd.tmc.fpm.business.service.interior.offset.model.InternalOffsetParam;
import kd.tmc.fpm.business.service.interior.offset.service.datasource.IInternalOffsetDataSource;
import kd.tmc.fpm.business.service.interior.offset.service.datasource.impl.AccurateMatchMode;
import kd.tmc.fpm.business.service.interior.offset.service.datasource.impl.InexactMatchMode;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class DataSourceHandler {
    private IReportDataQueryService queryService = new ReportDataQueryService();
    private ISumPlanRepository sumPlanRepository;
    private IDimensionRepository dimensionRepository;
    private IReportRepository reportRepository;
    private SumPlanRecord sumPlanRecord;
    private List<InnerCancelRule> offsetRules;
    private FundPlanSystem fundPlanSystem;
    private SumPlanParamConfig sumPlanParamConfig;
    private SumPlanParamConfigInfo sumPlanParamConfigInfo;
    private Long sumPlanId;
    private List<Long> periodMemberIdList;

    public DataSourceHandler(Long sumPlanId, ISumPlanRepository sumPlanRepository, IDimensionRepository dimensionRepository, IReportRepository reportRepository) {
        this.sumPlanRepository = sumPlanRepository;
        this.dimensionRepository = dimensionRepository;
        this.reportRepository = reportRepository;
        this.sumPlanId = sumPlanId;
    }

    public InternalOffsetMessage prepare() {
        this.sumPlanRecord = this.sumPlanRepository.loadSumPlanRecord(this.sumPlanId);
        if (EmptyUtil.isEmpty((Object)this.sumPlanRecord)) {
            return new InternalOffsetMessage(MessageType.Error, String.format(ResManager.loadKDString((String)"\u5f02\u5e38:\u67e5\u8be2\u4e0d\u5230id=%1$s\u7684\u6c47\u603b\u7f16\u62a5\u7684\u8bb0\u5f55\u4fe1\u606f.", (String)"DataSourceHandler_0", (String)"tmc-fpm-business", (Object[])new Object[0]), this.sumPlanId));
        }
        if (this.sumPlanRecord.getReportStatus() == ReportStatus.ENABLE) {
            return new InternalOffsetMessage(MessageType.Error, ResManager.loadKDString((String)"\u5df2\u751f\u6548\u7684\u6c47\u603b\u5355\u636e\uff0c\u4e0d\u80fd\u518d\u62b5\u6d88", (String)"DataSourceHandler_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        if (this.sumPlanRecord.getStatus() == BillStatus.AUDITED) {
            return new InternalOffsetMessage(MessageType.Error, ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u6c47\u603b\u5355\u636e\uff0c\u4e0d\u80fd\u518d\u62b5\u6d88", (String)"DataSourceHandler_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        this.fundPlanSystem = this.dimensionRepository.loadSystem(this.sumPlanRecord.getSystemId());
        InnerCancelRuleParam innerCancelRuleParam = InnerCancelRuleParam.builder().systemId(this.sumPlanRecord.getSystemId()).orgId(this.sumPlanRecord.getOrgId()).reportTypeId(this.sumPlanRecord.getReportPeriodTypeId()).build();
        this.offsetRules = this.sumPlanRepository.loadInCancelRule(innerCancelRuleParam);
        if (EmptyUtil.isEmpty(this.offsetRules)) {
            innerCancelRuleParam = InnerCancelRuleParam.builder().systemId(this.sumPlanRecord.getSystemId()).reportTypeId(this.sumPlanRecord.getReportPeriodTypeId()).build();
            this.offsetRules = this.sumPlanRepository.loadInCancelRule(innerCancelRuleParam);
            this.offsetRules = this.offsetRules.stream().filter(o -> o.getOrgIdList().isEmpty()).collect(Collectors.toList());
        }
        if (EmptyUtil.isEmpty(this.offsetRules)) {
            this.sumPlanRecord.setInnerCancel(false);
            this.sumPlanRepository.saveSumPlanRecord(this.sumPlanRecord);
            String orgName = this.fundPlanSystem.getDimList().stream().filter(o -> o.getDimType() == DimensionType.ORG).map(o -> o.getAllDimMemberList()).flatMap(Collection::stream).filter(o -> o.getId().compareTo(this.sumPlanRecord.getOrgId()) == 0).findFirst().map(o -> String.format("[%s:%s]", o.getNumber(), o.getName())).orElseGet(() -> "");
            String reportTypeStr = this.fundPlanSystem.getReportTypeList().stream().filter(o -> o.getReportPeriodId().compareTo(this.sumPlanRecord.getReportPeriodTypeId()) == 0).findFirst().map(o -> String.format("[%s:%s]", o.getNumber(), o.getName())).orElseGet(() -> "");
            String tipMsg = String.format(ResManager.loadKDString((String)"\u6c47\u603b\u5355\u636e\u3010%1$s\u3011\u65e0\u6cd5\u67e5\u627e\u5230\u5305\u542b\u7f16\u62a5\u4e3b\u4f53%2$s\u548c\u7f16\u62a5\u7c7b\u578b%3$s\u7684\u5185\u90e8\u62b5\u6d88\u89c4\u5219\u5355\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u540e\u518d\u6267\u884c\u5185\u90e8\u62b5\u6d88\u3002", (String)"DataSourceHandler_3", (String)"tmc-fpm-business", (Object[])new Object[0]), this.sumPlanRecord.getNumber(), orgName, reportTypeStr);
            return new InternalOffsetMessage(MessageType.Advise, tipMsg);
        }
        this.sumPlanParamConfig = this.sumPlanRepository.loadSumConfigBySystem(this.sumPlanRecord.getSystemId(), this.sumPlanRecord.getReportPeriodTypeId());
        if (Optional.ofNullable(this.sumPlanParamConfig).isPresent()) {
            this.sumPlanParamConfigInfo = this.sumPlanParamConfig.getConfigInfoList().stream().filter(Objects::nonNull).filter(o -> o.getOrgMemberId().compareTo(this.sumPlanRecord.getOrgId()) == 0).findAny().map(o -> o).orElseGet(() -> null);
        }
        this.getPeriodFilterRoll(this.sumPlanRecord);
        return null;
    }

    public List<InternalOffsetParam> getInternalOffsetParam() {
        ArrayList<InternalOffsetParam> internalOffsetParams = new ArrayList<InternalOffsetParam>(this.offsetRules.size());
        for (InnerCancelRule innerCancelRule : this.offsetRules) {
            Dimension currencyDimension = this.fundPlanSystem.getMainDimensionByDimType(DimensionType.CURRENCY);
            Set<DimMember> currencyDimMembers = currencyDimension.getMemberList().stream().filter(dimMember -> innerCancelRule.getApplyCurrencyList().contains(dimMember.getId())).collect(Collectors.toSet());
            if (EmptyUtil.isEmpty(currencyDimMembers)) {
                currencyDimMembers = currencyDimension.getMemberList().stream().collect(Collectors.toSet());
            }
            Dimension periodDimension = this.fundPlanSystem.getMainDimensionByDimType(DimensionType.PERIOD);
            Set periodMemberIds = periodDimension.getAllDimMemberList().stream().filter(item -> this.periodMemberIdList.contains(item.getId())).map(item -> item.getAllChildMember()).flatMap(Collection::stream).map(DimMember::getId).collect(Collectors.toSet());
            periodMemberIds.addAll(this.sumPlanRecord.getPeriodMemberIdList());
            Set<DimMember> periodDimMembers = periodDimension.getAllDimMemberList().stream().map(item -> item.getAllChildMember()).flatMap(Collection::stream).filter(o -> periodMemberIds.contains(o.getId())).map(o -> o).collect(Collectors.toSet());
            List<DimMember> optionalDimMembers = this.fundPlanSystem.getDimList().stream().filter(Objects::nonNull).map(o -> o.getAllDimMemberList()).flatMap(Collection::stream).filter(Objects::nonNull).filter(o -> innerCancelRule.getAllOptionalDimIds().contains(o.getId())).collect(Collectors.toList());
            ReportDataQueryObject queryObjectCondi = this.generateQueryCondi(innerCancelRule, currencyDimMembers, periodDimMembers);
            List<ReportDataQueryResult> reportDataQueryResults = this.queryService.queryReportData(queryObjectCondi);
            Map<InternalOffsetParam, List<ReportDataQueryResult>> iopMap = this.buildInternalOffsetParam(reportDataQueryResults, innerCancelRule, currencyDimMembers, periodDimMembers, optionalDimMembers);
            for (Map.Entry<InternalOffsetParam, List<ReportDataQueryResult>> iopEntry : iopMap.entrySet()) {
                InternalOffsetParam internalOffsetParam = iopEntry.getKey();
                List<ReportDataQueryResult> entryQueryResults = iopEntry.getValue();
                IInternalOffsetDataSource matchMode = new AccurateMatchMode(this.reportRepository);
                boolean accurateMatchMode = internalOffsetParam.getAuxiliaryData().getSubjectConfig().isAccurateMatchMode();
                if (!accurateMatchMode) {
                    matchMode = new InexactMatchMode(matchMode);
                }
                entryQueryResults = entryQueryResults.stream().filter(o -> o.getPlanAmt().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
                entryQueryResults = matchMode.dataFilter(internalOffsetParam, entryQueryResults);
                matchMode.dataGroup(internalOffsetParam, entryQueryResults);
                internalOffsetParams.add(internalOffsetParam);
            }
        }
        return internalOffsetParams;
    }

    private Map<InternalOffsetParam, List<ReportDataQueryResult>> buildInternalOffsetParam(List<ReportDataQueryResult> reportDataQueryResults, InnerCancelRule innerCancelRule, Set<DimMember> currencyDimMembers, Set<DimMember> periodDimMembers, List<DimMember> optionalDimMembers) {
        DimensionIndexTree indexTree = this.getIndexTree(reportDataQueryResults);
        List<InnerRuleSubjectConfig> subjectConfigList = innerCancelRule.getSubjectConfigList();
        Dimension currencyDimension = this.fundPlanSystem.getMainDimensionByDimType(DimensionType.CURRENCY);
        Dimension periodDimension = this.fundPlanSystem.getMainDimensionByDimType(DimensionType.PERIOD);
        Dimension subjectDimession = this.fundPlanSystem.getMainDimensionByDimType(DimensionType.SUBJECTS);
        HashMap<InternalOffsetParam, List<ReportDataQueryResult>> dataMap = new HashMap<InternalOffsetParam, List<ReportDataQueryResult>>(16);
        for (InnerRuleSubjectConfig subjectConfig : subjectConfigList) {
            for (DimMember currencyDimMember : currencyDimMembers) {
                for (DimMember periodDimMember : periodDimMembers) {
                    HashSet subjectIds = new HashSet(10);
                    subjectIds.addAll(subjectConfig.getInSubjectOrderList().stream().map(InnerRuleSubjectConfig.SubjectOrder::getSubjectId).collect(Collectors.toSet()));
                    subjectIds.addAll(subjectConfig.getOutSubjectOrderList().stream().map(InnerRuleSubjectConfig.SubjectOrder::getSubjectId).collect(Collectors.toSet()));
                    ArrayList queryResults = new ArrayList(10);
                    for (Long subjectId : subjectIds) {
                        List datas;
                        List<Object> dataList;
                        ArrayList<Long> dimIdLst = new ArrayList<Long>(3);
                        ArrayList<Long> dimMemIdLst = new ArrayList<Long>(3);
                        dimIdLst.add(currencyDimension.getId());
                        dimMemIdLst.add(currencyDimMember.getId());
                        dimIdLst.add(periodDimension.getId());
                        dimMemIdLst.add(periodDimMember.getId());
                        dimIdLst.add(subjectDimession.getId());
                        dimMemIdLst.add(subjectId);
                        DimensionInfoBean dimensionInfoBean = new DimensionInfoBean();
                        dimensionInfoBean.setDimensionIdList(dimIdLst);
                        dimensionInfoBean.setMemberIdList(dimMemIdLst);
                        TreeNode treeNode = indexTree.find(dimensionInfoBean);
                        if (!EmptyUtil.isNoEmpty((Object)treeNode) || !EmptyUtil.isNoEmpty(dataList = treeNode.getDataList()) || !EmptyUtil.isNoEmpty(datas = dataList.stream().filter(o -> o instanceof ReportDataQueryResult).map(o -> (ReportDataQueryResult)o).collect(Collectors.toList()))) continue;
                        queryResults.addAll(datas);
                    }
                    InternalOffsetParam internalOffsetParam = new InternalOffsetParam();
                    internalOffsetParam.setPlanSystem(this.fundPlanSystem);
                    internalOffsetParam.setInnerCancelRule(innerCancelRule);
                    internalOffsetParam.setSumPlanRecord(this.sumPlanRecord);
                    internalOffsetParam.setSumPlanParamConfig(this.sumPlanParamConfig);
                    internalOffsetParam.setSumPlanParamConfigInfo(this.sumPlanParamConfigInfo);
                    AuxiliaryDataInfo auxiliaryData = new AuxiliaryDataInfo.AuxiliaryDataInfoBuilder().setPeriodDimMember(periodDimMember).setSubjectConfig(subjectConfig).setCurrencyDimMember(currencyDimMember).setOptionalDimMembers(optionalDimMembers).builder();
                    internalOffsetParam.setAuxiliaryData(auxiliaryData);
                    dataMap.put(internalOffsetParam, queryResults);
                }
            }
        }
        return dataMap;
    }

    public SumPlanRecord getSumPlanRecord() {
        return this.sumPlanRecord;
    }

    private ReportDataQueryObject generateQueryCondi(InnerCancelRule innerCancelRule, Set<DimMember> currencyDimMembers, Set<DimMember> periodDimMembers) {
        List<InnerRuleSubjectConfig> subjectConfigList = innerCancelRule.getSubjectConfigList();
        List<Long> otherOptionalDimList = innerCancelRule.getAllOptionalDimIds();
        List<Long> orgIds = new ArrayList<Long>(10);
        this.recursiveGetOrgIds(this.sumPlanParamConfigInfo, orgIds);
        List<Long> applyOrgLeafIds = this.getApplyOrgLeafOrgIds(this.sumPlanParamConfig, innerCancelRule.getOrgIdList());
        if (applyOrgLeafIds != null && !applyOrgLeafIds.isEmpty()) {
            orgIds = orgIds.stream().filter(Objects::nonNull).filter(applyOrgLeafIds::contains).collect(Collectors.toList());
        }
        Dimension currencyDimension = this.fundPlanSystem.getMainDimensionByDimType(DimensionType.CURRENCY);
        Dimension periodDimension = this.fundPlanSystem.getMainDimensionByDimType(DimensionType.PERIOD);
        Dimension subjectDimession = this.fundPlanSystem.getMainDimensionByDimType(DimensionType.SUBJECTS);
        ReportDataQueryObject queryObject = new ReportDataQueryObject();
        HashMap dimRelationInfo = new HashMap(16);
        for (DimMember currencyDimMember : currencyDimMembers) {
            for (DimMember dimMember : periodDimMembers) {
                for (InnerRuleSubjectConfig subjectConfig : subjectConfigList) {
                    HashSet<Long> currencyIds = (HashSet<Long>)dimRelationInfo.get(currencyDimension.getId());
                    if (currencyIds == null) {
                        currencyIds = new HashSet<Long>(3);
                    }
                    currencyIds.add(currencyDimMember.getId());
                    dimRelationInfo.put(currencyDimension.getId(), currencyIds);
                    HashSet<Long> periodIds = (HashSet<Long>)dimRelationInfo.get(periodDimension.getId());
                    if (periodIds == null) {
                        periodIds = new HashSet<Long>(3);
                    }
                    periodIds.add(dimMember.getId());
                    dimRelationInfo.put(periodDimension.getId(), periodIds);
                    HashSet subjectIds = (HashSet)dimRelationInfo.get(subjectDimession.getId());
                    if (subjectIds == null) {
                        subjectIds = new HashSet(3);
                    }
                    Set inSubAcctId = subjectConfig.getInSubjectOrderList().stream().map(InnerRuleSubjectConfig.SubjectOrder::getSubjectId).collect(Collectors.toSet());
                    Set outSubAcctId = subjectConfig.getOutSubjectOrderList().stream().map(InnerRuleSubjectConfig.SubjectOrder::getSubjectId).collect(Collectors.toSet());
                    if (EmptyUtil.isNoEmpty(inSubAcctId)) {
                        subjectIds.addAll(inSubAcctId);
                    }
                    if (EmptyUtil.isNoEmpty(outSubAcctId)) {
                        subjectIds.addAll(outSubAcctId);
                    }
                    dimRelationInfo.put(subjectDimession.getId(), subjectIds);
                    for (Dimension dimension : this.fundPlanSystem.getDimList()) {
                        List<Long> dimMemberIds = dimension.getDimMemberIds();
                        if (Collections.disjoint(dimMemberIds, otherOptionalDimList)) continue;
                        List intersectionIds = dimMemberIds.stream().distinct().filter(otherOptionalDimList::contains).collect(Collectors.toList());
                        HashSet dimMemberIdLst = (HashSet)dimRelationInfo.get(dimension.getId());
                        if (dimMemberIdLst == null) {
                            dimMemberIdLst = new HashSet(3);
                        }
                        dimMemberIdLst.addAll(intersectionIds);
                        dimRelationInfo.put(dimension.getId(), dimMemberIdLst);
                    }
                }
            }
        }
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>(dimRelationInfo.size());
        ArrayList<List<Object>> dimValLst = new ArrayList<List<Object>>(dimRelationInfo.size());
        Map<Long, Dimension> dimMap = this.fundPlanSystem.getMainDimList().stream().collect(Collectors.toMap(o -> o.getId(), o -> o));
        for (Map.Entry entry : dimRelationInfo.entrySet()) {
            Long dimmensionId = (Long)entry.getKey();
            Dimension dimension = dimMap.get(dimmensionId);
            dimensions.add(dimension);
            dimValLst.add(new ArrayList((Collection)entry.getValue()));
        }
        queryObject.setDimIdList(dimensions);
        queryObject.setDimValList(dimValLst);
        queryObject.setReportPlanType(ReportPlanType.REPORTPLAN);
        ArrayList<ReportStatus> arrayList = new ArrayList<ReportStatus>(2);
        arrayList.add(ReportStatus.ENABLE);
        arrayList.add(ReportStatus.REPORTING);
        queryObject.setReportStatuss(arrayList);
        queryObject.setReportOrgIds(orgIds);
        return queryObject;
    }

    private void getPeriodFilterRoll(SumPlanRecord sumPlanRecord) {
        Report sumPlanReport;
        this.periodMemberIdList = sumPlanRecord.getPeriodMemberIdList();
        List<Report> sumPlanReportList = new ArrayList<SumPlanReport>(sumPlanRecord.getSumPlanReportList());
        List<Long> sumPlanReportIdList = sumPlanRecord.getOriginalReportIdList();
        if (EmptyUtil.isEmpty(sumPlanReportList) && EmptyUtil.isNoEmpty(sumPlanReportIdList)) {
            ReportNeedPropDTO reportNeedPropDTO = new ReportNeedPropDTO();
            reportNeedPropDTO.setNeedTemplate(true);
            reportNeedPropDTO.setNeedPeriodMember(true);
            reportNeedPropDTO.setNeedReportPeriodType(true);
            sumPlanReportList = this.reportRepository.loadSimpleReport(new HashSet<Long>(sumPlanReportIdList), reportNeedPropDTO);
        }
        if (EmptyUtil.isNoEmpty(sumPlanReportList) && !(sumPlanReport = (Report)sumPlanReportList.get(0)).isRollContainsDetail() && EmptyUtil.isNoEmpty(this.periodMemberIdList)) {
            this.periodMemberIdList = Collections.singletonList(this.periodMemberIdList.get(0));
        }
    }

    public void recursiveGetOrgIds(SumPlanParamConfigInfo sumPlanParamConfigInfo, List<Long> orgIds) {
        List<SumPlanParamConfigInfo> childs;
        if (!sumPlanParamConfigInfo.isSumAuditNode()) {
            orgIds.add(sumPlanParamConfigInfo.getOrgMemberId());
        }
        if (EmptyUtil.isNoEmpty(childs = sumPlanParamConfigInfo.getChildren())) {
            for (SumPlanParamConfigInfo child : childs) {
                this.recursiveGetOrgIds(child, orgIds);
            }
        }
    }

    private List<Long> getApplyOrgLeafOrgIds(SumPlanParamConfig sumPlanParamConfig, List<Long> orgIdList) {
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        List<SumPlanParamConfigInfo> configs = sumPlanParamConfig.getConfigInfoList();
        for (SumPlanParamConfigInfo config : configs) {
            Set needIds;
            boolean isContain;
            if (!config.isSumAuditNode() || !(isContain = orgIdList.contains(config.getOrgMemberId())) || !EmptyUtil.isNoEmpty(needIds = config.getAllChildren().stream().filter(Objects::nonNull).filter(o -> !o.isSumAuditNode()).map(SumPlanParamConfigInfo::getOrgMemberId).collect(Collectors.toSet()))) continue;
            orgIds.addAll(needIds);
        }
        return orgIds;
    }

    public Map<Long, InnerCancelRule> getOffsetRuleRelationMap() {
        return this.offsetRules.stream().filter(Objects::nonNull).collect(Collectors.toMap(o -> o.getId(), o -> o));
    }

    private DimensionIndexTree getIndexTree(List<ReportDataQueryResult> queryResults) {
        IndexTreeGenerateStrategy strategy = IndexTreeGenerateStrategyFactory.createInternalOffsetIndexTreeStrategy(this.fundPlanSystem);
        DimensionIndexTreeGenerator generator = new DimensionIndexTreeGenerator(strategy);
        DimensionIndexTree indexTree = generator.build();
        for (ReportDataQueryResult queryResult : queryResults) {
            ArrayList<Long> dimIdLst = new ArrayList<Long>(3);
            ArrayList<Object> dimMemIdLst = new ArrayList<Object>(3);
            List<Object> dimValList = queryResult.getDimValList();
            List<TemplateDim> dimList = queryResult.getDimList();
            for (int inx = 0; inx < dimList.size(); ++inx) {
                TemplateDim templateDim = dimList.get(inx);
                if (templateDim.getDimType() != DimensionType.CURRENCY && templateDim.getDimType() != DimensionType.SUBJECTS && templateDim.getDimType() != DimensionType.PERIOD) continue;
                dimIdLst.add(templateDim.getDimensionId());
                dimMemIdLst.add(dimValList.get(inx));
            }
            DimensionInfoBean dimensionInfoBean = new DimensionInfoBean();
            dimensionInfoBean.setDimensionIdList(dimIdLst);
            dimensionInfoBean.setMemberIdList(dimMemIdLst);
            TreeNode treeNode = indexTree.find(dimensionInfoBean);
            if (treeNode == null) continue;
            treeNode.addData(queryResult);
        }
        return indexTree;
    }
}

