/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.interior.offset.service.datasource.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.compare.CompareEngine;
import kd.tmc.fbp.common.compare.data.CompareRule;
import kd.tmc.fbp.common.compare.data.CompareRuleGroup;
import kd.tmc.fbp.common.compare.result.CompareResult;
import kd.tmc.fbp.common.compare.strategy.ICompareStrategy;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.sumplan.AccurateMatchScheme;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.service.interior.offset.model.InternalOffsetGroupData;
import kd.tmc.fpm.business.service.interior.offset.model.InternalOffsetParam;
import kd.tmc.fpm.business.service.interior.offset.service.compare.provider.impl.InternalOffsetCompareDataProvider;
import kd.tmc.fpm.business.service.interior.offset.service.compare.strategy.InternalOffsetCompareStrategy;
import kd.tmc.fpm.business.service.interior.offset.service.datasource.IInternalOffsetDataSource;

public class AccurateMatchMode
implements IInternalOffsetDataSource {
    private IReportRepository reportRepository;

    public AccurateMatchMode(IReportRepository reportRepository) {
        this.reportRepository = reportRepository;
    }

    @Override
    public List<ReportDataQueryResult> dataFilter(InternalOffsetParam internalOffsetParam, List<ReportDataQueryResult> reportDataQueryResults) {
        reportDataQueryResults = reportDataQueryResults.stream().filter(Objects::nonNull).filter(result -> result.getReportPeriodId().compareTo(internalOffsetParam.getSumPlanRecord().getReportPeriodId()) == 0).collect(Collectors.toList());
        if (internalOffsetParam.getAuxiliaryData().getSubjectConfig().isAccurateMatchMode()) {
            Set dimNumbers = internalOffsetParam.getAuxiliaryData().getSubjectConfig().getScheme().getSchemeEntrys().stream().map(o -> {
                ArrayList<String> attrs = new ArrayList<String>(2);
                attrs.add(o.getOurSideField());
                attrs.add(o.getOtherSideField());
                return attrs;
            }).flatMap(Collection::stream).collect(Collectors.toSet());
            Set detailDimNumbers = Arrays.stream(DetailDimType.values()).map(o -> o.getNumber()).collect(Collectors.toSet());
            dimNumbers.retainAll(detailDimNumbers);
            if (dimNumbers.size() > 0) {
                reportDataQueryResults = reportDataQueryResults.stream().filter(o -> o.getDimList().stream().filter(dim -> EmptyUtil.isNoEmpty((Object)((Object)dim.getDetailDimType()))).findAny().isPresent()).collect(Collectors.toList());
            }
        }
        List<ReportDataQueryResult> mainTableResults = reportDataQueryResults.stream().filter(ReportDataQueryResult::isMainTable).collect(Collectors.toList());
        Set mainTableIds = mainTableResults.stream().map(ReportDataQueryResult::getReportId).collect(Collectors.toSet());
        Set<String> keys = this.getUniqueKey(mainTableResults);
        HashMap<Long, Long> sonIdsMapRelation = new HashMap<Long, Long>(16);
        for (Long mainTableId : mainTableIds) {
            List<Long> sonTableIds = this.reportRepository.querySubReportId(mainTableId);
            for (Long sonTableId : sonTableIds) {
                sonIdsMapRelation.put(sonTableId, mainTableId);
            }
        }
        ArrayList<ReportDataQueryResult> waitRemoveResults = new ArrayList<ReportDataQueryResult>(10);
        for (ReportDataQueryResult reportDataQueryResult : reportDataQueryResults) {
            Long subjectDimId;
            Long mainTableId;
            String uniqueKey;
            Long reportId;
            if (reportDataQueryResult.isMainTable() || !sonIdsMapRelation.containsKey(reportId = reportDataQueryResult.getReportId()) || !keys.contains(uniqueKey = String.format("%s.%s", mainTableId = (Long)sonIdsMapRelation.get(reportId), subjectDimId = this.getAppointDimVal(DimensionType.SUBJECTS, reportDataQueryResult)))) continue;
            waitRemoveResults.add(reportDataQueryResult);
        }
        reportDataQueryResults.removeAll(waitRemoveResults);
        return reportDataQueryResults;
    }

    @Override
    public void dataGroup(InternalOffsetParam internalOffsetParam, List<ReportDataQueryResult> reportDataQueryResults) {
        String validateMsg = this.validate(internalOffsetParam, reportDataQueryResults);
        ArrayList<InternalOffsetGroupData> groupDatas = new ArrayList<InternalOffsetGroupData>(5);
        internalOffsetParam.setGroupDatas(groupDatas);
        if (EmptyUtil.isNoEmpty((String)validateMsg)) {
            InternalOffsetGroupData groupData = new InternalOffsetGroupData();
            groupData.setSuccess(false);
            groupData.setErrMsg(validateMsg);
            groupDatas.add(groupData);
            return;
        }
        AccurateMatchScheme scheme = internalOffsetParam.getAuxiliaryData().getSubjectConfig().getScheme();
        Set inflowSubjectIds = internalOffsetParam.getAuxiliaryData().getSubjectConfig().getInSubjectOrderList().stream().filter(Objects::nonNull).map(o -> o.getSubjectId()).collect(Collectors.toSet());
        List<ReportDataQueryResult> inflowReportDatas = reportDataQueryResults.stream().filter(Objects::nonNull).filter(o -> inflowSubjectIds.contains(this.getAppointDimVal(DimensionType.SUBJECTS, (ReportDataQueryResult)o))).collect(Collectors.toList());
        Set outflowSubjectIds = internalOffsetParam.getAuxiliaryData().getSubjectConfig().getOutSubjectOrderList().stream().filter(Objects::nonNull).map(o -> o.getSubjectId()).collect(Collectors.toSet());
        List<ReportDataQueryResult> outflowReportDatas = reportDataQueryResults.stream().filter(Objects::nonNull).filter(o -> outflowSubjectIds.contains(this.getAppointDimVal(DimensionType.SUBJECTS, (ReportDataQueryResult)o))).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(inflowReportDatas) || EmptyUtil.isEmpty(outflowReportDatas)) {
            return;
        }
        InternalOffsetCompareDataProvider dataProvider = new InternalOffsetCompareDataProvider(internalOffsetParam.getPlanSystem(), scheme);
        List<Map<String, Object>> inflowDataMaps = dataProvider.buildCompareDataMap(inflowReportDatas);
        List<Map<String, Object>> outflowDataMaps = dataProvider.buildCompareDataMap(outflowReportDatas);
        List<List<CompareRule>> rules = dataProvider.getRule(scheme);
        if (EmptyUtil.isEmpty(rules)) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u7b26\u5408\u8981\u6c42\u7684\u5339\u914d\u89c4\u5219", (String)"AccurateMatchMode_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        List<CompareRuleGroup> ruleGroups = rules.stream().filter(Objects::nonNull).map(CompareRuleGroup::new).collect(Collectors.toList());
        InternalOffsetCompareStrategy strategy = new InternalOffsetCompareStrategy(ruleGroups);
        CompareEngine compareEngine = new CompareEngine(outflowDataMaps, inflowDataMaps);
        List compareResults = compareEngine.compare((ICompareStrategy)strategy);
        int digit = Integer.toString(compareResults.size()).length();
        StringBuilder sb = new StringBuilder("%0");
        sb.append(digit > 3 ? digit : 3);
        sb.append("d");
        for (int i = 0; i < compareResults.size(); ++i) {
            CompareResult compareResult = (CompareResult)compareResults.get(i);
            HashSet matchIds = new HashSet(5);
            if (EmptyUtil.isNoEmpty((Object)compareResult.getSrcIdSet())) {
                matchIds.addAll(compareResult.getSrcIdSet());
            }
            if (EmptyUtil.isNoEmpty((Object)compareResult.getTarIdSet())) {
                matchIds.addAll(compareResult.getTarIdSet());
            }
            List<ReportDataQueryResult> groupDataResult = reportDataQueryResults.stream().filter(Objects::nonNull).filter(o -> matchIds.contains(o.getId())).collect(Collectors.toList());
            InternalOffsetGroupData groupData = new InternalOffsetGroupData();
            groupData.setGroupKey(this.generateGroupKey(String.format(sb.toString(), i)));
            groupData.setDataResult(groupDataResult);
            groupData.setSuccess(true);
            groupDatas.add(groupData);
        }
    }

    protected Long getAppointDimVal(DimensionType dimType, ReportDataQueryResult queryResult) {
        Long memberId = null;
        List<TemplateDim> dimList = queryResult.getDimList();
        for (int i = 0; i < dimList.size(); ++i) {
            if (dimType != dimList.get(i).getDimType()) continue;
            memberId = Optional.of(queryResult.getDimValList().get(i)).map(o -> Long.valueOf(o.toString())).orElseGet(() -> null);
        }
        return memberId;
    }

    private Set<String> getUniqueKey(List<ReportDataQueryResult> mainTableResults) {
        HashSet<String> keys = new HashSet<String>(mainTableResults.size());
        for (ReportDataQueryResult mainTableResult : mainTableResults) {
            Long reportId = mainTableResult.getReportId();
            Long subjectId = this.getAppointDimVal(DimensionType.SUBJECTS, mainTableResult);
            keys.add(String.format("%s.%s", reportId, ((Object)subjectId).toString()));
        }
        return keys;
    }
}

