/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.interior.offset.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DiffProcessModeType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.sumplan.AccurateMatchScheme;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancelDetail;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancelRecord;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancelRule;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancleTotal;
import kd.tmc.fpm.business.domain.model.sumplan.InnerRuleSubjectConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.service.interior.offset.model.AuxiliaryDataInfo;
import kd.tmc.fpm.business.service.interior.offset.model.InternalOffsetDetailModel;
import kd.tmc.fpm.business.service.interior.offset.model.InternalOffsetGroupData;
import kd.tmc.fpm.business.service.interior.offset.model.InternalOffsetParam;
import kd.tmc.fpm.business.service.interior.offset.model.OptionalDimSetValInfo;
import kd.tmc.fpm.business.service.interior.offset.service.IInternalOffset;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.utils.AmountUtil;
import kd.tmc.fpm.common.utils.DateTimeUtil;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbsInternalOffsetStrategy
implements IInternalOffset {
    protected InnerCancelRecord innerCancelRecord;
    protected InternalOffsetParam internalOffsetParam;

    public AbsInternalOffsetStrategy(InternalOffsetParam internalOffsetParam) {
        this.internalOffsetParam = internalOffsetParam;
        this.initInnerCancleRecord();
    }

    private void initInnerCancleRecord() {
        InnerCancelRule innerCancelRule = this.internalOffsetParam.getInnerCancelRule();
        SumPlanRecord sumPlanRecord = this.internalOffsetParam.getSumPlanRecord();
        SumPlanParamConfigInfo sumPlanParamConfigInfo = this.internalOffsetParam.getSumPlanParamConfigInfo();
        AuxiliaryDataInfo auxiliaryData = this.internalOffsetParam.getAuxiliaryData();
        InnerRuleSubjectConfig subjectConfig = auxiliaryData.getSubjectConfig();
        this.innerCancelRecord = new InnerCancelRecord();
        this.innerCancelRecord.setCancelRuleId(innerCancelRule.getId());
        this.innerCancelRecord.setCancelRuleEntryId(subjectConfig.getId());
        this.innerCancelRecord.setCancelRuleEntryName(subjectConfig.getName());
        this.innerCancelRecord.setSumPlanRecordId(sumPlanRecord.getId());
        this.innerCancelRecord.setSystemId(sumPlanRecord.getSystemId());
        this.innerCancelRecord.setSumPlanSumType(sumPlanRecord.getSumPlanSumType());
        this.innerCancelRecord.setOrgId(sumPlanRecord.getOrgId());
        this.innerCancelRecord.setOrgReportTypeId(sumPlanRecord.getReportPeriodTypeId());
        this.innerCancelRecord.setOrgReportPeriod(sumPlanRecord.getReportPeriod());
        this.innerCancelRecord.setCurrencyMap(null == sumPlanParamConfigInfo ? null : Optional.ofNullable(sumPlanParamConfigInfo.getCurrencyMapCase()).map(o -> o.getName()).orElseGet(() -> null));
        this.innerCancelRecord.setExchangeRateTableId(sumPlanRecord.getExchangeRateTableId());
        this.innerCancelRecord.setRateDate(sumPlanRecord.getRateDate());
        this.innerCancelRecord.setAmountUnit(sumPlanRecord.getAmountUnit());
        List<Long> inflowSubject = subjectConfig.getInSubjectOrderList().stream().map(InnerRuleSubjectConfig.SubjectOrder::getSubjectId).collect(Collectors.toList());
        this.innerCancelRecord.setInflowSubject(inflowSubject);
        List<Long> outflowSubject = subjectConfig.getOutSubjectOrderList().stream().map(InnerRuleSubjectConfig.SubjectOrder::getSubjectId).collect(Collectors.toList());
        this.innerCancelRecord.setOutflowSubject(outflowSubject);
        this.innerCancelRecord.setCurrencyId(auxiliaryData.getCurrencyDimMember().getId());
        this.innerCancelRecord.setCurrency(auxiliaryData.getCurrencyId());
        List<Long> otherOptionalDimList = innerCancelRule.getOtherOptionalDimList();
        this.innerCancelRecord.setOtherOptionalDimList(otherOptionalDimList);
        List<Long> otherOptionalDim1List = innerCancelRule.getOtherOptionalDim1List();
        this.innerCancelRecord.setOtherOptionalDim1List(otherOptionalDim1List);
        List<Long> otherOptionalDim2List = innerCancelRule.getOtherOptionalDim2List();
        this.innerCancelRecord.setOtherOptionalDim2List(otherOptionalDim2List);
        this.innerCancelRecord.setCancelDetailList(new ArrayList<InnerCancelDetail>(0));
        this.innerCancelRecord.setDiffProcessModeType(auxiliaryData.getSubjectConfig().getDiffProcessMode());
        this.innerCancelRecord.setCancelPeriod(auxiliaryData.getPeriodDimMember().getId());
        Long currUser = RequestContext.get().getCurrUserId();
        this.innerCancelRecord.setCreator(currUser);
        this.innerCancelRecord.setModifier(currUser);
        Date date = new Date(System.currentTimeMillis());
        this.innerCancelRecord.setCreateTime(date);
        this.innerCancelRecord.setModifyTime(date);
        if (sumPlanRecord.getStatus() == BillStatus.STAGE) {
            this.innerCancelRecord.setBillStatus(BillStatus.STAGE.getNumber());
        } else if (sumPlanRecord.getStatus() == BillStatus.COMMITTED || sumPlanRecord.getStatus() == BillStatus.AUDITED) {
            this.innerCancelRecord.setBillStatus(BillStatus.AUDITED.getNumber());
        }
    }

    protected InnerCancelDetail builderInnerCancelDetail(ReportDataQueryResult queryResult, Long subjectId, BigDecimal offsetAmt, String groupKey, AuxiliaryDataInfo auxiliaryData, Map<Long, Pair<Integer, OptionalDimSetValInfo>> relationMap) {
        OptionalDimSetValInfo.clearUpdateMark(relationMap);
        InnerCancelDetail innerCancelDetail = new InnerCancelDetail();
        innerCancelDetail.setSubjectId(subjectId);
        List<TemplateDim> dimList = queryResult.getDimList();
        int index = dimList.stream().map(TemplateDim::getDimType).collect(Collectors.toList()).indexOf((Object)DimensionType.ORG);
        Long orgId = Optional.ofNullable(queryResult.getDimValList().get(index)).map(o -> Long.valueOf(o.toString())).orElseGet(() -> 0L);
        innerCancelDetail.setOrgId(orgId);
        BigDecimal avCancelAmt = this.transferAmt().apply(queryResult.getAmountUnit(), queryResult.getOriginalPlanAmt());
        innerCancelDetail.setAvCancelAmt(avCancelAmt);
        innerCancelDetail.setCancelAmt(offsetAmt);
        innerCancelDetail.setBalanceAmt(innerCancelDetail.getAvCancelAmt().subtract(innerCancelDetail.getCancelAmt()));
        innerCancelDetail.setReportId(queryResult.getReportId());
        innerCancelDetail.setReportDataId(queryResult.getId());
        for (int inx = 0; inx < dimList.size(); ++inx) {
            Object dimMappingInfo;
            TemplateDim templateDim = dimList.get(inx);
            DimensionType dimType = templateDim.getDimType();
            if (dimType != DimensionType.SETTLEMENT_TYPE && dimType != DimensionType.COMPANY && dimType != DimensionType.CUSTOM) continue;
            Pair dimMappingPair = relationMap.get(templateDim.getDimensionId());
            if (EmptyUtil.isEmpty(dimMappingPair)) {
                int methodIndex;
                OptionalInt methodIndexOpt = relationMap.values().stream().mapToInt(pair -> (Integer)pair.getKey()).max();
                int n = methodIndex = methodIndexOpt.isPresent() ? methodIndexOpt.getAsInt() + 1 : 0;
                String methodName = methodIndex == 0 ? "setOtherDimId" : (methodIndex == 1 ? "setOtherDimId1" : "setOtherDimId2");
                dimMappingInfo = new OptionalDimSetValInfo(methodName);
                dimMappingPair = Pair.of((Object)methodIndex, (Object)dimMappingInfo);
            }
            dimMappingInfo = (OptionalDimSetValInfo)dimMappingPair.getValue();
            ((OptionalDimSetValInfo)dimMappingInfo).setIndex(inx);
            ((OptionalDimSetValInfo)dimMappingInfo).setUpdate(Boolean.TRUE);
            relationMap.put(templateDim.getDimensionId(), dimMappingPair);
        }
        for (Map.Entry<Long, Pair<Integer, OptionalDimSetValInfo>> relationEntry : relationMap.entrySet()) {
            OptionalDimSetValInfo mappingInfo = (OptionalDimSetValInfo)relationEntry.getValue().getValue();
            Long dimId = Optional.ofNullable(queryResult.getDimValList().get(mappingInfo.getIndex())).map(o -> Long.valueOf(o.toString())).orElse(0L);
            if (!mappingInfo.getUpdate().booleanValue()) continue;
            switch (mappingInfo.getMethodName()) {
                case "setOtherDimId": {
                    innerCancelDetail.setOtherDimId(dimId);
                    break;
                }
                case "setOtherDimId1": {
                    innerCancelDetail.setOtherDimId1(dimId);
                    break;
                }
                case "setOtherDimId2": {
                    innerCancelDetail.setOtherDimId2(dimId);
                }
            }
        }
        if (auxiliaryData.getSubjectConfig().isAccurateMatchMode()) {
            List<AccurateMatchScheme.AccurateMatchSchemeEntry> schemeEntrys = auxiliaryData.getSubjectConfig().getScheme().getSchemeEntrys();
            Optional<AccurateMatchScheme.AccurateMatchSchemeEntry> first = schemeEntrys.stream().filter(Objects::nonNull).filter(o -> o.isCorrespondenceOrg()).findFirst();
            if (first.isPresent()) {
                AccurateMatchScheme.AccurateMatchSchemeEntry schemeEntry = first.get();
                String ourSideField = schemeEntry.getOurSideField();
                Object outSideDimVal = this.getAppointDimVal(ourSideField, queryResult);
                innerCancelDetail.setOurSideOrg(Objects.nonNull(outSideDimVal) ? Long.valueOf(outSideDimVal.toString()) : null);
                String otherSideField = schemeEntry.getOtherSideField();
                Object otherSideDimVal = this.getAppointDimVal(otherSideField, queryResult);
                innerCancelDetail.setCorrespondenceOrgName(this.getDimValDisplayName(otherSideField, otherSideDimVal, queryResult));
            }
        } else {
            innerCancelDetail.setOurSideOrg(innerCancelDetail.getOrgId());
        }
        innerCancelDetail.setOffsetBatchNumber(groupKey);
        return innerCancelDetail;
    }

    protected InnerCancleTotal buildInnerCancleTotal(InternalOffsetGroupData groupData, InternalOffsetDetailModel detailModel, DiffProcessModeType diffProcessModeType) {
        InnerCancleTotal innerCancleTotal = new InnerCancleTotal();
        innerCancleTotal.setOffsetBatchNumber(groupData.getGroupKey());
        innerCancleTotal.setOffsetNumber(groupData.getDataResult().size());
        innerCancleTotal.setDiffDirection(detailModel.getDiffDirection());
        innerCancleTotal.setSumDiffAmount(detailModel.getSumDiffAmt(diffProcessModeType));
        innerCancleTotal.setSumCancelAmount(detailModel.getSumCancelAmt(diffProcessModeType));
        return innerCancleTotal;
    }

    protected Long getAppointDimVal(DimensionType dimType, ReportDataQueryResult queryResult) {
        Long memberId = null;
        List<TemplateDim> dimList = queryResult.getDimList();
        for (int i = 0; i < dimList.size(); ++i) {
            if (dimType != dimList.get(i).getDimType()) continue;
            memberId = Optional.of(queryResult.getDimValList().get(i)).map(o -> Long.valueOf(o.toString())).orElseGet(() -> null);
        }
        return memberId;
    }

    protected Object getAppointDimVal(String dimNumber, ReportDataQueryResult queryResult) {
        FundPlanSystem fundPlanSystem = this.internalOffsetParam.getPlanSystem();
        Map<Long, String> dimIdMappingDimNumber = fundPlanSystem.getDimList().stream().collect(Collectors.toMap(dim -> dim.getId(), dim -> dim.getDimType() == DimensionType.DETAILDIM ? dim.getDetailDimType().getNumber() : dim.getNumber()));
        List<TemplateDim> dimList = queryResult.getDimList();
        List<Object> dimValList = queryResult.getDimValList();
        for (int i = 0; i < dimList.size(); ++i) {
            String currDimNumber = dimIdMappingDimNumber.get(dimList.get(i).getDimensionId());
            if (!Objects.equals(dimNumber, currDimNumber)) continue;
            return dimValList.get(i);
        }
        return null;
    }

    protected BigDecimal calcSumAcctAmt(List<InnerRuleSubjectConfig.SubjectOrder> subjectOrderLst, List<ReportDataQueryResult> reportDataQueryResults) {
        Set acctIds = subjectOrderLst.stream().map(o -> o.getSubjectId()).collect(Collectors.toSet());
        BigDecimal amount = subjectOrderLst.stream().filter(o -> !acctIds.contains(o.getParentId())).map(o -> {
            List queryResults = reportDataQueryResults.stream().filter(Objects::nonNull).filter(v -> v.getDimValList().contains(o.getSubjectId())).collect(Collectors.toList());
            BigDecimal amt = BigDecimal.ZERO;
            for (ReportDataQueryResult queryResult : queryResults) {
                BigDecimal tempAmt = BigDecimal.ZERO;
                if (EmptyUtil.isNoEmpty((Object)queryResult)) {
                    tempAmt = this.transferAmt().apply(queryResult.getAmountUnit(), queryResult.getOriginalPlanAmt());
                }
                amt = amt.add(tempAmt);
            }
            return amt;
        }).reduce(BigDecimal::add).orElseGet(() -> BigDecimal.ZERO);
        return amount;
    }

    private String getDimValDisplayName(String dimNumber, Object dimVal, ReportDataQueryResult queryResult) {
        if (Objects.isNull(dimVal)) {
            return null;
        }
        FundPlanSystem fundPlanSystem = this.internalOffsetParam.getPlanSystem();
        boolean isMainDim = fundPlanSystem.getMainDimList().stream().anyMatch(dim -> Objects.equals(dimNumber, dim.getNumber()));
        if (isMainDim) {
            DynamicObject dynamicObject = TmcDataServiceHelper.loadSingle((Object)dimVal, (String)"fpm_member", (String)"name");
            return dynamicObject.getLocaleString("name").getLocaleValue();
        }
        Optional<Dimension> detailDimOpt = fundPlanSystem.getDetailDimList().stream().filter(detailDim -> Objects.equals(detailDim.getDetailDimType().getNumber(), dimNumber)).findAny();
        if (!detailDimOpt.isPresent()) {
            return null;
        }
        DetailDimType detailDimType = detailDimOpt.get().getDetailDimType();
        switch (detailDimType) {
            case BANK_CATE: 
            case BANK_ACCOUNT: 
            case BUSINESS_PARTNER: {
                DynamicObject dy = TmcDataServiceHelper.loadSingle((Object)dimVal, (String)String.valueOf(detailDimType.getExtVal()), (String)"name");
                return Objects.nonNull(dy) ? dy.getLocaleString("name").getLocaleValue() : null;
            }
            case PLAN_DATE: {
                return dimVal instanceof Date ? DateTimeUtil.format((Date)((Date)dimVal)) : String.valueOf(dimVal);
            }
            case COUNTERPARTY_NAME: {
                Optional<TemplateDim> first = queryResult.getDimList().stream().filter(item -> item.getDetailDimType() == DetailDimType.CONNTERPARTY_TYPE).findFirst();
                if (first.isPresent()) {
                    int typeIndex = queryResult.getDimList().indexOf(first.get());
                    String bdEntity = (String)queryResult.getDimValList().get(typeIndex);
                    DynamicObject dynamicObject = TmcDataServiceHelper.loadSingle((Object)dimVal, (String)bdEntity, (String)"name");
                    return Objects.nonNull(dynamicObject) ? dynamicObject.getLocaleString("name").getLocaleValue() : null;
                }
                return String.valueOf(dimVal);
            }
        }
        return String.valueOf(dimVal);
    }

    protected BiFunction<AmountUnit, BigDecimal, BigDecimal> transferAmt() {
        AmountUnitEnum targetAmtUnit = AmountUnitEnum.get((String)this.innerCancelRecord.getAmountUnit().getNumber());
        return (amountUnit, amt) -> {
            AmountUnitEnum sourceAmtUnit = AmountUnitEnum.get((String)amountUnit.getNumber());
            return AmountUtil.convert((AmountUnitEnum)sourceAmtUnit, (AmountUnitEnum)targetAmtUnit, (BigDecimal)amt);
        };
    }
}

