/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.interior.offset.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancelDetail;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancelRecord;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancleTotal;
import kd.tmc.fpm.business.domain.model.sumplan.InnerRuleSubjectConfig;
import kd.tmc.fpm.business.service.interior.offset.model.AuxiliaryDataInfo;
import kd.tmc.fpm.business.service.interior.offset.model.InternalOffsetDetailModel;
import kd.tmc.fpm.business.service.interior.offset.model.InternalOffsetGroupData;
import kd.tmc.fpm.business.service.interior.offset.model.InternalOffsetParam;
import kd.tmc.fpm.business.service.interior.offset.model.OptionalDimSetValInfo;
import kd.tmc.fpm.business.service.interior.offset.service.impl.AbsInternalOffsetStrategy;
import org.apache.commons.lang3.tuple.Pair;

public class FullOffsetStrategy
extends AbsInternalOffsetStrategy {
    public FullOffsetStrategy(InternalOffsetParam internalOffsetParam) {
        super(internalOffsetParam);
    }

    @Override
    public InnerCancelRecord execInternalOffset() {
        HashMap<Long, Pair<Integer, OptionalDimSetValInfo>> relationMap = new HashMap<Long, Pair<Integer, OptionalDimSetValInfo>>();
        AuxiliaryDataInfo auxiliaryData = this.internalOffsetParam.getAuxiliaryData();
        InnerRuleSubjectConfig subjectConfig = auxiliaryData.getSubjectConfig();
        ArrayList<InnerCancleTotal> totals = new ArrayList<InnerCancleTotal>(this.internalOffsetParam.getGroupDatas().size());
        ArrayList<InnerCancelDetail> details = new ArrayList<InnerCancelDetail>(this.internalOffsetParam.getGroupDatas().size());
        for (InternalOffsetGroupData groupData : this.internalOffsetParam.getGroupDatas()) {
            BigDecimal inflowAmt = this.calcSumAcctAmt(subjectConfig.getInSubjectOrderList(), groupData.getDataResult());
            BigDecimal outflowAmt = this.calcSumAcctAmt(subjectConfig.getOutSubjectOrderList(), groupData.getDataResult());
            if (inflowAmt.compareTo(BigDecimal.ZERO) == 0 && outflowAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            Set inflowSubjectIds = subjectConfig.getInSubjectOrderList().stream().filter(Objects::nonNull).map(o -> o.getSubjectId()).collect(Collectors.toSet());
            Set outflowSubjectIds = subjectConfig.getOutSubjectOrderList().stream().filter(Objects::nonNull).map(o -> o.getSubjectId()).collect(Collectors.toSet());
            InternalOffsetDetailModel detailModel = new InternalOffsetDetailModel();
            for (ReportDataQueryResult queryResult : groupData.getDataResult()) {
                InnerCancelDetail innerCancelDetail;
                BigDecimal offsetAmt;
                Long subjectId = this.getAppointDimVal(DimensionType.SUBJECTS, queryResult);
                if (inflowSubjectIds.contains(subjectId)) {
                    offsetAmt = this.transferAmt().apply(queryResult.getAmountUnit(), queryResult.getOriginalPlanAmt());
                    innerCancelDetail = this.builderInnerCancelDetail(queryResult, subjectId, offsetAmt, groupData.getGroupKey(), auxiliaryData, relationMap);
                    if (innerCancelDetail.getAvCancelAmt().compareTo(BigDecimal.ZERO) == 0 && innerCancelDetail.getCancelAmt().compareTo(BigDecimal.ZERO) == 0) continue;
                    detailModel.getInflowCancelDetails().add(innerCancelDetail);
                }
                if (!outflowSubjectIds.contains(subjectId) || (innerCancelDetail = this.builderInnerCancelDetail(queryResult, subjectId, offsetAmt = this.transferAmt().apply(queryResult.getAmountUnit(), queryResult.getOriginalPlanAmt()), groupData.getGroupKey(), auxiliaryData, relationMap)).getAvCancelAmt().compareTo(BigDecimal.ZERO) == 0 && innerCancelDetail.getCancelAmt().compareTo(BigDecimal.ZERO) == 0) continue;
                detailModel.getOutflowCancelDetails().add(innerCancelDetail);
            }
            if (detailModel != null && EmptyUtil.isNoEmpty(detailModel.getAllCancleDetails())) {
                details.addAll(detailModel.getAllCancleDetails());
            }
            totals.add(this.buildInnerCancleTotal(groupData, detailModel, subjectConfig.getDiffProcessMode()));
        }
        this.innerCancelRecord.setInnerCancleTotals(totals);
        this.innerCancelRecord.setCancelDetailList(details);
        if (EmptyUtil.isEmpty(totals)) {
            return null;
        }
        return this.innerCancelRecord;
    }
}

