/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.rpc.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.MatchPropType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.BizProps;
import kd.tmc.fpm.business.domain.model.control.ControlActTime;
import kd.tmc.fpm.business.domain.model.control.ControlTime;
import kd.tmc.fpm.business.domain.model.control.MatchMapping;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.dto.ControlExcuteServiceLogParamDTO;

public class AssemblyBizPropHelper {
    private static List<BizProps> assemblyBizInfo(DynamicObject sourceBill, String billProp, MatchPropType propType, BillMatchRule matchRule, Map<String, String> relationMapping) {
        if (sourceBill == null || StringUtils.isEmpty((String)billProp)) {
            return null;
        }
        ArrayList<BizProps> bizPropsLst = new ArrayList<BizProps>(10);
        BizProps bizProps = new BizProps();
        String tureProp = relationMapping.get(billProp);
        bizProps.setBizProp(tureProp);
        Object value = null;
        try {
            value = sourceBill.get(billProp);
            if (value instanceof DynamicObject) {
                if (propType == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u5b57\u6bb5\u672a\u914d\u7f6e\u5339\u914d\u5c5e\u6027\uff0c\u65e0\u6cd5\u6267\u884c\u53d6\u6570\u89c4\u5219\u3002", (String)"AssemblyBizPropHelper_1", (String)"tmc-fpm-business", (Object[])new Object[0]), bizProps.getBizProp()));
                }
                value = ((DynamicObject)value).getString(propType.getProp());
            } else if (value instanceof Date) {
                value = DateUtils.formatString((Date)((Date)value), (String)"yyyy-MM-dd HH:mm:ss");
            } else if (value instanceof OrmLocaleValue) {
                value = ((OrmLocaleValue)value).getLocaleValue();
            }
            bizProps.setValue(value);
            bizPropsLst.add(bizProps);
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5c5e\u6027\u6807\u8bc6\u4e3a\u201c%1$s\u201d\u7684\u5b57\u6bb5\uff0c\u65e0\u6cd5\u53d6\u503c\u3002", (String)"AssemblyBizPropHelper_2", (String)"tmc-fpm-business", (Object[])new Object[0]), billProp));
        }
        return bizPropsLst;
    }

    public static ControlExcuteServiceLogParamDTO createControlMatchParam(DynamicObject bill, BillMatchRule matchRule, ControlContext controlContext) {
        ControlExcuteServiceLogParamDTO executeRecordBizAddParamDTO = new ControlExcuteServiceLogParamDTO();
        executeRecordBizAddParamDTO.setMatchRule(matchRule);
        BillBizInfo billBizInfo = new BillBizInfo();
        billBizInfo.setBillId(bill.getLong("id"));
        billBizInfo.setBillNo(bill.getString("billno"));
        billBizInfo.setEntityType(matchRule.getEntityType());
        String mappingEntryNumber = matchRule.getMappingEntryNumber();
        if (!matchRule.isBillHead()) {
            billBizInfo.setEntryId(bill.getLong(String.format("%s.id", mappingEntryNumber)));
        }
        billBizInfo.setBizProps(AssemblyBizPropHelper.getBizProps(bill, matchRule));
        executeRecordBizAddParamDTO.setBillBizInfo(billBizInfo);
        executeRecordBizAddParamDTO.setBizOpName(controlContext.getOpName());
        executeRecordBizAddParamDTO.setServiceType(controlContext.getPlanExecuteOpType());
        executeRecordBizAddParamDTO.setUniqueId(UUID.randomUUID().toString());
        AssemblyBizPropHelper.setAmountFieldIfNeed(controlContext, executeRecordBizAddParamDTO, bill);
        return executeRecordBizAddParamDTO;
    }

    private static List<BizProps> getBizProps(DynamicObject bill, BillMatchRule matchRule) {
        String mappingEntryNumber = matchRule.getMappingEntryNumber();
        List<MatchMapping> matchMappings = matchRule.getMappings();
        ArrayList<BizProps> bizPropsLst = new ArrayList<BizProps>(10);
        HashMap<String, String> relationMapping = new HashMap<String, String>(16);
        for (MatchMapping matchMapping : matchMappings) {
            String assistBizProp;
            String bizProp = matchMapping.getBizProp();
            if (EmptyUtil.isNoEmpty((String)bizProp)) {
                relationMapping.put(bizProp.replace(String.format("%s.", mappingEntryNumber), ""), bizProp);
            }
            if (!EmptyUtil.isNoEmpty((String)(assistBizProp = matchMapping.getAssistBizProp()))) continue;
            relationMapping.put(assistBizProp.replace(String.format("%s.", mappingEntryNumber), ""), assistBizProp);
        }
        for (MatchMapping matchMapping : matchMappings) {
            String assistBizProp;
            List<BizProps> assistBizProps;
            MatchPropType propType = matchMapping.getMatchPropType();
            String bizProp = matchMapping.getBizProp().replace(String.format("%s.", mappingEntryNumber), "");
            List<BizProps> bizProps = AssemblyBizPropHelper.assemblyBizInfo(bill, bizProp, propType, matchRule, relationMapping);
            if (bizProps != null) {
                bizPropsLst.addAll(bizProps);
            }
            if ((assistBizProps = AssemblyBizPropHelper.assemblyBizInfo(bill, assistBizProp = matchMapping.getAssistBizProp().replace(String.format("%s.", mappingEntryNumber), ""), propType, matchRule, relationMapping)) == null) continue;
            bizPropsLst.addAll(assistBizProps);
        }
        return bizPropsLst.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static void setAmountFieldIfNeed(ControlContext controlContext, ControlExcuteServiceLogParamDTO executeRecordBizAddParamDTO, DynamicObject bill) {
        Function<ControlActTime, String> function;
        List controlActTimes;
        BillMatchRule matchRule = executeRecordBizAddParamDTO.getMatchRule();
        ControlTime controlTime = controlContext.getControlTime(matchRule.getSystemId());
        if (EmptyUtil.isEmpty((Object)controlTime)) {
            return;
        }
        PlanExecuteOpType planExecuteOpType = controlContext.getPlanExecuteOpType();
        List<ControlActTime> controlActTimeList = controlTime.getControlActTimeList();
        if (EmptyUtil.isEmpty(controlActTimeList)) {
            return;
        }
        String billName = matchRule.getEntityType();
        String opCode = controlContext.getOpCode();
        switch (planExecuteOpType) {
            case RELEASE: {
                controlActTimes = controlTime.getControlActTimeList().stream().filter(Objects::nonNull).filter(o -> o.getBizBill().equals(billName)).filter(o -> EmptyUtil.isNoEmpty(o.getReleaseActTime())).filter(o -> o.getReleaseActTime().contains(opCode) || Objects.equals("inspect-repair", opCode)).collect(Collectors.toList());
                function = ControlActTime::getFactBackAmtField;
                break;
            }
            case UPDATE: {
                controlActTimes = controlTime.getControlActTimeList().stream().filter(Objects::nonNull).filter(o -> o.getBizBill().equals(billName)).filter(o -> EmptyUtil.isNoEmpty(o.getActUpdateTime())).filter(o -> o.getActUpdateTime().contains(opCode) || Objects.equals("inspect-repair", opCode)).collect(Collectors.toList());
                function = ControlActTime::getAclUpdateAmtField;
                break;
            }
            case INSPECT: {
                controlActTimes = controlTime.getControlActTimeList().stream().filter(Objects::nonNull).filter(o -> o.getBizBill().equals(billName)).filter(o -> EmptyUtil.isNoEmpty(o.getReleaseActTime())).collect(Collectors.toList());
                if (EmptyUtil.isNoEmpty(controlActTimes)) {
                    function = ControlActTime::getFactBackAmtField;
                    break;
                }
                controlActTimes = controlTime.getControlActTimeList().stream().filter(Objects::nonNull).filter(o -> o.getBizBill().equals(billName)).filter(o -> EmptyUtil.isNoEmpty(o.getActUpdateTime())).collect(Collectors.toList());
                function = ControlActTime::getAclUpdateAmtField;
                break;
            }
            default: {
                return;
            }
        }
        if (EmptyUtil.isEmpty(controlActTimes) || controlActTimes.size() != 1) {
            return;
        }
        String amountField = function.apply((ControlActTime)controlActTimes.get(0));
        if (EmptyUtil.isEmpty((String)(amountField = amountField.replace(String.format("%s.", matchRule.getMappingEntryNumber()), "")))) {
            return;
        }
        try {
            BigDecimal backAmt = bill.getBigDecimal(amountField);
            executeRecordBizAddParamDTO.setOpAmount(backAmt);
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u53d6\u6570\u89c4\u5219\u201c%1$s\u201d\u627e\u4e0d\u5230\u5c5e\u6027\u6807\u8bc6\u4e3a\u201c%2$s \u201d\u7684\u5b57\u6bb5\uff0c\u65e0\u6cd5\u53d6\u503c\u3002", (String)"AssemblyBizPropHelper_3", (String)"tmc-fpm-business", (Object[])new Object[0]), matchRule.getNumber(), amountField));
        }
    }
}

