/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.rpc.impl;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.context.ControlBotpUpperHolder;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.service.ControlResult;
import kd.tmc.fpm.business.mvc.service.IControlExecuteManager;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.dto.ControlExcuteServiceLogParamDTO;
import kd.tmc.fpm.business.mvc.service.impl.ActualUpdateCheckPostProcessor;
import kd.tmc.fpm.business.service.rpc.IFpmControlRpcService;
import kd.tmc.fpm.business.service.rpc.helper.GenerateControlExecLogParamHelper;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;

public class FpmControlRpcService
implements IFpmControlRpcService {
    private static final Log logger = LogFactory.getLog(FpmControlRpcService.class);

    @Override
    public String dispatch(DynamicObject[] selectBills, String dbRouteKey, String opBizName, String controlType, String methodName) {
        ControlResult controlResult = new ControlResult();
        try {
            PlanExecuteOpType planExecuteOpType = ITypeEnum.getByNumber(controlType, PlanExecuteOpType.class);
            switch (methodName) {
                case "tryControl": {
                    controlResult = this.tryControl(selectBills, this.getControlContext(dbRouteKey, opBizName, planExecuteOpType));
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u8bb0\u5f55\u6821\u9a8c\u5de5\u4f5c\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u5982\u4e0b\uff1a", (Throwable)e);
            controlResult = new ControlResult();
            controlResult.setErrMsg(e.getMessage());
        }
        return FpmSerializeUtil.serializeJson((Object)controlResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ControlResult tryControl(DynamicObject[] selectBills, ControlContext controlContext) {
        try {
            ControlBotpUpperHolder.set(selectBills);
            List<ControlExcuteServiceLogParamDTO> executeServiceLogParamDTOList = GenerateControlExecLogParamHelper.generatePlanExecuteRecordParamsOfWrite(selectBills, controlContext);
            IControlExecuteManager executeManager = FpmServiceFactory.getBizService(IControlExecuteManager.class);
            ControlResult controlResult = executeManager.prepare(controlContext, executeServiceLogParamDTOList);
            return controlResult;
        }
        finally {
            ControlBotpUpperHolder.clean();
        }
    }

    private ControlContext getControlContext(String dbRouteKey, String opBizName, PlanExecuteOpType planExecuteOpType) {
        ControlContext controlContext = new ControlContext();
        controlContext.setDbRouteKey(dbRouteKey);
        String[] split = opBizName.split("-");
        controlContext.setOpName(opBizName);
        controlContext.setOpCode(split[0]);
        controlContext.setPlanExecuteOpType(planExecuteOpType);
        this.registerPostProcessorForPlanExecuteOpType(controlContext);
        return controlContext;
    }

    private void registerPostProcessorForPlanExecuteOpType(ControlContext controlContext) {
        if (controlContext.getPlanExecuteOpType().isUpdate()) {
            controlContext.addControlExecuteParamPostProcessor(new ActualUpdateCheckPostProcessor());
        }
    }
}

