/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.sumreport.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.enums.SunReportSumStatus;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigSnapshot;
import kd.tmc.fpm.business.helper.ReportPlanSumHelper;
import kd.tmc.fpm.business.mvc.converter.utils.ConverterUtils;
import kd.tmc.fpm.business.mvc.repository.ISumPlanRepository;
import kd.tmc.fpm.business.service.sumreport.service.ISummaryConfigService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import org.apache.commons.collections4.CollectionUtils;

public class SummaryConfigServiceImpl
implements ISummaryConfigService {
    private static Log logger = LogFactory.getLog(SummaryConfigServiceImpl.class);
    private ISumPlanRepository iSumPlanRepository = FpmServiceFactory.getBizService(ISumPlanRepository.class);
    private IDataSaveService iDataSaveService = FpmServiceFactory.getBizService(IDataSaveService.class);

    @Override
    public SumPlanParamConfig getSummaryParamConfig(Long reportId) {
        return ReportPlanSumHelper.getSummaryParamConfig(reportId);
    }

    @Override
    public SumPlanParamConfig getSummaryParamConfig(Report report) {
        FpmAssertUtil.isNotNull((Object)report, (String)ResManager.loadKDString((String)"\u62a5\u8868\u4e0d\u5b58\u5728\u3002", (String)"SummaryConfigServiceImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
        FpmAssertUtil.isNotNull((Object)((Object)report.getReportStatus()), (String)String.format(ResManager.loadKDString((String)"\u62a5\u8868\u3010%1$s\u3011\u7684\u62a5\u8868\u72b6\u6001\u4e0d\u5b58\u5728\u3002", (String)"SummaryConfigServiceImpl_2", (String)"tmc-fpm-business", (Object[])new Object[0]), report.getNumber()));
        FpmAssertUtil.isNotNull((Object)report.getSystemId(), (String)String.format(ResManager.loadKDString((String)"\u62a5\u8868\u3010%1$s\u3011\u7684\u4f53\u7cfbID\u4e0d\u5b58\u5728\u3002", (String)"SummaryConfigServiceImpl_3", (String)"tmc-fpm-business", (Object[])new Object[0]), report.getNumber()));
        FpmAssertUtil.isNotNull((Object)report.getReportPeriodType(), (String)String.format(ResManager.loadKDString((String)"\u62a5\u8868\u3010%1$s\u3011\u7684\u7f16\u62a5\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"SummaryConfigServiceImpl_4", (String)"tmc-fpm-business", (Object[])new Object[0]), report.getNumber()));
        if (report.getReportStatus() != ReportStatus.ENABLE || EmptyUtil.isEmpty((Long)report.getSumParamConfigSnapshotId())) {
            return this.iSumPlanRepository.loadSumConfigBySystem(report.getSystemId(), report.getReportPeriodType().getReportPeriodId());
        }
        return this.iSumPlanRepository.getSumPlanParamConfigBySnapshotId(report.getSumParamConfigSnapshotId());
    }

    @Override
    public SumPlanParamConfig getSummaryParamConfigWithoutNoneUpperSumOrg(Long reportId) {
        Report report = ReportPlanSumHelper.loadSimpleReport(reportId);
        FpmAssertUtil.isNotNull((Object)report, (String)String.format(ResManager.loadKDString((String)"ID\u3010%1$s\u3011\u7684\u62a5\u8868\u4e0d\u5b58\u5728\u3002", (String)"SummaryConfigServiceImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]), reportId));
        return this.getSummaryParamConfigWithoutNoneUpperSumOrg(report);
    }

    @Override
    public SumPlanParamConfig getSummaryParamConfigWithoutNoneUpperSumOrg(Report report) {
        FpmAssertUtil.isNotNull((Object)report, (String)ResManager.loadKDString((String)"\u62a5\u8868\u4e0d\u5b58\u5728\u3002", (String)"SummaryConfigServiceImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
        FpmAssertUtil.isNotNull((Object)((Object)report.getReportStatus()), (String)String.format(ResManager.loadKDString((String)"\u62a5\u8868\u3010%1$s\u3011\u7684\u62a5\u8868\u72b6\u6001\u4e0d\u5b58\u5728\u3002", (String)"SummaryConfigServiceImpl_2", (String)"tmc-fpm-business", (Object[])new Object[0]), report.getNumber()));
        FpmAssertUtil.isNotNull((Object)report.getSystemId(), (String)String.format(ResManager.loadKDString((String)"\u62a5\u8868\u3010%1$s\u3011\u7684\u4f53\u7cfbID\u4e0d\u5b58\u5728\u3002", (String)"SummaryConfigServiceImpl_3", (String)"tmc-fpm-business", (Object[])new Object[0]), report.getNumber()));
        FpmAssertUtil.isNotNull((Object)report.getReportPeriodType(), (String)String.format(ResManager.loadKDString((String)"\u62a5\u8868\u3010%1$s\u3011\u7684\u7f16\u62a5\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"SummaryConfigServiceImpl_4", (String)"tmc-fpm-business", (Object[])new Object[0]), report.getNumber()));
        if (report.getReportStatus() != ReportStatus.ENABLE || EmptyUtil.isEmpty((Long)report.getSumParamConfigSnapshotId())) {
            return this.iSumPlanRepository.loadSumConfigBySystem(report.getSystemId(), report.getReportPeriodType().getReportPeriodId());
        }
        SumPlanParamConfig sumPlanParamConfig = this.iSumPlanRepository.getSumPlanParamConfigBySnapshotId(report.getSumParamConfigSnapshotId());
        if (report instanceof SumPlanReport) {
            SumPlanReport sumPlanReport = (SumPlanReport)report;
            Set upperSumReportIdSet = sumPlanReport.getSunReportSumRecordList().stream().filter(item -> item.getSumStatus() == SunReportSumStatus.SUM).map(SumPlanReport.SunReportSumRecord::getSunReportId).collect(Collectors.toSet());
            DynamicObjectCollection upperSumReportDyColl = QueryServiceHelper.query((String)"fpm_report", (String)String.join((CharSequence)",", "id", "reportorg.id"), (QFilter[])new QFilter[]{new QFilter("id", "in", upperSumReportIdSet)});
            Set upperSumReportOrgIdSet = upperSumReportDyColl.stream().map(dy -> dy.getLong("reportorg.id")).collect(Collectors.toSet());
            List<SumPlanParamConfigInfo> sumPlanParamConfigInfoList = sumPlanParamConfig.getConfigInfoList();
            Set nonUpperSumLeafReportOrgIdSet = sumPlanParamConfigInfoList.stream().filter(item -> !item.isSumAuditNode()).filter(item -> EmptyUtil.isNoEmpty((Long)item.getParentId())).filter(item -> EmptyUtil.isEmpty(item.getChildren())).filter(item -> !upperSumReportOrgIdSet.contains(item.getOrgMemberId())).map(SumPlanParamConfigInfo::getOrgMemberId).collect(Collectors.toSet());
            Iterator<SumPlanParamConfigInfo> iterator = sumPlanParamConfigInfoList.iterator();
            while (iterator.hasNext()) {
                SumPlanParamConfigInfo currParamConfigInfo = iterator.next();
                if (nonUpperSumLeafReportOrgIdSet.contains(currParamConfigInfo.getOrgMemberId())) {
                    iterator.remove();
                    continue;
                }
                if (!CollectionUtils.isNotEmpty(currParamConfigInfo.getChildren())) continue;
                currParamConfigInfo.getChildren().removeIf(item -> nonUpperSumLeafReportOrgIdSet.contains(item.getOrgMemberId()));
            }
        }
        return sumPlanParamConfig;
    }

    @Override
    public SumPlanParamConfigSnapshot getSummaryParamConfigSnapshot(Long snapshotId) {
        return (SumPlanParamConfigSnapshot)this.iSumPlanRepository.getSumPlanParamConfigBySnapshotId(snapshotId);
    }

    @Override
    public SumPlanParamConfig getNewestEnableSummaryParamConfig(Long systemId, Long reportTypeId) {
        return this.iSumPlanRepository.loadSumConfigBySystem(systemId, reportTypeId);
    }

    @Override
    public List<SumPlanParamConfig> loadSumConfigBySystems(Collection<Long> systemIds, Collection<Long> reportTypeIds) {
        return this.iSumPlanRepository.loadSumConfigBySystems(systemIds, reportTypeIds, false);
    }

    @Override
    public Long generateSnapshot(SumPlanParamConfig sumPlanParamConfig) {
        DynamicObject snapshotDy = TmcDataServiceHelper.newDynamicObject((String)"fpm_summaryconfig_snp");
        ConverterUtils.convertWithArgs(DynamicObject.class, sumPlanParamConfig, snapshotDy, true);
        snapshotDy.set("summaryconfig", (Object)sumPlanParamConfig.getId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{snapshotDy});
        return snapshotDy.getLong("id");
    }

    @Override
    public void syncSnapshotToReport(Long configSnapshotId, Collection<Long> reportIds) {
        FpmAssertUtil.isNotNull((Object)configSnapshotId, (String)ResManager.loadKDString((String)"\u6c47\u603b\u53c2\u6570\u914d\u7f6e\u5feb\u7167ID\uff0c\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"SummaryConfigServiceImpl_5", (String)"tmc-fpm-business", (Object[])new Object[0]));
        FpmAssertUtil.isNotEmpty(reportIds, (String)ResManager.loadKDString((String)"\u5f85\u540c\u6b65\u6c47\u603b\u53c2\u6570\u914d\u7f6e\u5feb\u7167\u7684\u7684\u62a5\u8868\uff0c\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"SummaryConfigServiceImpl_6", (String)"tmc-fpm-business", (Object[])new Object[0]));
        logger.info("\u5f85\u540c\u6b65\u6c47\u603b\u53c2\u6570\u914d\u7f6e\u5feb\u7167 {} \u7684\u62a5\u8868\u6570\u91cf\uff1a{}", (Object)configSnapshotId, (Object)reportIds.size());
        this.iDataSaveService.update(IDataSaveService.Constants.REPORT_SUMMARY_PARAM_CONFIG_SNAPSHOT_UPDATE, new ArrayList<Long>(reportIds), (t, d) -> {
            d.add(configSnapshotId);
            d.add(t);
        });
    }
}

