/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.command.chain;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.spread.command.AbsSpreadCommand;
import kd.tmc.fpm.common.enums.CellDimTypeEnum;
import kd.tmc.fpm.spread.command.SpreadCommandInvoker;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Cell;

public class SetRowOutlineCmdChain
extends AbsSpreadCommand {
    private Book book;

    public SetRowOutlineCmdChain(SpreadCommandInvoker invoker, Book book) {
        super(invoker);
        this.book = book;
    }

    @Override
    protected void command(SpreadCommandInvoker invoker) {
        List cells = this.book.getSheet().getCellList();
        if (EmptyUtil.isEmpty((Collection)cells)) {
            return;
        }
        List rowDims = cells.stream().filter(Objects::nonNull).filter(cell -> cell.getCellDimType() == CellDimTypeEnum.ROWDIMS).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(rowDims)) {
            return;
        }
        Map<Integer, List<Cell>> colInxByCells = rowDims.stream().filter(Objects::nonNull).filter(cell -> cell.getRowSpan() == 1 && cell.getColSpan() == 1).collect(Collectors.groupingBy(cell -> cell.getCol()));
        for (Map.Entry<Integer, List<Cell>> entry : colInxByCells.entrySet()) {
            List<Cell> rowDimCells = entry.getValue();
            Optional<Cell> any = rowDimCells.stream().filter(cell -> cell.getLevel() >= 1).findAny();
            if (!any.isPresent()) continue;
            Integer max = rowDimCells.stream().max((a, b) -> a.getLevel() - b.getLevel()).map(Cell::getLevel).orElseGet(() -> 20);
            invoker.setOutlineColumn(entry.getKey().intValue(), Boolean.valueOf(false), max, false);
            break;
        }
    }
}

