/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.datamanager;

import java.util.List;
import kd.bos.form.IPageCache;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.IFpmPageCacheService;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.PlanChangeReport;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.mvc.repository.IReportPlanRepositoryV2;
import kd.tmc.fpm.business.mvc.repository.impl.ReportPlanRepositoryV2;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportDataManagerV2;
import kd.tmc.fpm.business.spread.generator.executor.IReportDataProcessExecutor;
import kd.tmc.fpm.business.spread.generator.executor.ReportDataProcessExecutorFactory;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;

public class ReportDataManagerFactoryV2 {
    public static ReportDataManagerV2 getDataManager(FundPlanSystem system, Report report, IFpmPageCacheService cacheService) {
        IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getReportExecutor(system, report, 0);
        ReportModel reportModel = reportExecutor.executeAction();
        return new ReportDataManagerV2(report.getId(), cacheService, reportModel.getReportCalcModelList().get(0), report.getTemplate(), system, report.getProcessStatus() == ReportProcessStatus.SAVE);
    }

    public static ReportDataManagerV2 getExecBiasAnalysisDataManager(FundPlanSystem system, Report report, IFpmPageCacheService cacheService) {
        IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getExecBiasAnalysisExecutor(system, report, null);
        ReportModel reportModel = new ReportModel();
        reportExecutor.executeAction(reportModel);
        ReportDataManagerV2 manager = new ReportDataManagerV2(report.getId(), cacheService, reportModel.getReportCalcModelList().get(0), report.getTemplate(), system, report.getProcessStatus() == ReportProcessStatus.SAVE);
        return manager;
    }

    public static ReportDataManagerV2 getExecBiasAnalysisSumPlanDataManager(FundPlanSystem system, SumPlanReport report, List<Long> pageDimMemberIds, IFpmPageCacheService cacheService) {
        IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getExecBiasAnalysisSumPlanReportExecutor(system, report, EmptyUtil.isEmpty(pageDimMemberIds) ? null : pageDimMemberIds);
        ReportModel reportModel = reportExecutor.executeAction();
        ReportDataManagerV2 manager = new ReportDataManagerV2(report.getId(), cacheService, reportModel.getReportCalcModelList().get(0), report.getTemplate(), system, false);
        return manager;
    }

    public static ReportDataManagerV2 getAdjustReportDataManagerByPageDim(FundPlanSystem fundPlanSystem, PlanChangeReport planChangeReport, IFpmPageCacheService cacheService, List<Long> pageDimS) {
        IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getAdjustBillReportPlanExecExecutor(fundPlanSystem, planChangeReport, pageDimS);
        ReportModel reportModel = new ReportModel();
        reportExecutor.executeAction(reportModel);
        ReportDataManagerV2 manager = new ReportDataManagerV2(planChangeReport.getReportId(), cacheService, reportModel.getReportCalcModelList().get(0), planChangeReport.getTemplate(), fundPlanSystem, true);
        return manager;
    }

    public static ReportDataManagerV2 getAdjustReportDataManager(FundPlanSystem fundPlanSystem, PlanChangeReport planChangeReport, IFpmPageCacheService cacheService) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan("getAdjustReportDataManager_method");){
            ReportDataManagerV2 manager;
            span.addTag("Bill Report Plan ExecExecutor.");
            IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getAdjustBillReportPlanExecExecutor(fundPlanSystem, planChangeReport);
            ReportModel reportModel = new ReportModel();
            reportExecutor.executeAction(reportModel);
            span.addTag("new ReportDataManagerV2.");
            ReportDataManagerV2 reportDataManagerV2 = manager = new ReportDataManagerV2(planChangeReport.getReportId(), cacheService, reportModel.getReportCalcModelList().get(0), planChangeReport.getTemplate(), fundPlanSystem, true);
            return reportDataManagerV2;
        }
    }

    public static ReportDataManagerV2 getSumReportDataManager(FundPlanSystem system, SumPlanReport report, List<Long> pageDimMemberIds, IFpmPageCacheService cacheService) {
        IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getSumPlanReportExecExecutor(system, report, EmptyUtil.isEmpty(pageDimMemberIds) ? null : pageDimMemberIds);
        ReportModel reportModel = new ReportModel();
        reportExecutor.executeAction(reportModel);
        ReportDataManagerV2 manager = new ReportDataManagerV2(report.getId(), cacheService, reportModel.getReportCalcModelList().get(0), report.getTemplate(), system, report.getProcessStatus() == ReportProcessStatus.SAVE);
        return manager;
    }

    public static ReportDataManagerV2 getReportDataManagerV2(IPageCache pageCache) {
        String managerJson = pageCache.get("reportdatamanager_cache");
        if (EmptyUtil.isEmpty((String)managerJson)) {
            return null;
        }
        ReportDataManagerV2 managerV2 = (ReportDataManagerV2)FpmSerializeUtil.deserialize((String)managerJson, ReportDataManagerV2.class);
        IReportPlanRepositoryV2 repository = managerV2.getRepository();
        if (!(repository instanceof ReportPlanRepositoryV2)) {
            repository = (IReportPlanRepositoryV2)FpmSerializeUtil.deserialize((String)repository.toString(), ReportPlanRepositoryV2.class);
            managerV2.setRepository(repository);
        }
        return managerV2;
    }
}

