/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.datamanager.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class ReportCalcTree
implements Serializable {
    private ReportCalcValTreeNode root;
    private List<ReportCalcValTreeNode> leafList;

    public ReportCalcTree() {
    }

    public ReportCalcTree(ReportCalcValTreeNode root) {
        this.root = root;
        this.leafList = root.getAllChildren().stream().filter(o -> CollectionUtils.isEmpty(o.getChildren())).collect(Collectors.toList());
        this.rebuildDimLevel();
    }

    public List<ReportCalcVal> getDimCalcValList(int index, int offset) {
        int realIdx = index - offset;
        if (realIdx > this.leafList.size() - 1) {
            return Collections.emptyList();
        }
        LinkedList<ReportCalcVal> calcValList = new LinkedList<ReportCalcVal>();
        for (ReportCalcValTreeNode node = this.leafList.get(realIdx); node != null && node != this.root; node = node.getParent()) {
            if (node.isSkipVal() || node.getCalcVal().getDimensionId() == null || node.getCalcVal().getValue() == null) continue;
            calcValList.add(node.getCalcVal());
        }
        return calcValList;
    }

    public DimensionInfoBean getDimInfoByLocation(int index, int offset) {
        int realIdx = index - offset;
        if (realIdx > this.leafList.size() - 1) {
            return new DimensionInfoBean();
        }
        LinkedList<Long> dimIdList = new LinkedList<Long>();
        LinkedList<Object> dimMemIdList = new LinkedList<Object>();
        for (ReportCalcValTreeNode node = this.leafList.get(realIdx); node != null && node != this.root; node = node.getParent()) {
            if (node.isSkipVal() || node.getCalcVal().getDimensionId() == null || node.getCalcVal().getValue() == null || node.isRemark()) continue;
            dimIdList.add(node.getCalcVal().getDimensionId());
            dimMemIdList.add(node.getCalcVal().getValue());
        }
        return DimensionInfoBean.of(dimIdList, dimMemIdList);
    }

    public ReportCalcValTreeNode getRoot() {
        return this.root;
    }

    public void setRoot(ReportCalcValTreeNode root) {
        this.root = root;
    }

    public List<ReportCalcValTreeNode> getLeafList() {
        return this.leafList;
    }

    public void setLeafList(List<ReportCalcValTreeNode> leafList) {
        this.leafList = leafList;
    }

    public ReportCalcValTreeNode findNode(int row, int col) {
        Optional<ReportCalcValTreeNode> first = this.root.getAllChildren().stream().filter(Objects::nonNull).filter(o -> o.getCalcVal().getRow() == row && o.getCalcVal().getCol() == col).findFirst();
        if (first.isPresent()) {
            return first.get();
        }
        return null;
    }

    public void refreshTree() {
        this.leafList = this.root.getAllChildren().stream().filter(o -> CollectionUtils.isEmpty(o.getChildren())).collect(Collectors.toList());
    }

    public boolean isRoot(ReportCalcValTreeNode node) {
        return node == this.root;
    }

    private void rebuildDimLevel() {
        this.rebuildDimLevel(this.root.getChildren(), 1);
    }

    public void rebuildDimLevel(List<ReportCalcValTreeNode> children, int level) {
        if (EmptyUtil.isEmpty(children)) {
            return;
        }
        for (ReportCalcValTreeNode child : children) {
            child.setDimLevel(level);
            this.rebuildDimLevel(child.getChildren(), level + 1);
        }
    }
}

