/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.datamanager.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AuxiliaryFieldsUseType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.spread.widget.DisplayTypeEnum;

public class ReportCalcValTreeNode
implements Serializable {
    private ReportCalcVal calcVal = new ReportCalcVal();
    private ReportCalcValTreeNode parent;
    private List<ReportCalcValTreeNode> children;
    private int leafChildCnt;
    private boolean skipVal;

    public ReportCalcValTreeNode() {
        ReportValueType reportValueType = new ReportValueType();
        reportValueType.setReportCellType(ReportCellType.TEXT);
        this.calcVal.setValueType(reportValueType);
    }

    public List<ReportCalcValTreeNode> getAllChildren() {
        ArrayList<ReportCalcValTreeNode> allMemberList = new ArrayList<ReportCalcValTreeNode>();
        this.getAllChildren(this, allMemberList);
        return allMemberList;
    }

    private void getAllChildren(ReportCalcValTreeNode tree, List<ReportCalcValTreeNode> outValList) {
        if (tree != this) {
            outValList.add(tree);
        }
        if (tree.getChildren() == null) {
            return;
        }
        for (ReportCalcValTreeNode child : tree.getChildren()) {
            this.getAllChildren(child, outValList);
        }
    }

    public List<ReportCalcValTreeNode> getAllLeafChildren() {
        LinkedList<ReportCalcValTreeNode> allLeafMemberList = new LinkedList<ReportCalcValTreeNode>();
        this.getAllLeafChildren(this, allLeafMemberList);
        return allLeafMemberList;
    }

    private void getAllLeafChildren(ReportCalcValTreeNode tree, List<ReportCalcValTreeNode> outValList) {
        if (tree == null) {
            return;
        }
        if (tree.getChildren() == null) {
            outValList.add(tree);
            return;
        }
        for (ReportCalcValTreeNode child : tree.getChildren()) {
            this.getAllLeafChildren(child, outValList);
        }
    }

    public void addChild(ReportCalcValTreeNode child) {
        if (this.children == null) {
            this.children = new ArrayList<ReportCalcValTreeNode>(8);
        }
        this.children.add(child);
        child.parent = this;
        child.afterAddChild(this);
    }

    protected void afterAddChild(ReportCalcValTreeNode treeNode) {
    }

    public void addChildFirst(ReportCalcValTreeNode child) {
        if (this.children == null) {
            this.children = new ArrayList<ReportCalcValTreeNode>(8);
        }
        this.children.add(0, child);
        child.parent = this;
        child.afterAddChild(this);
    }

    public ReportCalcVal getCalcVal() {
        return this.calcVal;
    }

    public void setCalcVal(ReportCalcVal calcVal) {
        this.calcVal = calcVal;
    }

    public ReportCalcValTreeNode getParent() {
        return this.parent;
    }

    public void setParent(ReportCalcValTreeNode parent) {
        this.parent = parent;
    }

    public List<ReportCalcValTreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<ReportCalcValTreeNode> children) {
        this.children = children;
    }

    public int getLeafChildCnt() {
        return this.leafChildCnt;
    }

    public void setLeafChildCnt(int leafChildCnt) {
        this.leafChildCnt = leafChildCnt;
    }

    public boolean isSkipVal() {
        return this.skipVal;
    }

    public void setSkipVal(boolean skipVal) {
        this.skipVal = skipVal;
    }

    public void setDimensionId(Long dimensionId) {
        this.calcVal.setDimensionId(dimensionId);
    }

    public void setUseType(AuxiliaryFieldsUseType useType) {
        this.calcVal.setUseType(useType);
    }

    public String getDimensionName() {
        return this.calcVal.getDimensionName();
    }

    public void setDimensionName(String dimensionName) {
        this.calcVal.setDimensionName(dimensionName);
    }

    public String getDisplayVal() {
        return this.calcVal.getDisplayVal();
    }

    public void setDisplayVal(String displayVal) {
        this.calcVal.setDisplayVal(displayVal);
    }

    public Object getValue() {
        return this.calcVal.getValue();
    }

    public void setValue(Object value) {
        this.calcVal.setValue(value);
    }

    public int getCol() {
        return this.calcVal.getCol();
    }

    public void setCol(int col) {
        this.calcVal.setCol(col);
    }

    public int getRow() {
        return this.calcVal.getRow();
    }

    public void setRow(int row) {
        this.calcVal.setRow(row);
    }

    public int getColSpan() {
        return this.calcVal.getColSpan();
    }

    public void setColSpan(int colSpan) {
        this.calcVal.setColSpan(colSpan);
    }

    public int getRowSpan() {
        return this.calcVal.getRowSpan();
    }

    public void setRowSpan(int rowSpan) {
        this.calcVal.setRowSpan(rowSpan);
    }

    public int getLevel() {
        return this.calcVal.getLevel();
    }

    public void setLevel(int level) {
        this.calcVal.setLevel(level);
    }

    public int getDimLevel() {
        return this.calcVal.getDimLevel();
    }

    public void setDimLevel(int dimLevel) {
        this.calcVal.setDimLevel(dimLevel);
    }

    public boolean isEnable() {
        return this.calcVal.isEnable();
    }

    public void setEnable(boolean enable) {
        this.calcVal.setEnable(enable);
    }

    public boolean isSummary() {
        return this.calcVal.isSummary();
    }

    public void setSummary(boolean summary) {
        this.calcVal.setSummary(summary);
    }

    public boolean isLittleSummary() {
        return this.isSummary() && !this.isTotalSummary();
    }

    public boolean isTotalSummary() {
        return this.calcVal.isTotalSummary();
    }

    public void setTotalSummary(boolean totalSummary) {
        this.calcVal.setTotalSummary(totalSummary);
        List<ReportCalcValTreeNode> children = this.getChildren();
        if (EmptyUtil.isEmpty(children)) {
            return;
        }
        for (ReportCalcValTreeNode childNode : children) {
            childNode.setTotalSummary(totalSummary);
            childNode.setTotalSummaryOfLittleSummary(totalSummary && childNode.isTotalSummaryOfLittleSummary());
        }
    }

    public boolean isTotalSummaryOfLittleSummary() {
        return this.calcVal.isTotalSummaryOfLittleSummary();
    }

    public void setTotalSummaryOfLittleSummary(boolean totalSummaryOfLittleSummary) {
        this.calcVal.setTotalSummaryOfLittleSummary(totalSummaryOfLittleSummary);
    }

    public void setReference(boolean reference) {
        this.calcVal.setReferenceCell(reference);
        List<ReportCalcValTreeNode> children = this.getChildren();
        if (EmptyUtil.isEmpty(children)) {
            return;
        }
        for (ReportCalcValTreeNode childNode : children) {
            childNode.setReference(reference);
        }
    }

    public boolean isRemark() {
        return this.calcVal.isRemarkCell();
    }

    public void setRemark(boolean remark) {
        this.calcVal.setRemarkCell(remark);
    }

    public void setDisplayType(DisplayTypeEnum displayType) {
        this.calcVal.setDisplayType(displayType);
    }

    public void setMetric(boolean isMetric) {
        this.calcVal.setMetric(isMetric);
    }

    public boolean isRollCell() {
        return this.calcVal.isRollCell();
    }

    public void setRollCell(boolean rollCell) {
        this.calcVal.setRollCell(rollCell);
        List<ReportCalcValTreeNode> children = this.getChildren();
        if (EmptyUtil.isEmpty(children)) {
            return;
        }
        for (ReportCalcValTreeNode childNode : children) {
            childNode.setRollCell(rollCell);
        }
    }

    public int getColEnd() {
        return this.calcVal.getCol() + this.calcVal.getColSpan() - 1;
    }

    public int getRowEnd() {
        return this.calcVal.getRow() + this.calcVal.getRowSpan() - 1;
    }
}

