/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.datamanager.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.mvc.repository.IReportPlanRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ReportPlanRepository;
import kd.tmc.fpm.business.spread.datamanager.IReportDataManager;
import kd.tmc.fpm.business.spread.formula.impl.DAGFormulaManager;

public class ReportDataManager
implements IReportDataManager {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog(ReportDataManager.class);
    private IReportPlanRepository repository;
    private transient Set<ReportCalcVal> lastUpdatedValList;
    private transient ReportCalcModel currCalcModel;

    public ReportDataManager() {
        this.lastUpdatedValList = new HashSet<ReportCalcVal>();
    }

    public ReportDataManager(Long reportId, String pageId, ReportModel reportModel, ReportTemplate template, FundPlanSystem system) {
        this.repository = new ReportPlanRepository(reportId, pageId);
        List<ReportCalcModel> calcModelList = reportModel.getReportCalcModelList();
        for (ReportCalcModel calcModel : calcModelList) {
            DAGFormulaManager formulaManager = new DAGFormulaManager(calcModel, null);
            this.repository.saveReportCalcModel(calcModel);
            this.repository.saveFormulaManger(formulaManager);
        }
        this.repository.saveReportTemplate(template);
        this.repository.saveSystem(system);
        this.currCalcModel = calcModelList.get(calcModelList.size() - 1);
    }

    @Override
    public ReportCalcModel getReportCalcModelByPageDim(List<Long> pageDimS) {
        ReportCalcModel reportCalcModel = this.repository.getReportCalcModelByPageDim(pageDimS);
        if (reportCalcModel != null) {
            this.currCalcModel = reportCalcModel;
        }
        return reportCalcModel;
    }

    @Override
    public void saveReportCalcModel(List<ReportCalcModel> reportCalcModelS) {
        for (ReportCalcModel reportCalcModel : reportCalcModelS) {
            this.repository.saveReportCalcModel(reportCalcModel);
            DAGFormulaManager formulaManager = new DAGFormulaManager(reportCalcModel, this.repository);
            this.repository.saveFormulaManger(formulaManager);
        }
        this.currCalcModel = reportCalcModelS.get(reportCalcModelS.size() - 1);
    }

    @Override
    public List<ReportCalcVal> getCurrRowData(Set<Integer> rowS) {
        HashMap<Integer, List<ReportCalcVal>> rowDataMap = new HashMap<Integer, List<ReportCalcVal>>(rowS.size());
        for (Integer row : rowS) {
            List<ReportCalcVal> currRowData = this.repository.getCurrRowData(row);
            rowDataMap.put(row, currRowData);
        }
        ArrayList<ReportCalcVal> result = new ArrayList<ReportCalcVal>(16);
        Collection values = rowDataMap.values();
        for (List value : values) {
            result.addAll(value);
        }
        return result;
    }

    @Override
    public List<ReportCalcVal> getCurrColDimValList() {
        return this.repository.getCurrColDimData();
    }

    @Override
    public List<ReportCalcVal> getCurrRowDimValList() {
        return this.repository.getCurrRowDimData();
    }

    @Override
    public List<ReportCalcVal> getCurrPageDimValList() {
        return this.repository.getCurrPageDimData();
    }

    @Override
    public ReportCalcVal getCurrData(int row, int col) {
        return this.repository.getCurrRowColData(row, col);
    }

    @Override
    public ReportTemplate getReportTemplate() {
        return this.repository.getReportTemplate();
    }

    @Override
    public FundPlanSystem getSystem() {
        return this.repository.getSystem();
    }

    @Override
    public Long getReportId() {
        return ((ReportPlanRepository)this.repository).getReportId();
    }

    @Override
    public String getPageId() {
        return ((ReportPlanRepository)this.repository).getPageId();
    }

    private void initNeedUpdateData() {
        if (this.lastUpdatedValList == null) {
            this.lastUpdatedValList = new HashSet<ReportCalcVal>(10);
        }
    }

    @Override
    public List<ReportCalcVal> getNeedUpdateValList() {
        return new ArrayList<ReportCalcVal>(this.lastUpdatedValList);
    }

    @Override
    public void destroy() {
        this.repository.releaseCache();
    }

    public ReportCalcModel getCurrCalcModel() {
        return this.currCalcModel;
    }

    public void setCurrCalcModel(ReportCalcModel currCalcModel) {
        this.currCalcModel = currCalcModel;
    }

    public IReportPlanRepository getRepository() {
        return this.repository;
    }

    public void setRepository(IReportPlanRepository repository) {
        this.repository = repository;
    }
}

