/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.datamanager.impl;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.data.CacheCell;
import kd.tmc.fpm.business.cache.data.CacheCellMeta;
import kd.tmc.fpm.business.cache.data.CellDataSource;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.index.generate.bean.WarpBean;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportDataWrapper;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.spread.datamanager.ISpreadDataReceiver;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcTree;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.helper.StringHelper;

public class SpreadAuxiliaryDataReceiver
implements ISpreadDataReceiver {
    private final Report report;
    private final List<ReportDataWrapper> reportDataWrapperList;
    private final boolean reference;

    public SpreadAuxiliaryDataReceiver(Report report, List<ReportDataWrapper> reportDataWrapperList) {
        this(report, reportDataWrapperList, false);
    }

    public SpreadAuxiliaryDataReceiver(Report report, List<ReportDataWrapper> reportDataWrapperList, boolean reference) {
        this.report = report;
        this.reportDataWrapperList = reportDataWrapperList;
        this.reference = reference;
    }

    @Override
    public void receiveReportData(FundPlanSystem system, CellDataSource cellDataSource) {
        CacheCellMeta meta = cellDataSource.getMeta();
        ReportCalcTree colDimTree = meta.getColDimTree();
        Map<Integer, Long> colDimIdMap = colDimTree.getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).filter(ReportCalcVal::isRemarkCell).filter(reportCalcVal -> this.reference == reportCalcVal.isReferenceCell()).collect(Collectors.toMap(ReportCalcVal::getCol, ReportCalcVal::getDimensionId, (a, b) -> a));
        List<CacheCell> allCells = cellDataSource.getAllCell();
        int size = allCells.size();
        Deque<Long> deque = CommonUtils.batchGenerateIds(size);
        QueryIndexInfo<Long, ReportDataWrapper> auxIndex = QueryIndexInfo.buildEmptyIndexInfo(allCells.size());
        for (CacheCell cell : allCells) {
            ReportDataWrapper reportDataWrapper;
            if (!colDimIdMap.containsKey(cell.getCol())) continue;
            Long dataId = (Long)cell.getDataId();
            if (!cellDataSource.isDirty(cell) && EmptyUtil.isNoEmpty((Long)dataId) || cell.isSummary()) continue;
            DimensionInfoBean currDimInfoBean = cellDataSource.getDimensionInfo(cell.getCol(), cell.getRow());
            if (EmptyUtil.isNoEmpty((Long)dataId)) {
                reportDataWrapper = (ReportDataWrapper)auxIndex.findOne(currDimInfoBean);
                if (reportDataWrapper == null) {
                    reportDataWrapper = this.createExistsReportData(dataId);
                    this.reportDataWrapperList.add(reportDataWrapper);
                    auxIndex.updateIndex(new WarpBean<Long, ReportDataWrapper>(dataId, currDimInfoBean, reportDataWrapper));
                }
                reportDataWrapper.getReportData().putAuxiliaryVal(colDimIdMap.get(cell.getCol()), StringHelper.getStringValue((Object)cell.getValue()));
                continue;
            }
            reportDataWrapper = (ReportDataWrapper)auxIndex.findOne(currDimInfoBean);
            if (reportDataWrapper == null) {
                dataId = deque.poll();
                reportDataWrapper = this.newReportData(dataId, cell, currDimInfoBean);
                auxIndex.updateIndex(new WarpBean<Long, ReportDataWrapper>(dataId, currDimInfoBean, reportDataWrapper));
                this.reportDataWrapperList.add(reportDataWrapper);
            }
            if (!reportDataWrapper.isAuxiliaryInfo()) continue;
            reportDataWrapper.getReportData().putAuxiliaryVal(colDimIdMap.get(cell.getCol()), StringHelper.getStringValue((Object)cell.getValue()));
        }
    }

    private ReportDataWrapper createExistsReportData(Long dataId) {
        ReportData reportData = new ReportData();
        reportData.setId(dataId);
        reportData.setReportId(this.report.getId());
        reportData.setEffectFlag(this.report.getReportStatus() == ReportStatus.ENABLE);
        reportData.setSystemId(this.report.getSystemId());
        reportData.setAuxiliaryInfo(true);
        return new ReportDataWrapper(reportData);
    }

    private ReportDataWrapper newReportData(Long id, CacheCell cacheCell, DimensionInfoBean currDimInfoBean) {
        ReportDataWrapper existsReportData = this.createExistsReportData(id);
        existsReportData.setNewData(true);
        ReportData reportData = existsReportData.getReportData();
        reportData.setSystemId(this.report.getSystemId());
        reportData.setVersion(1);
        reportData.setDirty(true);
        reportData.setRow(cacheCell.getRow());
        reportData.setCol(cacheCell.getCol());
        ArrayList<TemplateDim> allTemplateDim = new ArrayList<TemplateDim>(this.report.getTemplate().getAllTemplateDim());
        Map templateDimMap = allTemplateDim.stream().filter(item -> item.getDetailDimType() != DetailDimType.PLAN_AMOUNT && item.isVisible()).collect(Collectors.toMap(TemplateDim::getDimensionId, Function.identity()));
        ArrayList<TemplateDim> targetTplDimList = new ArrayList<TemplateDim>(allTemplateDim.size());
        for (Long dimId : currDimInfoBean.getDimensionIdList()) {
            targetTplDimList.add((TemplateDim)templateDimMap.remove(dimId));
        }
        reportData.setDimList(targetTplDimList);
        reportData.setDimValList(currDimInfoBean.getMemberIdList());
        reportData.setReportPeriodId(this.report.getPeriodMemberList().get(0).getId());
        reportData.setMainTable(this.report.getTemplate().isMainTable());
        reportData.setAmountUnit(this.report.getTemplate().getAmountUnit());
        reportData.setEffectFlag(this.report.getReportStatus() == ReportStatus.ENABLE);
        if (templateDimMap.size() > 0) {
            reportData.setAuxiliaryInfo(true);
        }
        return existsReportData;
    }
}

