/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.export.excel.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.SourceBillType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.MetricHeader;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.report.SumPlanHeader;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.service.IExecBiasAnalysBizService;
import kd.tmc.fpm.business.mvc.service.ISumPlanBizService;
import kd.tmc.fpm.business.mvc.service.impl.ExecBiasAnalysBizServiceImpl;
import kd.tmc.fpm.business.mvc.service.impl.SumPlanBizServiceImpl;
import kd.tmc.fpm.business.spread.export.excel.impl.AbsReportFormsExportExcel;
import kd.tmc.fpm.business.spread.export.utils.ExecBiasPlanHeaderHelper;
import kd.tmc.fpm.business.spread.export.utils.ReportPlanHeaderHelper;
import kd.tmc.fpm.business.spread.formula.impl.DAGFormulaManager;
import kd.tmc.fpm.business.spread.generator.SpreadDataGeneratorFactory;
import kd.tmc.fpm.business.spread.generator.executor.IReportDataProcessExecutor;
import kd.tmc.fpm.business.spread.generator.executor.ReportDataProcessExecutorFactory;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.core.Sheet;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.usermodel.XSSFRow;

public class ExecBiasPlanFormsExportImpl
extends AbsReportFormsExportExcel {
    private static Log logger = LogFactory.getLog(ExecBiasPlanFormsExportImpl.class);
    private IExecBiasAnalysBizService execBiasAnalysisBizService = new ExecBiasAnalysBizServiceImpl();
    private ISumPlanBizService sumPlanBizService = new SumPlanBizServiceImpl();
    private IDimensionRepository dimRepo = new DimensionRepository();
    private List<PlanReportExportModel> planReportExportModels;
    private Set<Long> pkIds;
    private Report report;
    private FundPlanSystem system;
    private Long systemId;
    private MetricHeader metricHeader;
    private Map<Long, SumPlanHeader> reportHeaderMap;
    private Map<String, Set<Integer>> hideRowMap;
    private String reportNumber;

    public ExecBiasPlanFormsExportImpl(Set<Long> pkIds, Long systemId, MetricHeader metricHeader, Map<Long, SumPlanHeader> reportHeaderMap) {
        this.pkIds = pkIds;
        this.metricHeader = metricHeader;
        this.systemId = systemId;
        this.reportHeaderMap = reportHeaderMap;
        this.reportNumber = "";
    }

    @Override
    protected void getOriginalData() {
        ArrayList<PlanReportExportModel> planReportExportModels = new ArrayList<PlanReportExportModel>(this.pkIds.size());
        this.hideRowMap = new HashMap<String, Set<Integer>>(this.pkIds.size());
        List<Long> defaultMetricMemberIds = this.execBiasAnalysisBizService.defaultMetricMemberIds(this.systemId);
        if (this.metricHeader == null) {
            this.metricHeader = new MetricHeader();
            this.metricHeader.setMetricMemberIds(defaultMetricMemberIds);
        }
        String prop = String.join((CharSequence)",", "id", "sourcebilltype", String.join((CharSequence)".", "sourcebill", "id"));
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"fpm_execbiasanalys", (String)prop, (QFilter[])new QFilter[]{new QFilter("id", "in", this.pkIds)});
        FpmAssertUtil.isNotEmpty((Collection)queryResult, (String)"exec bias result is null");
        Map execBiasMap = queryResult.stream().collect(Collectors.toMap(k -> k.getLong("id"), Function.identity()));
        FundPlanSystem system = this.dimRepo.loadSystem(this.systemId);
        for (Long pkId : this.pkIds) {
            List<ReportCalcModel> reportCalcModelList;
            String errMsg;
            List<String> messageList;
            FpmOperateResult<Serializable> reportFpmOperateResult;
            DynamicObject execBiasAnaly = (DynamicObject)execBiasMap.get(pkId);
            String sourceBillTypeVal = execBiasAnaly.getString("sourcebilltype");
            SourceBillType sourceBillType = SourceBillType.getStatusByVal(sourceBillTypeVal);
            Long reportId = execBiasAnaly.getLong(String.join((CharSequence)".", "sourcebill", "id"));
            if (sourceBillType == SourceBillType.REPORT) {
                reportFpmOperateResult = this.execBiasAnalysisBizService.loadReport(reportId, system, this.metricHeader);
                if (!reportFpmOperateResult.isSuccess()) {
                    messageList = reportFpmOperateResult.getMessageList();
                    errMsg = messageList.stream().filter(Objects::nonNull).collect(Collectors.joining("\u3001"));
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8ba1\u5212\u7f16\u5236\u62a5\u8868\u6570\u636e\u5f02\u5e38: %1$s", (String)"ExecBiasPlanFormsExportImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]), errMsg));
                }
                Report report = reportFpmOperateResult.getData();
                IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getReportPlanExecutorOfExport(system, report);
                ReportModel reportModel = reportExecutor.executeAction();
                if (EmptyUtil.isNoEmpty((Object)reportModel)) {
                    List<ReportCalcModel> reportCalcModelList2 = reportModel.getReportCalcModelList().stream().filter(Objects::nonNull).collect(Collectors.toList());
                    if (EmptyUtil.isNoEmpty(reportCalcModelList2)) {
                        PlanReportExportModel model = new PlanReportExportModel(reportCalcModelList2, report);
                        planReportExportModels.add(model);
                    }
                    Set hideRows = reportCalcModelList2.stream().map(ReportCalcModel::getRowDimValList).flatMap(Collection::stream).filter(ReportCalcVal::isHide).map(item -> item.getRow() + ReportPlanHeaderHelper.HEADER_OFFSET_NUM).collect(Collectors.toSet());
                    this.hideRowMap.put(report.getNumber(), hideRows);
                }
                this.report = report;
                this.system = system;
                continue;
            }
            if (EmptyUtil.isNoEmpty((Object)this.reportHeaderMap.get(pkId)) && EmptyUtil.isEmpty(this.reportHeaderMap.get(pkId).getMetricMemberIds())) {
                SumPlanHeader sumPlanHeader = this.reportHeaderMap.get(pkId);
                sumPlanHeader.setMetricMemberIds(defaultMetricMemberIds);
                this.reportHeaderMap.put(pkId, sumPlanHeader);
            }
            if (!(reportFpmOperateResult = this.execBiasAnalysisBizService.loadSumReport(reportId, system, this.reportHeaderMap.get(pkId))).isSuccess()) {
                messageList = reportFpmOperateResult.getMessageList();
                errMsg = messageList.stream().filter(Objects::nonNull).collect(Collectors.joining("\u3001"));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6c47\u603b\u7f16\u5236\u62a5\u8868\u6570\u636e\u5f02\u5e38: %1$s", (String)"ExecBiasPlanFormsExportImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]), errMsg));
            }
            SumPlanRecord record = (SumPlanRecord)reportFpmOperateResult.getData();
            SumPlanReport sumPlanReport = record.getSumPlanReportList().get(0);
            IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getExecBiasAnalysisSumPlanReportExecutor(system, sumPlanReport, null);
            ReportModel reportModel = reportExecutor.executeAction();
            if (EmptyUtil.isNoEmpty((Object)reportModel) && EmptyUtil.isNoEmpty(reportCalcModelList = reportModel.getReportCalcModelList().stream().filter(Objects::nonNull).collect(Collectors.toList()))) {
                PlanReportExportModel model = new PlanReportExportModel(reportCalcModelList, sumPlanReport, record);
                planReportExportModels.add(model);
            }
            this.report = sumPlanReport;
            this.system = system;
        }
        this.planReportExportModels = planReportExportModels;
    }

    @Override
    protected String exportParamsPrepare(Map<String, Sheet> sheetMap) {
        if (EmptyUtil.isEmpty(this.planReportExportModels)) {
            return String.format(ResManager.loadKDString((String)"\u7a7a\u62a5\u8868_%1$s.xlsx", (String)"ExecBiasPlanFormsExportImpl_2", (String)"tmc-fpm-business", (Object[])new Object[0]), DateUtils.formatString((Date)new Date(), (String)"yyyyMMdd"));
        }
        String excelName = String.format("%s_%s_%s.xlsx", this.report.getPeriodMemberList().get(0).getName(), this.system.getName(), DateUtils.formatString((Date)new Date(), (String)"yyyyMMdd"));
        for (PlanReportExportModel planReportExportModel : this.planReportExportModels) {
            Report report = planReportExportModel.getReport();
            SumPlanRecord record = planReportExportModel.getRecord();
            List<ReportCalcModel> reportCalcModels = planReportExportModel.getReportCalcModels();
            for (int i = 0; i < reportCalcModels.size(); ++i) {
                String pageDimStr = reportCalcModels.get(i).getPageDimValList().stream().map(ReportCalcVal::getDisplayVal).collect(Collectors.joining("_"));
                String sheetName = String.format("%s)%s_%s_%s", i + 1, report.getCompanyMemberList().get(0).getName(), report.getName(), pageDimStr);
                ReportCalcModel reportCalcModel = reportCalcModels.get(i);
                DAGFormulaManager formulaManager = new DAGFormulaManager(reportCalcModel, null);
                ExecBiasPlanHeaderHelper.addExcelReportHeader(report, record, this.system, reportCalcModel);
                Book book = SpreadDataGeneratorFactory.createReportDataGenerator().generate(reportCalcModel);
                sheetMap.put(sheetName, book.getSheet());
            }
        }
        return excelName;
    }

    @Override
    protected void afterCreateRow(String sheetName, XSSFRow row, List<Cell> cells) {
        String number;
        Cell reportNumberCell;
        super.afterCreateRow(sheetName, row, cells);
        if (MapUtils.isEmpty(this.hideRowMap)) {
            return;
        }
        if (row.getRowNum() == 1 && Objects.nonNull(reportNumberCell = cells.get(cells.size() - 1)) && Objects.nonNull(reportNumberCell.getValue()) && !StringUtils.equals((CharSequence)(number = reportNumberCell.getValue().toString()), (CharSequence)this.reportNumber)) {
            this.reportNumber = number;
        }
        for (Map.Entry<String, Set<Integer>> entry : this.hideRowMap.entrySet()) {
            Set<Integer> hideRows;
            String number2 = entry.getKey();
            if (!sheetName.contains(number2) && !this.reportNumber.contains(number2) || !(hideRows = entry.getValue()).contains(row.getRowNum())) continue;
            row.setZeroHeight(true);
            break;
        }
    }

    private static class PlanReportExportModel {
        private List<ReportCalcModel> reportCalcModels;
        private Report report;
        private SumPlanRecord record;

        public PlanReportExportModel(List<ReportCalcModel> reportCalcModels, Report report) {
            this.reportCalcModels = reportCalcModels;
            this.report = report;
        }

        public PlanReportExportModel(List<ReportCalcModel> reportCalcModels, Report report, SumPlanRecord record) {
            this.reportCalcModels = reportCalcModels;
            this.report = report;
            this.record = record;
        }

        public List<ReportCalcModel> getReportCalcModels() {
            return this.reportCalcModels;
        }

        public Report getReport() {
            return this.report;
        }

        public SumPlanRecord getRecord() {
            return this.record;
        }
    }
}

