/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.export.excel.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AnalysisReportType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.IAnalysisReportBizService;
import kd.tmc.fpm.business.domain.service.impl.AnalysisReportBizService;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.spread.export.excel.impl.AbsReportFormsExportExcel;
import kd.tmc.fpm.business.spread.export.utils.PlanExecReportHeaderHelper;
import kd.tmc.fpm.business.spread.formula.impl.DAGFormulaManager;
import kd.tmc.fpm.business.spread.generator.SpreadDataGeneratorFactory;
import kd.tmc.fpm.business.spread.generator.executor.IReportDataProcessExecutor;
import kd.tmc.fpm.business.spread.generator.executor.ReportDataProcessExecutorFactory;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Sheet;

public class PlanExecFormsExportImpl
extends AbsReportFormsExportExcel {
    private DimensionRepository dimensionRepository;
    private IAnalysisReportBizService bizService;
    private AnalysisHeader headerInfo;
    private AnalysisHeader copyHeaderInfo;
    private ReportModel reportModel;
    private FundPlanSystem fundPlanSystem;

    public PlanExecFormsExportImpl(AnalysisHeader headerInfo) {
        this.headerInfo = headerInfo;
        this.dimensionRepository = new DimensionRepository();
        this.bizService = new AnalysisReportBizService();
        this.copyHeaderInfo = (AnalysisHeader)FpmSerializeUtil.deepCopy((Object)headerInfo, AnalysisHeader.class);
    }

    @Override
    protected void getOriginalData() {
        this.fundPlanSystem = this.dimensionRepository.loadSystem(this.headerInfo.getBodySystemId());
        FpmOperateResult<Report> reportFpmOperateResult = this.bizService.loadReport(AnalysisReportType.PLANEXECANALYS, this.copyHeaderInfo, this.fundPlanSystem);
        Report report = reportFpmOperateResult.getData();
        if (report.getExchangeRateTableId() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7f16\u62a5\u671f\u95f4\u5747\u65e0\u7f16\u62a5\u6570\u636e\uff0c\u65e0\u6570\u636e\u5bfc\u51fa", (String)"PlanExecFormsExportImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        this.headerInfo.setExchangeRateTableId(report.getExchangeRateTableId());
        this.headerInfo.setExchangeRateDate(report.getExchangeRateDate());
        IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getAnalysisReportPlanExecExecutorOfExport(this.fundPlanSystem, report, this.headerInfo);
        this.reportModel = reportExecutor.executeAction();
    }

    @Override
    protected String exportParamsPrepare(Map<String, Sheet> sheetMap) {
        List<ReportCalcModel> reportCalcModels = this.reportModel.getReportCalcModelList();
        if (EmptyUtil.isEmpty(reportCalcModels)) {
            return String.format(ResManager.loadKDString((String)"\u7a7a\u62a5\u8868_%1$s.xlsx", (String)"PlanExecFormsExportImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]), DateUtils.formatString((Date)new Date(), (String)"yyyyMMdd"));
        }
        String tebleType = ResManager.loadKDString((String)"\u8ba1\u5212\u6267\u884c\u5206\u6790\u8868", (String)"PlanExecFormsExportImpl_2", (String)"tmc-fpm-business", (Object[])new Object[0]);
        String excelName = String.format("%s_%s.xlsx", tebleType, DateUtils.formatString((Date)new Date(), (String)"yyyyMMdd"));
        for (int i = 0; i < reportCalcModels.size(); ++i) {
            String sheetName = "";
            ReportCalcModel reportCalcModel = reportCalcModels.get(i);
            new DAGFormulaManager(reportCalcModel, null);
            PlanExecReportHeaderHelper.addExcelReportHeader(this.headerInfo, this.fundPlanSystem, reportCalcModel);
            Book book = SpreadDataGeneratorFactory.createReportDataGenerator().generate(reportCalcModel);
            sheetMap.put(sheetName, book.getSheet());
        }
        return excelName;
    }
}

